/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auditlog.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.flipkart.zjsonpatch.JsonDiff;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.SpecialPermission;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkShardRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.env.Environment;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.get.GetResult;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.auditlog.config.AuditConfig;
import org.opensearch.security.auditlog.impl.AuditCategory;
import org.opensearch.security.auditlog.impl.AuditMessage;
import org.opensearch.security.auditlog.impl.RequestResolver;
import org.opensearch.security.compliance.ComplianceConfig;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.support.Base64Helper;
import org.opensearch.security.user.User;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportRequest;

public abstract class AbstractAuditLog
implements AuditLog {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final ThreadPool threadPool;
    private final IndexNameExpressionResolver resolver;
    private final ClusterService clusterService;
    private final Settings settings;
    private volatile AuditConfig.Filter auditConfigFilter;
    private final String securityIndex;
    private volatile ComplianceConfig complianceConfig;
    private final Environment environment;
    private AtomicBoolean externalConfigLogged = new AtomicBoolean();
    private static final List<String> writeClasses = new ArrayList<String>();

    protected abstract void enableRoutes();

    protected AbstractAuditLog(Settings settings, ThreadPool threadPool, IndexNameExpressionResolver resolver, ClusterService clusterService, Environment environment) {
        writeClasses.add(IndexRequest.class.getSimpleName());
        writeClasses.add(UpdateRequest.class.getSimpleName());
        writeClasses.add(BulkRequest.class.getSimpleName());
        writeClasses.add(BulkShardRequest.class.getSimpleName());
        writeClasses.add(DeleteRequest.class.getSimpleName());
        this.threadPool = threadPool;
        this.settings = settings;
        this.resolver = resolver;
        this.clusterService = clusterService;
        this.securityIndex = settings.get("plugins.security.config_index_name", ".opendistro_security");
        this.environment = environment;
    }

    protected void onAuditConfigFilterChanged(AuditConfig.Filter auditConfigFilter) {
        this.auditConfigFilter = auditConfigFilter;
        this.auditConfigFilter.log(this.log);
    }

    protected void onComplianceConfigChanged(ComplianceConfig complianceConfig) {
        this.complianceConfig = complianceConfig;
        this.enableRoutes();
        this.complianceConfig.log(this.log);
        this.logExternalConfig();
    }

    @Override
    public ComplianceConfig getComplianceConfig() {
        return this.complianceConfig;
    }

    @Override
    public void logFailedLogin(String effectiveUser, boolean securityadmin, String initiatingUser, RestRequest request) {
        if (!this.checkRestFilter(AuditCategory.FAILED_LOGIN, effectiveUser, request)) {
            return;
        }
        AuditMessage msg = new AuditMessage(AuditCategory.FAILED_LOGIN, this.clusterService, this.getOrigin(), AuditLog.Origin.REST);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        msg.addRestRequestInfo(request, this.auditConfigFilter);
        msg.addInitiatingUser(initiatingUser);
        msg.addEffectiveUser(effectiveUser);
        msg.addIsAdminDn(securityadmin);
        this.save(msg);
    }

    @Override
    public void logSucceededLogin(String effectiveUser, boolean securityadmin, String initiatingUser, RestRequest request) {
        if (!this.checkRestFilter(AuditCategory.AUTHENTICATED, effectiveUser, request)) {
            return;
        }
        AuditMessage msg = new AuditMessage(AuditCategory.AUTHENTICATED, this.clusterService, this.getOrigin(), AuditLog.Origin.REST);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        msg.addRestRequestInfo(request, this.auditConfigFilter);
        msg.addInitiatingUser(initiatingUser);
        msg.addEffectiveUser(effectiveUser);
        msg.addIsAdminDn(securityadmin);
        this.save(msg);
    }

    @Override
    public void logMissingPrivileges(String privilege, String effectiveUser, RestRequest request) {
        if (!this.checkRestFilter(AuditCategory.MISSING_PRIVILEGES, effectiveUser, request)) {
            return;
        }
        AuditMessage msg = new AuditMessage(AuditCategory.MISSING_PRIVILEGES, this.clusterService, this.getOrigin(), AuditLog.Origin.REST);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        msg.addRestRequestInfo(request, this.auditConfigFilter);
        msg.addEffectiveUser(effectiveUser);
        this.save(msg);
    }

    @Override
    public void logGrantedPrivileges(String effectiveUser, RestRequest request) {
        if (!this.checkRestFilter(AuditCategory.GRANTED_PRIVILEGES, effectiveUser, request)) {
            return;
        }
        AuditMessage msg = new AuditMessage(AuditCategory.GRANTED_PRIVILEGES, this.clusterService, this.getOrigin(), AuditLog.Origin.REST);
        msg.addRemoteAddress(this.getRemoteAddress());
        msg.addRestRequestInfo(request, this.auditConfigFilter);
        msg.addEffectiveUser(effectiveUser);
        this.save(msg);
    }

    @Override
    public void logMissingPrivileges(String privilege, TransportRequest request, Task task) {
        String action = null;
        if (!this.checkTransportFilter(AuditCategory.MISSING_PRIVILEGES, privilege, this.getUser(), request)) {
            return;
        }
        TransportAddress remoteAddress = this.getRemoteAddress();
        List<AuditMessage> msgs = RequestResolver.resolve(AuditCategory.MISSING_PRIVILEGES, this.getOrigin(), action, privilege, this.getUser(), null, null, remoteAddress, request, this.getThreadContextHeaders(), task, this.resolver, this.clusterService, this.settings, this.auditConfigFilter.shouldLogRequestBody(), this.auditConfigFilter.shouldResolveIndices(), this.auditConfigFilter.shouldResolveBulkRequests(), this.securityIndex, this.auditConfigFilter.shouldExcludeSensitiveHeaders(), null);
        for (AuditMessage msg : msgs) {
            this.save(msg);
        }
    }

    @Override
    public void logGrantedPrivileges(String privilege, TransportRequest request, Task task) {
        String action = null;
        if (!this.checkTransportFilter(AuditCategory.GRANTED_PRIVILEGES, privilege, this.getUser(), request)) {
            return;
        }
        TransportAddress remoteAddress = this.getRemoteAddress();
        List<AuditMessage> msgs = RequestResolver.resolve(AuditCategory.GRANTED_PRIVILEGES, this.getOrigin(), action, privilege, this.getUser(), null, null, remoteAddress, request, this.getThreadContextHeaders(), task, this.resolver, this.clusterService, this.settings, this.auditConfigFilter.shouldLogRequestBody(), this.auditConfigFilter.shouldResolveIndices(), this.auditConfigFilter.shouldResolveBulkRequests(), this.securityIndex, this.auditConfigFilter.shouldExcludeSensitiveHeaders(), null);
        for (AuditMessage msg : msgs) {
            this.save(msg);
        }
    }

    @Override
    public void logIndexEvent(String privilege, TransportRequest request, Task task) {
        if (!this.checkTransportFilter(AuditCategory.INDEX_EVENT, privilege, this.getUser(), request)) {
            return;
        }
        if (!privilege.startsWith("indices:admin/")) {
            return;
        }
        TransportAddress remoteAddress = this.getRemoteAddress();
        List<AuditMessage> msgs = RequestResolver.resolve(AuditCategory.INDEX_EVENT, this.getOrigin(), null, privilege, this.getUser(), null, null, remoteAddress, request, this.getThreadContextHeaders(), task, this.resolver, this.clusterService, this.settings, this.auditConfigFilter.shouldLogRequestBody(), this.auditConfigFilter.shouldResolveIndices(), this.auditConfigFilter.shouldResolveBulkRequests(), this.securityIndex, this.auditConfigFilter.shouldExcludeSensitiveHeaders(), null);
        msgs.forEach(this::save);
    }

    @Override
    public void logBadHeaders(TransportRequest request, String action, Task task) {
        if (!this.checkTransportFilter(AuditCategory.BAD_HEADERS, action, this.getUser(), request)) {
            return;
        }
        TransportAddress remoteAddress = this.getRemoteAddress();
        List<AuditMessage> msgs = RequestResolver.resolve(AuditCategory.BAD_HEADERS, this.getOrigin(), action, null, this.getUser(), null, null, remoteAddress, request, this.getThreadContextHeaders(), task, this.resolver, this.clusterService, this.settings, this.auditConfigFilter.shouldLogRequestBody(), this.auditConfigFilter.shouldResolveIndices(), this.auditConfigFilter.shouldResolveBulkRequests(), this.securityIndex, this.auditConfigFilter.shouldExcludeSensitiveHeaders(), null);
        for (AuditMessage msg : msgs) {
            this.save(msg);
        }
    }

    @Override
    public void logBadHeaders(RestRequest request) {
        if (!this.checkRestFilter(AuditCategory.BAD_HEADERS, this.getUser(), request)) {
            return;
        }
        AuditMessage msg = new AuditMessage(AuditCategory.BAD_HEADERS, this.clusterService, this.getOrigin(), AuditLog.Origin.REST);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        msg.addRestRequestInfo(request, this.auditConfigFilter);
        msg.addEffectiveUser(this.getUser());
        this.save(msg);
    }

    @Override
    public void logSecurityIndexAttempt(TransportRequest request, String action, Task task) {
        if (!this.checkTransportFilter(AuditCategory.OPENDISTRO_SECURITY_INDEX_ATTEMPT, action, this.getUser(), request)) {
            return;
        }
        TransportAddress remoteAddress = this.getRemoteAddress();
        List<AuditMessage> msgs = RequestResolver.resolve(AuditCategory.OPENDISTRO_SECURITY_INDEX_ATTEMPT, this.getOrigin(), action, null, this.getUser(), false, null, remoteAddress, request, this.getThreadContextHeaders(), task, this.resolver, this.clusterService, this.settings, this.auditConfigFilter.shouldLogRequestBody(), this.auditConfigFilter.shouldResolveIndices(), this.auditConfigFilter.shouldResolveBulkRequests(), this.securityIndex, this.auditConfigFilter.shouldExcludeSensitiveHeaders(), null);
        for (AuditMessage msg : msgs) {
            this.save(msg);
        }
    }

    @Override
    public void logSSLException(TransportRequest request, Throwable t, String action, Task task) {
        if (!this.checkTransportFilter(AuditCategory.SSL_EXCEPTION, action, this.getUser(), request)) {
            return;
        }
        TransportAddress remoteAddress = this.getRemoteAddress();
        List<AuditMessage> msgs = RequestResolver.resolve(AuditCategory.SSL_EXCEPTION, AuditLog.Origin.TRANSPORT, action, null, this.getUser(), false, null, remoteAddress, request, this.getThreadContextHeaders(), task, this.resolver, this.clusterService, this.settings, this.auditConfigFilter.shouldLogRequestBody(), this.auditConfigFilter.shouldResolveIndices(), this.auditConfigFilter.shouldResolveBulkRequests(), this.securityIndex, this.auditConfigFilter.shouldExcludeSensitiveHeaders(), t);
        for (AuditMessage msg : msgs) {
            this.save(msg);
        }
    }

    @Override
    public void logSSLException(RestRequest request, Throwable t) {
        if (!this.checkRestFilter(AuditCategory.SSL_EXCEPTION, this.getUser(), request)) {
            return;
        }
        AuditMessage msg = new AuditMessage(AuditCategory.SSL_EXCEPTION, this.clusterService, AuditLog.Origin.REST, AuditLog.Origin.REST);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        msg.addRestRequestInfo(request, this.auditConfigFilter);
        msg.addException(t);
        msg.addEffectiveUser(this.getUser());
        this.save(msg);
    }

    @Override
    public void logDocumentRead(String index, String id, ShardId shardId, Map<String, String> fieldNameValues) {
        String effectiveUser;
        ComplianceConfig complianceConfig = this.getComplianceConfig();
        if (complianceConfig == null || !complianceConfig.readHistoryEnabledForIndex(index)) {
            return;
        }
        String initiatingRequestClass = this.threadPool.getThreadContext().getHeader("_opendistro_security_initial_action_class_header");
        if (initiatingRequestClass != null && writeClasses.contains(initiatingRequestClass)) {
            return;
        }
        AuditCategory category = this.securityIndex.equals(index) ? AuditCategory.COMPLIANCE_INTERNAL_CONFIG_READ : AuditCategory.COMPLIANCE_DOC_READ;
        if (!this.checkComplianceFilter(category, effectiveUser = this.getUser(), this.getOrigin(), complianceConfig)) {
            return;
        }
        if (fieldNameValues != null && !fieldNameValues.isEmpty()) {
            AuditMessage msg = new AuditMessage(category, this.clusterService, this.getOrigin(), null);
            TransportAddress remoteAddress = this.getRemoteAddress();
            msg.addRemoteAddress(remoteAddress);
            msg.addEffectiveUser(effectiveUser);
            msg.addIndices(new String[]{index});
            msg.addResolvedIndices(new String[]{index});
            msg.addShardId(shardId);
            msg.addId(id);
            try {
                if (complianceConfig.shouldLogReadMetadataOnly()) {
                    try {
                        XContentBuilder builder = XContentBuilder.builder((XContent)JsonXContent.jsonXContent);
                        builder.startObject();
                        builder.field("field_names", fieldNameValues.keySet());
                        builder.endObject();
                        builder.close();
                        msg.addUnescapedJsonToRequestBody(builder.toString());
                    }
                    catch (IOException e) {
                        this.log.error(e.toString());
                    }
                } else if (this.securityIndex.equals(index) && !"tattr".equals(id)) {
                    try {
                        Map<String, String> map = fieldNameValues.entrySet().stream().collect(Collectors.toMap(entry -> "id", entry -> new String(BaseEncoding.base64().decode((CharSequence)entry.getValue()), StandardCharsets.UTF_8)));
                        msg.addSecurityConfigMapToRequestBody(Utils.convertJsonToxToStructuredMap(map.get("id")), id);
                    }
                    catch (Exception e) {
                        msg.addSecurityConfigMapToRequestBody(fieldNameValues, id);
                    }
                } else {
                    msg.addMapToRequestBody(fieldNameValues);
                }
            }
            catch (Exception e) {
                this.log.error("Unable to generate request body for {} and {}", (Object)msg.toPrettyString(), fieldNameValues, (Object)e);
            }
            this.save(msg);
        }
    }

    @Override
    public void logDocumentWritten(ShardId shardId, GetResult originalResult, Engine.Index currentIndex, Engine.IndexResult result) {
        AuditMessage msg;
        String id;
        ComplianceConfig complianceConfig;
        block37: {
            String effectiveUser;
            complianceConfig = this.getComplianceConfig();
            if (complianceConfig == null || !complianceConfig.writeHistoryEnabledForIndex(shardId.getIndexName())) {
                return;
            }
            AuditCategory category = this.securityIndex.equals(shardId.getIndexName()) ? AuditCategory.COMPLIANCE_INTERNAL_CONFIG_WRITE : AuditCategory.COMPLIANCE_DOC_WRITE;
            if (!this.checkComplianceFilter(category, effectiveUser = this.getUser(), this.getOrigin(), complianceConfig)) {
                return;
            }
            id = currentIndex.id();
            msg = new AuditMessage(category, this.clusterService, this.getOrigin(), null);
            TransportAddress remoteAddress = this.getRemoteAddress();
            msg.addRemoteAddress(remoteAddress);
            msg.addEffectiveUser(effectiveUser);
            msg.addIndices(new String[]{shardId.getIndexName()});
            msg.addResolvedIndices(new String[]{shardId.getIndexName()});
            msg.addId(id);
            msg.addShardId(shardId);
            msg.addComplianceDocVersion(result.getVersion());
            msg.addComplianceOperation(result.isCreated() ? AuditLog.Operation.CREATE : AuditLog.Operation.UPDATE);
            if (complianceConfig.shouldLogDiffsForWrite() && originalResult != null && originalResult.isExists() && originalResult.internalSourceRef() != null) {
                try {
                    JsonNode diffnode;
                    String originalSource = null;
                    String currentSource = null;
                    if (this.securityIndex.equals(shardId.getIndexName())) {
                        Object base64;
                        XContentParser parser;
                        try {
                            parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (BytesReference)originalResult.internalSourceRef(), (MediaType)XContentType.JSON);
                            try {
                                base64 = parser.map().values().iterator().next();
                                originalSource = base64 instanceof String ? new String(BaseEncoding.base64().decode((CharSequence)((String)base64)), StandardCharsets.UTF_8) : XContentHelper.convertToJson((BytesReference)originalResult.internalSourceRef(), (boolean)false, (MediaType)XContentType.JSON);
                            }
                            finally {
                                if (parser != null) {
                                    parser.close();
                                }
                            }
                        }
                        catch (Exception e) {
                            this.log.error(e.toString());
                        }
                        try {
                            parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (BytesReference)currentIndex.source(), (MediaType)XContentType.JSON);
                            try {
                                base64 = parser.map().values().iterator().next();
                                currentSource = base64 instanceof String ? new String(BaseEncoding.base64().decode((CharSequence)((String)base64)), StandardCharsets.UTF_8) : XContentHelper.convertToJson((BytesReference)currentIndex.source(), (boolean)false, (MediaType)XContentType.JSON);
                            }
                            finally {
                                if (parser != null) {
                                    parser.close();
                                }
                            }
                        }
                        catch (Exception e) {
                            this.log.error(e.toString());
                        }
                        diffnode = JsonDiff.asJson((JsonNode)DefaultObjectMapper.objectMapper.readTree(originalSource), (JsonNode)DefaultObjectMapper.objectMapper.readTree(currentSource));
                        msg.addSecurityConfigWriteDiffSource(diffnode.size() == 0 ? "" : diffnode.toString(), id);
                        break block37;
                    }
                    originalSource = XContentHelper.convertToJson((BytesReference)originalResult.internalSourceRef(), (boolean)false, (MediaType)XContentType.JSON);
                    currentSource = XContentHelper.convertToJson((BytesReference)currentIndex.source(), (boolean)false, (MediaType)XContentType.JSON);
                    diffnode = JsonDiff.asJson((JsonNode)DefaultObjectMapper.objectMapper.readTree(originalSource), (JsonNode)DefaultObjectMapper.objectMapper.readTree(currentSource));
                    msg.addComplianceWriteDiffSource(diffnode.size() == 0 ? "" : diffnode.toString());
                }
                catch (Exception e) {
                    this.log.error("Unable to generate diff for {}", (Object)msg.toPrettyString(), (Object)e);
                }
            }
        }
        if (!complianceConfig.shouldLogWriteMetadataOnly()) {
            if (this.securityIndex.equals(shardId.getIndexName())) {
                try (XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (BytesReference)currentIndex.source(), (MediaType)XContentType.JSON);){
                    Object base64 = parser.map().values().iterator().next();
                    if (base64 instanceof String) {
                        msg.addSecurityConfigContentToRequestBody(new String(BaseEncoding.base64().decode((CharSequence)((String)base64)), StandardCharsets.UTF_8), id);
                    } else {
                        msg.addSecurityConfigTupleToRequestBody((Tuple<XContentType, BytesReference>)new Tuple((Object)XContentType.JSON, (Object)currentIndex.source()), id);
                    }
                }
                catch (Exception e) {
                    this.log.error(e.toString());
                }
            } else {
                msg.addTupleToRequestBody((Tuple<MediaType, BytesReference>)new Tuple((Object)XContentType.JSON, (Object)currentIndex.source()));
            }
        }
        this.save(msg);
    }

    @Override
    public void logDocumentDeleted(ShardId shardId, Engine.Delete delete, Engine.DeleteResult result) {
        String effectiveUser = this.getUser();
        ComplianceConfig complianceConfig = this.getComplianceConfig();
        if (complianceConfig == null || !complianceConfig.isEnabled() || !this.checkComplianceFilter(AuditCategory.COMPLIANCE_DOC_WRITE, effectiveUser, this.getOrigin(), complianceConfig)) {
            return;
        }
        AuditMessage msg = new AuditMessage(AuditCategory.COMPLIANCE_DOC_WRITE, this.clusterService, this.getOrigin(), null);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        msg.addEffectiveUser(effectiveUser);
        msg.addIndices(new String[]{shardId.getIndexName()});
        msg.addResolvedIndices(new String[]{shardId.getIndexName()});
        msg.addId(delete.id());
        msg.addShardId(shardId);
        msg.addComplianceDocVersion(result.getVersion());
        msg.addComplianceOperation(AuditLog.Operation.DELETE);
        this.save(msg);
    }

    protected void logExternalConfig() {
        ComplianceConfig complianceConfig = this.getComplianceConfig();
        if (complianceConfig == null || !complianceConfig.isEnabled() || !complianceConfig.shouldLogExternalConfig() || !this.checkComplianceFilter(AuditCategory.COMPLIANCE_EXTERNAL_CONFIG, null, this.getOrigin(), complianceConfig) || this.externalConfigLogged.getAndSet(true)) {
            return;
        }
        this.log.info("logging external config");
        Map<String, Object> configAsMap = Utils.convertJsonToxToStructuredMap((ToXContent)this.settings);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        Map<String, String> envAsMap = AccessController.doPrivileged(new PrivilegedAction<Map<String, String>>(){

            @Override
            public Map<String, String> run() {
                return System.getenv();
            }
        });
        Map propsAsMap = AccessController.doPrivileged(new PrivilegedAction<Map>(){

            @Override
            public Map run() {
                return System.getProperties();
            }
        });
        String sha256 = DigestUtils.sha256Hex((String)(configAsMap.toString() + envAsMap.toString() + propsAsMap.toString()));
        AuditMessage msg = new AuditMessage(AuditCategory.COMPLIANCE_EXTERNAL_CONFIG, this.clusterService, null, null);
        try (XContentBuilder builder = XContentBuilder.builder((XContent)XContentType.JSON.xContent());){
            builder.startObject();
            builder.startObject("external_configuration");
            builder.field("opensearch_yml", configAsMap);
            builder.field("os_environment", envAsMap);
            builder.field("java_properties", propsAsMap);
            builder.field("sha256_checksum", sha256);
            builder.endObject();
            builder.endObject();
            builder.close();
            msg.addUnescapedJsonToRequestBody(builder.toString());
        }
        catch (Exception e) {
            this.log.error("Unable to build message", (Throwable)e);
        }
        HashMap<String, Path> paths = new HashMap<String, Path>();
        for (String key : this.settings.keySet()) {
            String value;
            if (!key.startsWith("opendistro_security") || !key.contains("filepath") && !key.contains("file_path") || (value = this.settings.get(key)) == null || value.isEmpty()) continue;
            Path path = value.startsWith("/") ? Paths.get(value, new String[0]) : this.environment.configFile().resolve(value);
            paths.put(key, path);
        }
        msg.addFileInfos(paths);
        this.save(msg);
    }

    private AuditLog.Origin getOrigin() {
        String origin = (String)this.threadPool.getThreadContext().getTransient("_opendistro_security_origin");
        if (origin == null && this.threadPool.getThreadContext().getHeader("_opendistro_security_origin_header") != null) {
            origin = this.threadPool.getThreadContext().getHeader("_opendistro_security_origin_header");
        }
        return origin == null ? null : AuditLog.Origin.valueOf(origin);
    }

    private TransportAddress getRemoteAddress() {
        TransportAddress address = (TransportAddress)this.threadPool.getThreadContext().getTransient("_opendistro_security_remote_address");
        if (address == null && this.threadPool.getThreadContext().getHeader("_opendistro_security_remote_address_header") != null) {
            address = new TransportAddress((InetSocketAddress)Base64Helper.deserializeObject(this.threadPool.getThreadContext().getHeader("_opendistro_security_remote_address_header")));
        }
        return address;
    }

    private String getUser() {
        User user = (User)this.threadPool.getThreadContext().getTransient("_opendistro_security_user");
        if (user == null && this.threadPool.getThreadContext().getHeader("_opendistro_security_user_header") != null) {
            user = (User)Base64Helper.deserializeObject(this.threadPool.getThreadContext().getHeader("_opendistro_security_user_header"));
        }
        return user == null ? null : user.getName();
    }

    private Map<String, String> getThreadContextHeaders() {
        return this.threadPool.getThreadContext().getHeaders();
    }

    @VisibleForTesting
    boolean checkTransportFilter(AuditCategory category, String action, String effectiveUser, TransportRequest request) {
        boolean isTraceEnabled = this.log.isTraceEnabled();
        if (isTraceEnabled) {
            this.log.trace("Check category:{}, action:{}, effectiveUser:{}, request:{}", (Object)category, (Object)action, (Object)effectiveUser, request == null ? null : request.getClass().getSimpleName());
        }
        if (!this.auditConfigFilter.isTransportApiAuditEnabled()) {
            return false;
        }
        if (action != null && action.startsWith("internal:")) {
            return false;
        }
        if (this.auditConfigFilter.isAuditDisabled(effectiveUser)) {
            if (isTraceEnabled) {
                this.log.trace("Skipped audit log message because of user {} is ignored", (Object)effectiveUser);
            }
            return false;
        }
        if (request != null && (this.auditConfigFilter.isRequestAuditDisabled(action) || this.auditConfigFilter.isRequestAuditDisabled(request.getClass().getSimpleName()))) {
            if (isTraceEnabled) {
                this.log.trace("Skipped audit log message because request {} is ignored", (Object)(action + "#" + request.getClass().getSimpleName()));
            }
            return false;
        }
        if (!this.auditConfigFilter.getDisabledTransportCategories().contains((Object)category)) {
            return true;
        }
        if (isTraceEnabled) {
            this.log.trace("Skipped audit log message because category {} not enabled", (Object)category);
        }
        return false;
    }

    private boolean checkComplianceFilter(AuditCategory category, String effectiveUser, AuditLog.Origin origin, ComplianceConfig complianceConfig) {
        boolean isTraceEnabled = this.log.isTraceEnabled();
        if (isTraceEnabled) {
            this.log.trace("Check for COMPLIANCE category:{}, effectiveUser:{}, origin: {}", (Object)category, (Object)effectiveUser, (Object)origin);
        }
        if (origin == AuditLog.Origin.LOCAL && effectiveUser == null && category != AuditCategory.COMPLIANCE_EXTERNAL_CONFIG) {
            if (isTraceEnabled) {
                this.log.trace("Skipped compliance log message because of null user and local origin");
            }
            return false;
        }
        if ((category == AuditCategory.COMPLIANCE_DOC_READ || category == AuditCategory.COMPLIANCE_INTERNAL_CONFIG_READ) && effectiveUser != null && complianceConfig.isComplianceReadAuditDisabled(effectiveUser)) {
            if (isTraceEnabled) {
                this.log.trace("Skipped compliance log message because of user {} is ignored", (Object)effectiveUser);
            }
            return false;
        }
        if ((category == AuditCategory.COMPLIANCE_DOC_WRITE || category == AuditCategory.COMPLIANCE_INTERNAL_CONFIG_WRITE) && effectiveUser != null && complianceConfig.isComplianceWriteAuditDisabled(effectiveUser)) {
            if (isTraceEnabled) {
                this.log.trace("Skipped compliance log message because of user {} is ignored", (Object)effectiveUser);
            }
            return false;
        }
        return true;
    }

    @VisibleForTesting
    boolean checkRestFilter(AuditCategory category, String effectiveUser, RestRequest request) {
        boolean isTraceEnabled = this.log.isTraceEnabled();
        if (isTraceEnabled) {
            this.log.trace("Check for REST category:{}, effectiveUser:{}, request:{}", (Object)category, (Object)effectiveUser, (Object)(request == null ? null : request.path()));
        }
        if (!this.auditConfigFilter.isRestApiAuditEnabled()) {
            return false;
        }
        if (this.auditConfigFilter.isAuditDisabled(effectiveUser)) {
            if (isTraceEnabled) {
                this.log.trace("Skipped audit log message because of user {} is ignored", (Object)effectiveUser);
            }
            return false;
        }
        if (request != null && this.auditConfigFilter.isRequestAuditDisabled(request.path())) {
            if (isTraceEnabled) {
                this.log.trace("Skipped audit log message because request {} is ignored", (Object)request.path());
            }
            return false;
        }
        if (!this.auditConfigFilter.getDisabledRestCategories().contains((Object)category)) {
            return true;
        }
        if (isTraceEnabled) {
            this.log.trace("Skipped audit log message because category {} not enabled", (Object)category);
        }
        return false;
    }

    protected abstract void save(AuditMessage var1);
}

