/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.spi;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opensearch.painless.spi.WhitelistClass;
import org.opensearch.painless.spi.WhitelistClassBinding;
import org.opensearch.painless.spi.WhitelistInstanceBinding;
import org.opensearch.painless.spi.WhitelistLoader;
import org.opensearch.painless.spi.WhitelistMethod;
import org.opensearch.painless.spi.annotation.WhitelistAnnotationParser;

public final class Whitelist {
    private static final String[] BASE_WHITELIST_FILES = new String[]{"org.opensearch.txt", "java.lang.txt", "java.math.txt", "java.text.txt", "java.time.txt", "java.time.chrono.txt", "java.time.format.txt", "java.time.temporal.txt", "java.time.zone.txt", "java.util.txt", "java.util.function.txt", "java.util.regex.txt", "java.util.stream.txt"};
    public static final List<Whitelist> BASE_WHITELISTS = Collections.singletonList(WhitelistLoader.loadFromResourceFiles(Whitelist.class, WhitelistAnnotationParser.BASE_ANNOTATION_PARSERS, BASE_WHITELIST_FILES));
    public final ClassLoader classLoader;
    public final List<WhitelistClass> whitelistClasses;
    public final List<WhitelistMethod> whitelistImportedMethods;
    public final List<WhitelistClassBinding> whitelistClassBindings;
    public final List<WhitelistInstanceBinding> whitelistInstanceBindings;

    public Whitelist(ClassLoader classLoader, List<WhitelistClass> whitelistClasses, List<WhitelistMethod> whitelistImportedMethods, List<WhitelistClassBinding> whitelistClassBindings, List<WhitelistInstanceBinding> whitelistInstanceBindings) {
        this.classLoader = Objects.requireNonNull(classLoader);
        this.whitelistClasses = Collections.unmodifiableList(Objects.requireNonNull(whitelistClasses));
        this.whitelistImportedMethods = Collections.unmodifiableList(Objects.requireNonNull(whitelistImportedMethods));
        this.whitelistClassBindings = Collections.unmodifiableList(Objects.requireNonNull(whitelistClassBindings));
        this.whitelistInstanceBindings = Collections.unmodifiableList(Objects.requireNonNull(whitelistInstanceBindings));
    }
}

