/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.setting;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Dictionary;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.bootstrap.BootstrapInfo;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.SecureSetting;
import org.opensearch.common.settings.SecureString;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.notifications.core.utils.HelpersKt;
import org.opensearch.notifications.core.utils.OpenForTesting;
import org.opensearch.notifications.spi.model.SecureDestinationSettings;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b6\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010p\u001a\u00020q2\u0006\u0010r\u001a\u00020sJ<\u0010t\u001a\n\u0012\u0004\u0012\u0002Hu\u0018\u00010\u0004\"\u0004\b\u0000\u0010u2\u0006\u0010v\u001a\u00020\u00062\f\u0010w\u001a\b\u0012\u0004\u0012\u0002Hu0%2\u0006\u0010x\u001a\u00020\u00062\u0006\u0010y\u001a\u00020\u0006H\u0002J\u0010\u0010z\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0005J4\u0010{\u001a\u0004\u0018\u0001Hu\"\u0004\b\u0000\u0010u2\u0006\u0010|\u001a\u00020}2\u0006\u0010~\u001a\u00020\u00062\f\u0010\u007f\u001a\b\u0012\u0004\u0012\u0002Hu0%H\u0002\u00a2\u0006\u0003\u0010\u0080\u0001J\u001b\u0010\u0081\u0001\u001a\u0004\u0018\u00010\u00162\u0006\u0010|\u001a\u00020}2\u0006\u0010~\u001a\u00020\u0006H\u0002J\u001b\u0010\u0082\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010|\u001a\u00020}J\t\u0010\u0083\u0001\u001a\u00020qH\u0007J\u0011\u0010\u0084\u0001\u001a\u00020q2\u0006\u0010r\u001a\u00020sH\u0002J\u0011\u0010\u0085\u0001\u001a\u00020q2\u0006\u0010r\u001a\u00020sH\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\bR\u000e\u0010#\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\bR\u000e\u0010)\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\bR\u000e\u0010-\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001d\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\bR\u000e\u00102\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\b\u0012\u0004\u0012\u00020&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u00106\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\bR\u000e\u00108\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u00109\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\bR\u000e\u0010;\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010=\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\bR\u000e\u0010?\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010@\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010\bR\u000e\u0010B\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R \u0010C\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\u001a\u0010H\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\u001a\u0010M\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010N\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00160\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR\u001a\u0010S\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010J\"\u0004\bU\u0010LR\u001a\u0010V\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010J\"\u0004\bX\u0010LR \u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u0010E\"\u0004\b[\u0010GR\u001b\u0010\\\u001a\u00020]8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b`\u0010a\u001a\u0004\b^\u0010_R\u001a\u0010b\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u0010J\"\u0004\bd\u0010LR\u001a\u0010e\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bf\u0010J\"\u0004\bg\u0010LR\u001a\u0010h\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bi\u0010J\"\u0004\bj\u0010LR\u001a\u0010k\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bl\u0010m\"\u0004\bn\u0010o\u00a8\u0006\u0086\u0001"}, d2={"Lorg/opensearch/notifications/core/setting/PluginSettings;", "", "()V", "ALERTING_HOST_DENY_LIST", "Lorg/opensearch/common/settings/Setting;", "", "", "getALERTING_HOST_DENY_LIST", "()Lorg/opensearch/common/settings/Setting;", "ALERTING_HOST_DENY_LIST_KEY", "ALLOWED_CONFIG_TYPES", "getALLOWED_CONFIG_TYPES", "ALLOWED_CONFIG_TYPE_KEY", "CONNECTION_TIMEOUT_MILLISECONDS", "", "getCONNECTION_TIMEOUT_MILLISECONDS", "CONNECTION_TIMEOUT_MILLISECONDS_KEY", "DECIMAL_RADIX", "DEFAULT_ALLOWED_CONFIG_TYPES", "DEFAULT_CONNECTION_TIMEOUT_MILLISECONDS", "DEFAULT_DESTINATION_SETTINGS", "", "Lorg/opensearch/notifications/spi/model/SecureDestinationSettings;", "DEFAULT_EMAIL_SIZE_LIMIT", "DEFAULT_HOST_DENY_LIST", "DEFAULT_MAX_CONNECTIONS", "DEFAULT_MAX_CONNECTIONS_PER_ROUTE", "DEFAULT_MINIMUM_EMAIL_HEADER_LENGTH", "DEFAULT_SOCKET_TIMEOUT_MILLISECONDS", "DEFAULT_TOOLTIP_SUPPORT", "", "EMAIL_DESTINATION_SETTING_PREFIX", "EMAIL_KEY_PREFIX", "EMAIL_MINIMUM_HEADER_LENGTH", "getEMAIL_MINIMUM_HEADER_LENGTH", "EMAIL_MINIMUM_HEADER_LENGTH_KEY", "EMAIL_PASSWORD", "Lorg/opensearch/common/settings/Setting$AffixSetting;", "Lorg/opensearch/common/settings/SecureString;", "EMAIL_SIZE_LIMIT", "getEMAIL_SIZE_LIMIT", "EMAIL_SIZE_LIMIT_KEY", "EMAIL_USERNAME", "HOST_DENY_LIST", "getHOST_DENY_LIST", "HOST_DENY_LIST_KEY", "HTTP_CONNECTION_KEY_PREFIX", "KEY_PREFIX", "LEGACY_ALERTING_HOST_DENY_LIST", "getLEGACY_ALERTING_HOST_DENY_LIST", "LEGACY_ALERTING_HOST_DENY_LIST_KEY", "LEGACY_EMAIL_DESTINATION_SETTING_PREFIX", "LEGACY_EMAIL_PASSWORD", "LEGACY_EMAIL_USERNAME", "MAX_CONNECTIONS", "getMAX_CONNECTIONS", "MAX_CONNECTIONS_KEY", "MAX_CONNECTIONS_PER_ROUTE", "getMAX_CONNECTIONS_PER_ROUTE", "MAX_CONNECTIONS_PER_ROUTE_KEY", "MINIMUM_EMAIL_SIZE_LIMIT", "SOCKET_TIMEOUT_MILLISECONDS", "getSOCKET_TIMEOUT_MILLISECONDS", "SOCKET_TIMEOUT_MILLISECONDS_KEY", "TOOLTIP_SUPPORT", "getTOOLTIP_SUPPORT", "TOOLTIP_SUPPORT_KEY", "allowedConfigTypes", "getAllowedConfigTypes", "()Ljava/util/List;", "setAllowedConfigTypes", "(Ljava/util/List;)V", "connectionTimeout", "getConnectionTimeout", "()I", "setConnectionTimeout", "(I)V", "defaultSettings", "destinationSettings", "getDestinationSettings", "()Ljava/util/Map;", "setDestinationSettings", "(Ljava/util/Map;)V", "emailMinimumHeaderLength", "getEmailMinimumHeaderLength", "setEmailMinimumHeaderLength", "emailSizeLimit", "getEmailSizeLimit", "setEmailSizeLimit", "hostDenyList", "getHostDenyList", "setHostDenyList", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "maxConnections", "getMaxConnections", "setMaxConnections", "maxConnectionsPerRoute", "getMaxConnectionsPerRoute", "setMaxConnectionsPerRoute", "socketTimeout", "getSocketTimeout", "setSocketTimeout", "tooltipSupport", "getTooltipSupport", "()Z", "setTooltipSupport", "(Z)V", "addSettingsUpdateConsumer", "", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "fallback", "T", "key", "affixSetting", "regex", "replacement", "getAllSettings", "getEmailSettingValue", "settings", "Lorg/opensearch/common/settings/Settings;", "emailAccountName", "emailSetting", "(Lorg/opensearch/common/settings/Settings;Ljava/lang/String;Lorg/opensearch/common/settings/Setting$AffixSetting;)Ljava/lang/Object;", "getSecureDestinationSettings", "loadDestinationSettings", "reset", "updateSettingValuesFromCluster", "updateSettingValuesFromLocal", "opensearch-notifications-core"})
public final class PluginSettings {
    @NotNull
    public static final PluginSettings INSTANCE;
    @NotNull
    private static final String KEY_PREFIX = "opensearch.notifications.core";
    @NotNull
    private static final String EMAIL_KEY_PREFIX = "opensearch.notifications.core.email";
    @NotNull
    private static final String LEGACY_EMAIL_DESTINATION_SETTING_PREFIX = "plugins.alerting.destination.email.";
    @NotNull
    private static final String EMAIL_DESTINATION_SETTING_PREFIX = "opensearch.notifications.core.email.";
    @NotNull
    private static final String HTTP_CONNECTION_KEY_PREFIX = "opensearch.notifications.core.http";
    @NotNull
    private static final String EMAIL_SIZE_LIMIT_KEY = "opensearch.notifications.core.email.size_limit";
    @NotNull
    private static final String EMAIL_MINIMUM_HEADER_LENGTH_KEY = "opensearch.notifications.core.email.minimum_header_length";
    @NotNull
    private static final String MAX_CONNECTIONS_KEY = "opensearch.notifications.core.http.max_connections";
    @NotNull
    private static final String MAX_CONNECTIONS_PER_ROUTE_KEY = "opensearch.notifications.core.http.max_connection_per_route";
    @NotNull
    private static final String CONNECTION_TIMEOUT_MILLISECONDS_KEY = "opensearch.notifications.core.http.connection_timeout";
    @NotNull
    private static final String SOCKET_TIMEOUT_MILLISECONDS_KEY = "opensearch.notifications.core.http.socket_timeout";
    @NotNull
    private static final String LEGACY_ALERTING_HOST_DENY_LIST_KEY = "opendistro.destination.host.deny_list";
    @NotNull
    private static final String ALERTING_HOST_DENY_LIST_KEY = "plugins.destination.host.deny_list";
    @NotNull
    private static final String HOST_DENY_LIST_KEY = "opensearch.notifications.core.http.host_deny_list";
    @NotNull
    private static final String ALLOWED_CONFIG_TYPE_KEY = "opensearch.notifications.core.allowed_config_types";
    @NotNull
    private static final String TOOLTIP_SUPPORT_KEY = "opensearch.notifications.core.tooltip_support";
    private static final int DEFAULT_EMAIL_SIZE_LIMIT = 10000000;
    private static final int MINIMUM_EMAIL_SIZE_LIMIT = 10000;
    private static final int DEFAULT_MAX_CONNECTIONS = 60;
    private static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 20;
    private static final int DEFAULT_CONNECTION_TIMEOUT_MILLISECONDS = 5000;
    private static final int DEFAULT_SOCKET_TIMEOUT_MILLISECONDS = 50000;
    private static final int DEFAULT_MINIMUM_EMAIL_HEADER_LENGTH = 160;
    @NotNull
    private static final List<String> DEFAULT_ALLOWED_CONFIG_TYPES;
    @NotNull
    private static final List<String> DEFAULT_HOST_DENY_LIST;
    private static final boolean DEFAULT_TOOLTIP_SUPPORT = true;
    @NotNull
    private static final Map<String, SecureDestinationSettings> DEFAULT_DESTINATION_SETTINGS;
    @NotNull
    private static volatile List<String> allowedConfigTypes;
    private static volatile int emailSizeLimit;
    private static volatile int emailMinimumHeaderLength;
    private static volatile int maxConnections;
    private static volatile int maxConnectionsPerRoute;
    private static volatile int connectionTimeout;
    private static volatile int socketTimeout;
    private static volatile boolean tooltipSupport;
    @NotNull
    private static volatile List<String> hostDenyList;
    @NotNull
    private static volatile Map<String, SecureDestinationSettings> destinationSettings;
    private static final int DECIMAL_RADIX = 10;
    @NotNull
    private static final Lazy log$delegate;
    @NotNull
    private static final Map<String, String> defaultSettings;
    @NotNull
    private static final Setting<Integer> EMAIL_SIZE_LIMIT;
    @NotNull
    private static final Setting<Integer> EMAIL_MINIMUM_HEADER_LENGTH;
    @NotNull
    private static final Setting<Integer> MAX_CONNECTIONS;
    @NotNull
    private static final Setting<Integer> MAX_CONNECTIONS_PER_ROUTE;
    @NotNull
    private static final Setting<Integer> CONNECTION_TIMEOUT_MILLISECONDS;
    @NotNull
    private static final Setting<Integer> SOCKET_TIMEOUT_MILLISECONDS;
    @NotNull
    private static final Setting<List<String>> ALLOWED_CONFIG_TYPES;
    @NotNull
    private static final Setting<Boolean> TOOLTIP_SUPPORT;
    @NotNull
    private static final Setting<List<String>> LEGACY_ALERTING_HOST_DENY_LIST;
    @NotNull
    private static final Setting<List<String>> ALERTING_HOST_DENY_LIST;
    @NotNull
    private static final Setting<List<String>> HOST_DENY_LIST;
    @NotNull
    private static final Setting.AffixSetting<SecureString> LEGACY_EMAIL_USERNAME;
    @NotNull
    private static final Setting.AffixSetting<SecureString> LEGACY_EMAIL_PASSWORD;
    @NotNull
    private static final Setting.AffixSetting<SecureString> EMAIL_USERNAME;
    @NotNull
    private static final Setting.AffixSetting<SecureString> EMAIL_PASSWORD;

    private PluginSettings() {
    }

    @NotNull
    public final List<String> getAllowedConfigTypes() {
        return allowedConfigTypes;
    }

    public final void setAllowedConfigTypes(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        allowedConfigTypes = list;
    }

    public final int getEmailSizeLimit() {
        return emailSizeLimit;
    }

    public final void setEmailSizeLimit(int n) {
        emailSizeLimit = n;
    }

    public final int getEmailMinimumHeaderLength() {
        return emailMinimumHeaderLength;
    }

    public final void setEmailMinimumHeaderLength(int n) {
        emailMinimumHeaderLength = n;
    }

    public final int getMaxConnections() {
        return maxConnections;
    }

    public final void setMaxConnections(int n) {
        maxConnections = n;
    }

    public final int getMaxConnectionsPerRoute() {
        return maxConnectionsPerRoute;
    }

    public final void setMaxConnectionsPerRoute(int n) {
        maxConnectionsPerRoute = n;
    }

    public final int getConnectionTimeout() {
        return connectionTimeout;
    }

    public final void setConnectionTimeout(int n) {
        connectionTimeout = n;
    }

    public final int getSocketTimeout() {
        return socketTimeout;
    }

    public final void setSocketTimeout(int n) {
        socketTimeout = n;
    }

    public final boolean getTooltipSupport() {
        return tooltipSupport;
    }

    public final void setTooltipSupport(boolean bl) {
        tooltipSupport = bl;
    }

    @NotNull
    public final List<String> getHostDenyList() {
        return hostDenyList;
    }

    public final void setHostDenyList(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        hostDenyList = list;
    }

    @NotNull
    public final Map<String, SecureDestinationSettings> getDestinationSettings() {
        return destinationSettings;
    }

    public final void setDestinationSettings(@NotNull Map<String, SecureDestinationSettings> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        destinationSettings = map;
    }

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public final Setting<Integer> getEMAIL_SIZE_LIMIT() {
        return EMAIL_SIZE_LIMIT;
    }

    @NotNull
    public final Setting<Integer> getEMAIL_MINIMUM_HEADER_LENGTH() {
        return EMAIL_MINIMUM_HEADER_LENGTH;
    }

    @NotNull
    public final Setting<Integer> getMAX_CONNECTIONS() {
        return MAX_CONNECTIONS;
    }

    @NotNull
    public final Setting<Integer> getMAX_CONNECTIONS_PER_ROUTE() {
        return MAX_CONNECTIONS_PER_ROUTE;
    }

    @NotNull
    public final Setting<Integer> getCONNECTION_TIMEOUT_MILLISECONDS() {
        return CONNECTION_TIMEOUT_MILLISECONDS;
    }

    @NotNull
    public final Setting<Integer> getSOCKET_TIMEOUT_MILLISECONDS() {
        return SOCKET_TIMEOUT_MILLISECONDS;
    }

    @NotNull
    public final Setting<List<String>> getALLOWED_CONFIG_TYPES() {
        return ALLOWED_CONFIG_TYPES;
    }

    @NotNull
    public final Setting<Boolean> getTOOLTIP_SUPPORT() {
        return TOOLTIP_SUPPORT;
    }

    @NotNull
    public final Setting<List<String>> getLEGACY_ALERTING_HOST_DENY_LIST() {
        return LEGACY_ALERTING_HOST_DENY_LIST;
    }

    @NotNull
    public final Setting<List<String>> getALERTING_HOST_DENY_LIST() {
        return ALERTING_HOST_DENY_LIST;
    }

    @NotNull
    public final Setting<List<String>> getHOST_DENY_LIST() {
        return HOST_DENY_LIST;
    }

    @NotNull
    public final List<Setting<?>> getAllSettings() {
        Object[] objectArray = new Setting[]{EMAIL_SIZE_LIMIT, EMAIL_MINIMUM_HEADER_LENGTH, MAX_CONNECTIONS, MAX_CONNECTIONS_PER_ROUTE, CONNECTION_TIMEOUT_MILLISECONDS, SOCKET_TIMEOUT_MILLISECONDS, ALLOWED_CONFIG_TYPES, TOOLTIP_SUPPORT, HOST_DENY_LIST, (Setting)EMAIL_USERNAME, (Setting)EMAIL_PASSWORD};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final void updateSettingValuesFromLocal(ClusterService clusterService) {
        Object object = ALLOWED_CONFIG_TYPES.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ALLOWED_CONFIG_TYPES.get(clusterService.settings)");
        allowedConfigTypes = (List)object;
        object = EMAIL_SIZE_LIMIT.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"EMAIL_SIZE_LIMIT.get(clusterService.settings)");
        emailSizeLimit = ((Number)object).intValue();
        object = EMAIL_MINIMUM_HEADER_LENGTH.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"EMAIL_MINIMUM_HEADER_LEN\u2026(clusterService.settings)");
        emailMinimumHeaderLength = ((Number)object).intValue();
        object = MAX_CONNECTIONS.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"MAX_CONNECTIONS.get(clusterService.settings)");
        maxConnections = ((Number)object).intValue();
        object = MAX_CONNECTIONS_PER_ROUTE.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"MAX_CONNECTIONS_PER_ROUT\u2026(clusterService.settings)");
        maxConnectionsPerRoute = ((Number)object).intValue();
        object = CONNECTION_TIMEOUT_MILLISECONDS.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CONNECTION_TIMEOUT_MILLI\u2026(clusterService.settings)");
        connectionTimeout = ((Number)object).intValue();
        object = SOCKET_TIMEOUT_MILLISECONDS.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"SOCKET_TIMEOUT_MILLISECO\u2026(clusterService.settings)");
        socketTimeout = ((Number)object).intValue();
        object = TOOLTIP_SUPPORT.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"TOOLTIP_SUPPORT.get(clusterService.settings)");
        tooltipSupport = (Boolean)object;
        object = HOST_DENY_LIST.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HOST_DENY_LIST.get(clusterService.settings)");
        hostDenyList = (List)object;
        object = clusterService.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"clusterService.settings");
        destinationSettings = this.loadDestinationSettings((Settings)object);
    }

    private final void updateSettingValuesFromCluster(ClusterService clusterService) {
        List clusterHostDenyList;
        Boolean clusterTooltipSupport;
        List clusterAllowedConfigTypes;
        Integer clusterSocketTimeout;
        Integer clusterConnectionTimeout;
        Integer clusterMaxConnectionsPerRoute;
        Integer clusterMaxConnections;
        Integer clusterEmailMinimumHeaderLength;
        Integer clusterEmailSizeLimit = (Integer)clusterService.getClusterSettings().get(EMAIL_SIZE_LIMIT);
        if (clusterEmailSizeLimit != null) {
            this.getLog().debug("notifications-core:opensearch.notifications.core.email.size_limit -autoUpdatedTo-> " + clusterEmailSizeLimit);
            emailSizeLimit = clusterEmailSizeLimit;
        }
        if ((clusterEmailMinimumHeaderLength = (Integer)clusterService.getClusterSettings().get(EMAIL_MINIMUM_HEADER_LENGTH)) != null) {
            this.getLog().debug("notifications-core:opensearch.notifications.core.email.minimum_header_length -autoUpdatedTo-> " + clusterEmailMinimumHeaderLength);
            emailMinimumHeaderLength = clusterEmailMinimumHeaderLength;
        }
        if ((clusterMaxConnections = (Integer)clusterService.getClusterSettings().get(MAX_CONNECTIONS)) != null) {
            this.getLog().debug("notifications-core:opensearch.notifications.core.http.max_connections -autoUpdatedTo-> " + clusterMaxConnections);
            maxConnections = clusterMaxConnections;
        }
        if ((clusterMaxConnectionsPerRoute = (Integer)clusterService.getClusterSettings().get(MAX_CONNECTIONS_PER_ROUTE)) != null) {
            this.getLog().debug("notifications-core:opensearch.notifications.core.http.max_connection_per_route -autoUpdatedTo-> " + clusterMaxConnectionsPerRoute);
            maxConnectionsPerRoute = clusterMaxConnectionsPerRoute;
        }
        if ((clusterConnectionTimeout = (Integer)clusterService.getClusterSettings().get(CONNECTION_TIMEOUT_MILLISECONDS)) != null) {
            this.getLog().debug("notifications-core:opensearch.notifications.core.http.connection_timeout -autoUpdatedTo-> " + clusterConnectionTimeout);
            connectionTimeout = clusterConnectionTimeout;
        }
        if ((clusterSocketTimeout = (Integer)clusterService.getClusterSettings().get(SOCKET_TIMEOUT_MILLISECONDS)) != null) {
            this.getLog().debug("notifications-core:opensearch.notifications.core.http.socket_timeout -autoUpdatedTo-> " + clusterSocketTimeout);
            socketTimeout = clusterSocketTimeout;
        }
        if ((clusterAllowedConfigTypes = (List)clusterService.getClusterSettings().get(ALLOWED_CONFIG_TYPES)) != null) {
            this.getLog().debug("notifications-core:opensearch.notifications.core.allowed_config_types -autoUpdatedTo-> " + clusterAllowedConfigTypes);
            allowedConfigTypes = clusterAllowedConfigTypes;
        }
        if ((clusterTooltipSupport = (Boolean)clusterService.getClusterSettings().get(TOOLTIP_SUPPORT)) != null) {
            this.getLog().debug("notifications-core:opensearch.notifications.core.tooltip_support -autoUpdatedTo-> " + clusterTooltipSupport);
            tooltipSupport = clusterTooltipSupport;
        }
        if ((clusterHostDenyList = (List)clusterService.getClusterSettings().get(HOST_DENY_LIST)) != null) {
            this.getLog().debug("notifications-core:opensearch.notifications.core.http.host_deny_list -autoUpdatedTo-> " + clusterHostDenyList);
            hostDenyList = clusterHostDenyList;
        }
    }

    public final void addSettingsUpdateConsumer(@NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.updateSettingValuesFromLocal(clusterService);
        this.updateSettingValuesFromCluster(clusterService);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ALLOWED_CONFIG_TYPES, PluginSettings::addSettingsUpdateConsumer$lambda-8);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(EMAIL_SIZE_LIMIT, PluginSettings::addSettingsUpdateConsumer$lambda-9);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(EMAIL_MINIMUM_HEADER_LENGTH, PluginSettings::addSettingsUpdateConsumer$lambda-10);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_CONNECTIONS, PluginSettings::addSettingsUpdateConsumer$lambda-11);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_CONNECTIONS_PER_ROUTE, PluginSettings::addSettingsUpdateConsumer$lambda-12);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(CONNECTION_TIMEOUT_MILLISECONDS, PluginSettings::addSettingsUpdateConsumer$lambda-13);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SOCKET_TIMEOUT_MILLISECONDS, PluginSettings::addSettingsUpdateConsumer$lambda-14);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(TOOLTIP_SUPPORT, PluginSettings::addSettingsUpdateConsumer$lambda-15);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(HOST_DENY_LIST, PluginSettings::addSettingsUpdateConsumer$lambda-16);
    }

    @NotNull
    public final Map<String, SecureDestinationSettings> loadDestinationSettings(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Set emailAccountNames = settings.getGroups(EMAIL_DESTINATION_SETTING_PREFIX, true).keySet();
        Set legacyEmailAccountNames = settings.getGroups(LEGACY_EMAIL_DESTINATION_SETTING_PREFIX, true).keySet();
        emailAccountNames = CollectionsKt.union((Iterable)emailAccountNames, (Iterable)legacyEmailAccountNames);
        Map emailAccounts = new LinkedHashMap();
        for (String emailAccountName : emailAccountNames) {
            SecureDestinationSettings it;
            if (this.getSecureDestinationSettings(settings, emailAccountName) == null) continue;
            boolean bl = false;
            emailAccounts.put(emailAccountName, it);
        }
        return emailAccounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SecureDestinationSettings getSecureDestinationSettings(Settings settings, String emailAccountName) {
        SecureDestinationSettings secureDestinationSettings;
        SecureString secureString = this.getEmailSettingValue(settings, emailAccountName, EMAIL_USERNAME);
        if (secureString == null) {
            secureDestinationSettings = null;
        } else {
            Closeable closeable = (Closeable)secureString;
            Throwable throwable = null;
            try {
                SecureDestinationSettings secureDestinationSettings2;
                SecureString emailUsername = (SecureString)closeable;
                boolean bl = false;
                SecureString secureString2 = INSTANCE.getEmailSettingValue(settings, emailAccountName, EMAIL_PASSWORD);
                if (secureString2 == null) {
                    secureDestinationSettings2 = null;
                } else {
                    Closeable closeable2 = (Closeable)secureString2;
                    Throwable throwable2 = null;
                    try {
                        SecureString emailPassword = (SecureString)closeable2;
                        boolean bl2 = false;
                        SecureString secureString3 = emailUsername.clone();
                        Intrinsics.checkNotNullExpressionValue((Object)secureString3, (String)"emailUsername.clone()");
                        SecureString secureString4 = secureString3;
                        secureString3 = emailPassword.clone();
                        Intrinsics.checkNotNullExpressionValue((Object)secureString3, (String)"emailPassword.clone()");
                        SecureDestinationSettings secureDestinationSettings3 = new SecureDestinationSettings(secureString4, secureString3);
                        secureDestinationSettings2 = secureDestinationSettings3;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                }
                SecureDestinationSettings secureDestinationSettings4 = secureDestinationSettings2;
                secureDestinationSettings = secureDestinationSettings4;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return secureDestinationSettings;
    }

    private final <T> T getEmailSettingValue(Settings settings, String emailAccountName, Setting.AffixSetting<T> emailSetting) {
        Setting concreteSetting = emailSetting.getConcreteSettingForNamespace(emailAccountName);
        return (T)concreteSetting.get(settings);
    }

    private final <T> Setting<T> fallback(String key, Setting.AffixSetting<T> affixSetting, String regex, String replacement) {
        Setting setting;
        if (Intrinsics.areEqual((Object)"_na_", (Object)key)) {
            setting = affixSetting.getConcreteSettingForNamespace(key);
        } else {
            CharSequence charSequence = key;
            setting = affixSetting.getConcreteSetting(new Regex(regex).replace(charSequence, replacement));
        }
        return setting;
    }

    @OpenForTesting
    public final void reset() {
        emailSizeLimit = 10000000;
        emailMinimumHeaderLength = 160;
        maxConnections = 60;
        maxConnectionsPerRoute = 20;
        connectionTimeout = 5000;
        socketTimeout = 50000;
        allowedConfigTypes = DEFAULT_ALLOWED_CONFIG_TYPES;
        tooltipSupport = true;
        hostDenyList = DEFAULT_HOST_DENY_LIST;
    }

    private static final String ALLOWED_CONFIG_TYPES$lambda-0(String it) {
        return it;
    }

    private static final String LEGACY_ALERTING_HOST_DENY_LIST$lambda-1(String it) {
        return it;
    }

    private static final String ALERTING_HOST_DENY_LIST$lambda-2(String it) {
        return it;
    }

    private static final String HOST_DENY_LIST$lambda-3(String it) {
        return it;
    }

    private static final Setting LEGACY_EMAIL_USERNAME$lambda-4(String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]);
    }

    private static final Setting LEGACY_EMAIL_PASSWORD$lambda-5(String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]);
    }

    private static final Setting EMAIL_USERNAME$lambda-6(String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return SecureSetting.secureString((String)key, INSTANCE.fallback(key, LEGACY_EMAIL_USERNAME, "opensearch\\.notifications\\.core", "plugins.alerting.destination"), (Setting.Property[])new Setting.Property[0]);
    }

    private static final Setting EMAIL_PASSWORD$lambda-7(String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return SecureSetting.secureString((String)key, INSTANCE.fallback(key, LEGACY_EMAIL_PASSWORD, "opensearch\\.notifications\\.core", "plugins.alerting.destination"), (Setting.Property[])new Setting.Property[0]);
    }

    private static final void addSettingsUpdateConsumer$lambda-8(List it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        allowedConfigTypes = it;
        INSTANCE.getLog().info("notifications-core:opensearch.notifications.core.allowed_config_types -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda-9(Integer it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        emailSizeLimit = it;
        INSTANCE.getLog().info("notifications-core:opensearch.notifications.core.email.size_limit -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda-10(Integer it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        emailMinimumHeaderLength = it;
        INSTANCE.getLog().info("notifications-core:opensearch.notifications.core.email.minimum_header_length -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda-11(Integer it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        maxConnections = it;
        INSTANCE.getLog().info("notifications-core:opensearch.notifications.core.http.max_connections -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda-12(Integer it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        maxConnectionsPerRoute = it;
        INSTANCE.getLog().info("notifications-core:opensearch.notifications.core.http.max_connection_per_route -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda-13(Integer it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        connectionTimeout = it;
        INSTANCE.getLog().info("notifications-core:opensearch.notifications.core.http.connection_timeout -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda-14(Integer it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        socketTimeout = it;
        INSTANCE.getLog().info("notifications-core:opensearch.notifications.core.http.socket_timeout -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda-15(Boolean it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        tooltipSupport = it;
        INSTANCE.getLog().info("notifications-core:opensearch.notifications.core.tooltip_support -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda-16(List it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        hostDenyList = it;
        INSTANCE.getLog().info("notifications-core:opensearch.notifications.core.http.host_deny_list -updatedTo-> " + it);
    }

    static {
        boolean bl;
        int n;
        Object object;
        String configDirName;
        String string;
        INSTANCE = new PluginSettings();
        String[] stringArray = new String[]{"slack", "chime", "webhook", "email", "sns", "ses_account", "smtp_account", "email_group"};
        DEFAULT_ALLOWED_CONFIG_TYPES = CollectionsKt.listOf((Object[])stringArray);
        DEFAULT_HOST_DENY_LIST = CollectionsKt.emptyList();
        DEFAULT_DESTINATION_SETTINGS = MapsKt.emptyMap();
        log$delegate = HelpersKt.logger(INSTANCE.getClass());
        Pair[] settings = null;
        Dictionary dictionary = BootstrapInfo.getSystemProperties();
        if (dictionary == null) {
            string = null;
        } else {
            Object v = dictionary.get("opensearch.path.conf");
            string = configDirName = v == null ? null : v.toString();
        }
        if (configDirName != null) {
            object = new String[]{"opensearch-notifications-core", "notifications-core.yml"};
            Path defaultSettingYmlFile = Path.of(configDirName, object);
            try {
                settings = Settings.builder().loadFromPath(defaultSettingYmlFile).build();
            }
            catch (IOException e) {
                INSTANCE.getLog().warn("notifications-core:Failed to load " + defaultSettingYmlFile.toAbsolutePath() + ":" + e.getMessage());
            }
        }
        emailSizeLimit = settings == null ? 10000000 : ((object = settings.get(EMAIL_SIZE_LIMIT_KEY)) == null ? 10000000 : (n = Integer.parseInt((String)object)));
        Pair[] pairArray = settings;
        emailMinimumHeaderLength = pairArray == null ? 160 : ((object = pairArray.get(EMAIL_MINIMUM_HEADER_LENGTH_KEY)) == null ? 160 : (n = Integer.parseInt((String)object)));
        maxConnections = settings == null ? 60 : ((object = settings.get(MAX_CONNECTIONS_KEY)) == null ? 60 : (n = Integer.parseInt((String)object)));
        pairArray = settings;
        maxConnectionsPerRoute = pairArray == null ? 20 : ((object = pairArray.get(MAX_CONNECTIONS_PER_ROUTE_KEY)) == null ? 20 : (n = Integer.parseInt((String)object)));
        pairArray = settings;
        connectionTimeout = pairArray == null ? 5000 : ((object = pairArray.get(CONNECTION_TIMEOUT_MILLISECONDS_KEY)) == null ? 5000 : (n = Integer.parseInt((String)object)));
        socketTimeout = settings == null ? 50000 : ((object = settings.get(SOCKET_TIMEOUT_MILLISECONDS_KEY)) == null ? 50000 : (n = Integer.parseInt((String)object)));
        List<String> list = settings == null ? null : settings.getAsList(ALLOWED_CONFIG_TYPE_KEY, null);
        if (list == null) {
            list = DEFAULT_ALLOWED_CONFIG_TYPES;
        }
        allowedConfigTypes = list;
        if (settings == null) {
            bl = true;
        } else {
            Boolean bl2 = settings.getAsBoolean(TOOLTIP_SUPPORT_KEY, Boolean.valueOf(true));
            bl = bl2 == null ? true : bl2;
        }
        tooltipSupport = bl;
        List<String> list2 = settings == null ? null : settings.getAsList(HOST_DENY_LIST_KEY, null);
        if (list2 == null) {
            list2 = DEFAULT_HOST_DENY_LIST;
        }
        hostDenyList = list2;
        destinationSettings = settings != null ? INSTANCE.loadDestinationSettings((Settings)settings) : DEFAULT_DESTINATION_SETTINGS;
        pairArray = new Pair[7];
        String string2 = Integer.toString(emailSizeLimit, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
        pairArray[0] = TuplesKt.to((Object)EMAIL_SIZE_LIMIT_KEY, (Object)string2);
        string2 = Integer.toString(emailMinimumHeaderLength, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
        pairArray[1] = TuplesKt.to((Object)EMAIL_MINIMUM_HEADER_LENGTH_KEY, (Object)string2);
        string2 = Integer.toString(maxConnections, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
        pairArray[2] = TuplesKt.to((Object)MAX_CONNECTIONS_KEY, (Object)string2);
        string2 = Integer.toString(maxConnectionsPerRoute, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
        pairArray[3] = TuplesKt.to((Object)MAX_CONNECTIONS_PER_ROUTE_KEY, (Object)string2);
        string2 = Integer.toString(connectionTimeout, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
        pairArray[4] = TuplesKt.to((Object)CONNECTION_TIMEOUT_MILLISECONDS_KEY, (Object)string2);
        string2 = Integer.toString(socketTimeout, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
        pairArray[5] = TuplesKt.to((Object)SOCKET_TIMEOUT_MILLISECONDS_KEY, (Object)string2);
        pairArray[6] = TuplesKt.to((Object)TOOLTIP_SUPPORT_KEY, (Object)String.valueOf(tooltipSupport));
        defaultSettings = MapsKt.mapOf((Pair[])pairArray);
        String string3 = defaultSettings.get(EMAIL_SIZE_LIMIT_KEY);
        Intrinsics.checkNotNull((Object)string3);
        Setting.Property[] propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        stringArray = Setting.intSetting((String)EMAIL_SIZE_LIMIT_KEY, (int)Integer.parseInt(string3), (int)10000, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"intSetting(\n        EMAI\u2026 NodeScope, Dynamic\n    )");
        EMAIL_SIZE_LIMIT = stringArray;
        String string4 = defaultSettings.get(EMAIL_MINIMUM_HEADER_LENGTH_KEY);
        Intrinsics.checkNotNull((Object)string4);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        stringArray = Setting.intSetting((String)EMAIL_MINIMUM_HEADER_LENGTH_KEY, (int)Integer.parseInt(string4), (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"intSetting(\n        EMAI\u2026 NodeScope, Dynamic\n    )");
        EMAIL_MINIMUM_HEADER_LENGTH = stringArray;
        String string5 = defaultSettings.get(MAX_CONNECTIONS_KEY);
        Intrinsics.checkNotNull((Object)string5);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        stringArray = Setting.intSetting((String)MAX_CONNECTIONS_KEY, (int)Integer.parseInt(string5), (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"intSetting(\n        MAX_\u2026 NodeScope, Dynamic\n    )");
        MAX_CONNECTIONS = stringArray;
        String string6 = defaultSettings.get(MAX_CONNECTIONS_PER_ROUTE_KEY);
        Intrinsics.checkNotNull((Object)string6);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        stringArray = Setting.intSetting((String)MAX_CONNECTIONS_PER_ROUTE_KEY, (int)Integer.parseInt(string6), (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"intSetting(\n        MAX_\u2026 NodeScope, Dynamic\n    )");
        MAX_CONNECTIONS_PER_ROUTE = stringArray;
        String string7 = defaultSettings.get(CONNECTION_TIMEOUT_MILLISECONDS_KEY);
        Intrinsics.checkNotNull((Object)string7);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        stringArray = Setting.intSetting((String)CONNECTION_TIMEOUT_MILLISECONDS_KEY, (int)Integer.parseInt(string7), (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"intSetting(\n        CONN\u2026 NodeScope, Dynamic\n    )");
        CONNECTION_TIMEOUT_MILLISECONDS = stringArray;
        String string8 = defaultSettings.get(SOCKET_TIMEOUT_MILLISECONDS_KEY);
        Intrinsics.checkNotNull((Object)string8);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        stringArray = Setting.intSetting((String)SOCKET_TIMEOUT_MILLISECONDS_KEY, (int)Integer.parseInt(string8), (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"intSetting(\n        SOCK\u2026 NodeScope, Dynamic\n    )");
        SOCKET_TIMEOUT_MILLISECONDS = stringArray;
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        stringArray = Setting.listSetting((String)ALLOWED_CONFIG_TYPE_KEY, DEFAULT_ALLOWED_CONFIG_TYPES, PluginSettings::ALLOWED_CONFIG_TYPES$lambda-0, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"listSetting(\n        ALL\u2026 NodeScope, Dynamic\n    )");
        ALLOWED_CONFIG_TYPES = stringArray;
        String string9 = defaultSettings.get(TOOLTIP_SUPPORT_KEY);
        Intrinsics.checkNotNull((Object)string9);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        stringArray = Setting.boolSetting((String)TOOLTIP_SUPPORT_KEY, (boolean)Boolean.parseBoolean(string9), (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"boolSetting(\n        TOO\u2026 NodeScope, Dynamic\n    )");
        TOOLTIP_SUPPORT = stringArray;
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final, Setting.Property.Deprecated};
        stringArray = Setting.listSetting((String)LEGACY_ALERTING_HOST_DENY_LIST_KEY, DEFAULT_HOST_DENY_LIST, PluginSettings::LEGACY_ALERTING_HOST_DENY_LIST$lambda-1, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"listSetting(\n        LEG\u2026, Final, Deprecated\n    )");
        LEGACY_ALERTING_HOST_DENY_LIST = stringArray;
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final};
        stringArray = Setting.listSetting((String)ALERTING_HOST_DENY_LIST_KEY, LEGACY_ALERTING_HOST_DENY_LIST, PluginSettings::ALERTING_HOST_DENY_LIST$lambda-2, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"listSetting(\n        ALE\u2026   NodeScope, Final\n    )");
        ALERTING_HOST_DENY_LIST = stringArray;
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        stringArray = Setting.listSetting((String)HOST_DENY_LIST_KEY, ALERTING_HOST_DENY_LIST, PluginSettings::HOST_DENY_LIST$lambda-3, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"listSetting(\n        HOS\u2026 NodeScope, Dynamic\n    )");
        HOST_DENY_LIST = stringArray;
        stringArray = Setting.affixKeySetting((String)LEGACY_EMAIL_DESTINATION_SETTING_PREFIX, (String)"username", PluginSettings::LEGACY_EMAIL_USERNAME$lambda-4, (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"affixKeySetting(\n       \u2026String(key, null) }\n    )");
        LEGACY_EMAIL_USERNAME = stringArray;
        stringArray = Setting.affixKeySetting((String)LEGACY_EMAIL_DESTINATION_SETTING_PREFIX, (String)"password", PluginSettings::LEGACY_EMAIL_PASSWORD$lambda-5, (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"affixKeySetting(\n       \u2026String(key, null) }\n    )");
        LEGACY_EMAIL_PASSWORD = stringArray;
        stringArray = Setting.affixKeySetting((String)EMAIL_DESTINATION_SETTING_PREFIX, (String)"username", PluginSettings::EMAIL_USERNAME$lambda-6, (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"affixKeySetting(\n       \u2026        )\n        }\n    )");
        EMAIL_USERNAME = stringArray;
        stringArray = Setting.affixKeySetting((String)EMAIL_DESTINATION_SETTING_PREFIX, (String)"password", PluginSettings::EMAIL_PASSWORD$lambda-7, (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"affixKeySetting(\n       \u2026        )\n        }\n    )");
        EMAIL_PASSWORD = stringArray;
    }
}

