/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.client;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.notifications.core.setting.PluginSettings;
import org.opensearch.notifications.core.utils.HelpersKt;
import org.opensearch.notifications.core.utils.OpenForTesting;
import org.opensearch.notifications.core.utils.ValidationHelpersKt;
import org.opensearch.notifications.spi.model.MessageContent;
import org.opensearch.notifications.spi.model.destination.ChimeDestination;
import org.opensearch.notifications.spi.model.destination.CustomWebhookDestination;
import org.opensearch.notifications.spi.model.destination.SlackDestination;
import org.opensearch.notifications.spi.model.destination.WebhookDestination;
import org.opensearch.rest.RestStatus;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u001e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0007J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0013J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/opensearch/notifications/core/client/DestinationHttpClient;", "", "()V", "httpClient", "Lorg/apache/http/impl/client/CloseableHttpClient;", "(Lorg/apache/http/impl/client/CloseableHttpClient;)V", "buildRequestBody", "", "destination", "Lorg/opensearch/notifications/spi/model/destination/WebhookDestination;", "message", "Lorg/opensearch/notifications/spi/model/MessageContent;", "constructHttpRequest", "Lorg/apache/http/client/methods/HttpRequestBase;", "method", "url", "execute", "referenceId", "getHttpResponse", "Lorg/apache/http/client/methods/CloseableHttpResponse;", "getResponseString", "response", "validateResponseStatus", "", "Lorg/apache/http/HttpResponse;", "Companion", "opensearch-notifications-core"})
public final class DestinationHttpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CloseableHttpClient httpClient;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(DestinationHttpClient.class);
    private static final Set<Integer> VALID_RESPONSE_STATUS;

    public DestinationHttpClient() {
        this.httpClient = DestinationHttpClient.Companion.createHttpClient();
    }

    @OpenForTesting
    public DestinationHttpClient(@NotNull CloseableHttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        this.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String execute(@NotNull WebhookDestination destination, @NotNull MessageContent message, @NotNull String referenceId) throws Exception {
        String string;
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        CloseableHttpResponse response = null;
        try {
            ValidationHelpersKt.validateUrlHost(destination.getUrl(), PluginSettings.INSTANCE.getHostDenyList());
            response = this.getHttpResponse(destination, message);
            this.validateResponseStatus((HttpResponse)response);
            String responseString = this.getResponseString(response);
            DestinationHttpClient.Companion.getLog().debug("Http response for id " + referenceId + ": " + responseString);
            string = responseString;
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
        return string;
    }

    private final CloseableHttpResponse getHttpResponse(WebhookDestination destination, MessageContent message) throws Exception {
        HttpRequestBase httpRequest = (HttpRequestBase)new HttpPost(destination.getUrl());
        if (destination instanceof CustomWebhookDestination) {
            httpRequest = this.constructHttpRequest(((CustomWebhookDestination)destination).getMethod(), destination.getUrl());
            if (((CustomWebhookDestination)destination).getHeaderParams().isEmpty()) {
                httpRequest.setHeader("Content-type", "application/json");
            } else {
                for (Map.Entry object2 : ((CustomWebhookDestination)destination).getHeaderParams().entrySet()) {
                    String key = (String)object2.getKey();
                    String value = (String)object2.getValue();
                    httpRequest.setHeader(key, value);
                }
            }
        }
        StringEntity entity = new StringEntity(this.buildRequestBody(destination, message), StandardCharsets.UTF_8);
        ((HttpEntityEnclosingRequestBase)httpRequest).setEntity((HttpEntity)entity);
        CloseableHttpResponse closeableHttpResponse = this.httpClient.execute((HttpUriRequest)httpRequest);
        Intrinsics.checkNotNullExpressionValue((Object)closeableHttpResponse, (String)"httpClient.execute(httpRequest)");
        return closeableHttpResponse;
    }

    private final HttpRequestBase constructHttpRequest(String method, String url) {
        HttpRequestBase httpRequestBase;
        switch (method) {
            case "POST": {
                httpRequestBase = (HttpRequestBase)new HttpPost(url);
                break;
            }
            case "PUT": {
                httpRequestBase = (HttpRequestBase)new HttpPut(url);
                break;
            }
            case "PATCH": {
                httpRequestBase = (HttpRequestBase)new HttpPatch(url);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid or empty method supplied. Only POST, PUT and PATCH are allowed");
            }
        }
        return httpRequestBase;
    }

    @NotNull
    public final String getResponseString(@NotNull CloseableHttpResponse response) throws IOException {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        HttpEntity httpEntity = response.getEntity();
        if (httpEntity == null) {
            return "{}";
        }
        HttpEntity entity = httpEntity;
        String string = EntityUtils.toString((HttpEntity)entity);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(entity)");
        return string;
    }

    private final void validateResponseStatus(HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (!VALID_RESPONSE_STATUS.contains(statusCode)) {
            throw new IOException("Failed: " + EntityUtils.toString((HttpEntity)response.getEntity()));
        }
    }

    @NotNull
    public final String buildRequestBody(@NotNull WebhookDestination destination, @NotNull MessageContent message) {
        String string;
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        XContentBuilder builder = XContentFactory.contentBuilder((XContentType)XContentType.JSON);
        WebhookDestination webhookDestination = destination;
        if (webhookDestination instanceof SlackDestination) {
            string = "text";
        } else if (webhookDestination instanceof ChimeDestination) {
            string = "Content";
        } else {
            if (webhookDestination instanceof CustomWebhookDestination) {
                return message.getTextDescription();
            }
            throw new IllegalArgumentException("Invalid destination type is provided, Only Slack, Chime and CustomWebhook are allowed");
        }
        String keyName = string;
        builder.startObject().field(keyName, message.buildMessageWithTitle()).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
        return HelpersKt.string(builder);
    }

    static {
        Object[] objectArray = new Integer[]{RestStatus.OK.getStatus(), RestStatus.CREATED.getStatus(), RestStatus.ACCEPTED.getStatus(), RestStatus.NON_AUTHORITATIVE_INFORMATION.getStatus(), RestStatus.NO_CONTENT.getStatus(), RestStatus.RESET_CONTENT.getStatus(), RestStatus.PARTIAL_CONTENT.getStatus(), RestStatus.MULTI_STATUS.getStatus()};
        VALID_RESPONSE_STATUS = Collections.unmodifiableSet(new HashSet(CollectionsKt.listOf((Object[])objectArray)));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/opensearch/notifications/core/client/DestinationHttpClient$Companion;", "", "()V", "VALID_RESPONSE_STATUS", "", "", "kotlin.jvm.PlatformType", "", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "createHttpClient", "Lorg/apache/http/impl/client/CloseableHttpClient;", "opensearch-notifications-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        private final CloseableHttpClient createHttpClient() {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(PluginSettings.INSTANCE.getConnectionTimeout()).setConnectionRequestTimeout(PluginSettings.INSTANCE.getConnectionTimeout()).setSocketTimeout(PluginSettings.INSTANCE.getSocketTimeout()).build();
            Intrinsics.checkNotNullExpressionValue((Object)requestConfig, (String)"custom()\n               \u2026\n                .build()");
            RequestConfig config = requestConfig;
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setMaxTotal(PluginSettings.INSTANCE.getMaxConnections());
            connectionManager.setDefaultMaxPerRoute(PluginSettings.INSTANCE.getMaxConnectionsPerRoute());
            CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)connectionManager).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler()).useSystemProperties().build();
            Intrinsics.checkNotNullExpressionValue((Object)closeableHttpClient, (String)"create()\n               \u2026\n                .build()");
            return closeableHttpClient;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

