/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.com.amazonaws.protocol.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.opensearch.notifications.core.repackage.com.amazonaws.annotation.SdkInternalApi;
import org.opensearch.notifications.core.repackage.com.amazonaws.internal.http.CompositeErrorCodeParser;
import org.opensearch.notifications.core.repackage.com.amazonaws.internal.http.ErrorCodeParser;
import org.opensearch.notifications.core.repackage.com.amazonaws.internal.http.IonErrorCodeParser;
import org.opensearch.notifications.core.repackage.com.amazonaws.internal.http.JsonErrorCodeParser;
import org.opensearch.notifications.core.repackage.com.amazonaws.protocol.json.IonFactory;
import org.opensearch.notifications.core.repackage.com.amazonaws.protocol.json.SdkIonGenerator;
import org.opensearch.notifications.core.repackage.com.amazonaws.protocol.json.SdkStructuredJsonFactoryImpl;
import org.opensearch.notifications.core.repackage.com.amazonaws.protocol.json.StructuredJsonGenerator;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.JsonUnmarshallerContext;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.SimpleTypeIonUnmarshallers;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.Unmarshaller;
import org.opensearch.notifications.core.repackage.com.amazonaws.util.ImmutableMapParameter;
import org.opensearch.notifications.core.repackage.com.fasterxml.jackson.core.JsonFactory;
import org.opensearch.notifications.core.repackage.software.amazon.ion.IonSystem;
import org.opensearch.notifications.core.repackage.software.amazon.ion.system.IonBinaryWriterBuilder;
import org.opensearch.notifications.core.repackage.software.amazon.ion.system.IonSystemBuilder;
import org.opensearch.notifications.core.repackage.software.amazon.ion.system.IonTextWriterBuilder;
import org.opensearch.notifications.core.repackage.software.amazon.ion.system.IonWriterBuilder;

@SdkInternalApi
class SdkStructuredIonFactory
extends SdkStructuredJsonFactoryImpl {
    private static final IonSystem ION_SYSTEM = IonSystemBuilder.standard().build();
    private static final JsonFactory JSON_FACTORY = new IonFactory(ION_SYSTEM);
    private static final Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> UNMARSHALLERS = new ImmutableMapParameter.Builder<Class<BigDecimal>, SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller>().put(BigDecimal.class, SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller.getInstance()).put(BigInteger.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.BigIntegerIonUnmarshaller.getInstance())).put(Boolean.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.BooleanIonUnmarshaller.getInstance())).put(ByteBuffer.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.ByteBufferIonUnmarshaller.getInstance())).put(Byte.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.ByteIonUnmarshaller.getInstance())).put(Date.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.DateIonUnmarshaller.getInstance())).put(Double.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.DoubleIonUnmarshaller.getInstance())).put(Float.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.FloatIonUnmarshaller.getInstance())).put(Integer.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.IntegerIonUnmarshaller.getInstance())).put(Long.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.LongIonUnmarshaller.getInstance())).put(Short.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.ShortIonUnmarshaller.getInstance())).put(String.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.StringIonUnmarshaller.getInstance())).build();
    private static final IonBinaryWriterBuilder BINARY_WRITER_BUILDER = IonBinaryWriterBuilder.standard().immutable();
    private static final IonTextWriterBuilder TEXT_WRITER_BUILDER = IonTextWriterBuilder.standard().immutable();
    public static final SdkStructuredIonFactory SDK_ION_BINARY_FACTORY = new SdkStructuredIonFactory((IonWriterBuilder)BINARY_WRITER_BUILDER);
    public static final SdkStructuredIonFactory SDK_ION_TEXT_FACTORY = new SdkStructuredIonFactory((IonWriterBuilder)TEXT_WRITER_BUILDER);
    private final IonWriterBuilder builder;

    private SdkStructuredIonFactory(IonWriterBuilder builder) {
        super(JSON_FACTORY, UNMARSHALLERS, Collections.emptyMap());
        this.builder = builder;
    }

    @Override
    protected StructuredJsonGenerator createWriter(JsonFactory jsonFactory, String contentType) {
        return SdkIonGenerator.create(this.builder, contentType);
    }

    @Override
    protected ErrorCodeParser getErrorCodeParser(String customErrorCodeFieldName) {
        return new CompositeErrorCodeParser(new IonErrorCodeParser(ION_SYSTEM), new JsonErrorCodeParser(customErrorCodeFieldName));
    }
}

