/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.text_embedding;

import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.ndarray.NDList;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import java.util.Collections;
import java.util.List;
import org.opensearch.ml.common.output.model.MLResultDataType;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensors;

public class HuggingfaceTextEmbeddingServingTranslator
implements Translator<Input, Output> {
    private Translator<String, float[]> translator;

    public HuggingfaceTextEmbeddingServingTranslator(Translator<String, float[]> translator) {
        this.translator = translator;
    }

    public Batchifier getBatchifier() {
        return this.translator.getBatchifier();
    }

    public void prepare(TranslatorContext ctx) throws Exception {
        this.translator.prepare(ctx);
    }

    public NDList processInput(TranslatorContext ctx, Input input) throws Exception {
        String text = input.getData().getAsString();
        return this.translator.processInput(ctx, (Object)text);
    }

    public Output processOutput(TranslatorContext ctx, NDList list) throws Exception {
        float[] ret = (float[])this.translator.processOutput(ctx, list);
        Number[] data = new Float[ret.length];
        for (int i = 0; i < ret.length; ++i) {
            data[i] = Float.valueOf(ret[i]);
        }
        long[] shape = new long[]{1L, ret.length};
        ModelTensor tensor = new ModelTensor("sentence_embedding", data, shape, MLResultDataType.FLOAT32, null);
        List<ModelTensor> outputs = Collections.singletonList(tensor);
        Output output = new Output();
        ModelTensors modelTensorOutput = new ModelTensors(outputs);
        output.add(modelTensorOutput.toBytes());
        return output;
    }
}

