/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.utils;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Strings;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FetchSourceContext;

public class RestActionUtils {
    public static final String PARAMETER_ALGORITHM = "algorithm";
    public static final String PARAMETER_ASYNC = "async";
    public static final String PARAMETER_RETURN_CONTENT = "return_content";
    public static final String PARAMETER_MODEL_ID = "model_id";
    public static final String PARAMETER_TASK_ID = "task_id";
    public static final String PARAMETER_LOAD_MODEL = "load";
    public static final String PARAMETER_VERSION = "version";
    public static final String OPENSEARCH_DASHBOARDS_USER_AGENT = "OpenSearch Dashboards";
    public static final String[] UI_METADATA_EXCLUDE = new String[]{"ui_metadata"};

    public static String getAlgorithm(RestRequest request) {
        String algorithm = request.param(PARAMETER_ALGORITHM);
        if (Strings.isNullOrEmpty((String)algorithm)) {
            throw new IllegalArgumentException("Request should contain algorithm!");
        }
        return algorithm.toUpperCase(Locale.ROOT);
    }

    public static boolean isAsync(RestRequest request) {
        return request.paramAsBoolean(PARAMETER_ASYNC, false);
    }

    public static boolean returnContent(RestRequest request) {
        return request.paramAsBoolean(PARAMETER_RETURN_CONTENT, false);
    }

    public static String getParameterId(RestRequest request, String idName) {
        String id = request.param(idName);
        if (Strings.isNullOrEmpty((String)id)) {
            throw new IllegalArgumentException("Request should contain " + idName);
        }
        return id;
    }

    public static FetchSourceContext getSourceContext(RestRequest request, SearchSourceBuilder searchSourceBuilder) {
        String userAgent = Strings.coalesceToEmpty((String)request.header("User-Agent"));
        if (searchSourceBuilder.fetchSource() != null) {
            Object[] includes = searchSourceBuilder.fetchSource().includes();
            Object[] excludes = searchSourceBuilder.fetchSource().excludes();
            if (!ArrayUtils.contains((Object[])includes, (Object)"model_content")) {
                ArrayUtils.add((Object[])excludes, (Object)"model_content");
            }
            if (!ArrayUtils.contains((Object[])includes, (Object)"content")) {
                ArrayUtils.add((Object[])excludes, (Object)"content");
            }
            String[] metadataExcludes = new String[excludes.length + 1];
            if (!userAgent.contains(OPENSEARCH_DASHBOARDS_USER_AGENT)) {
                if (excludes.length == 0) {
                    return new FetchSourceContext(true, (String[])includes, UI_METADATA_EXCLUDE);
                }
                System.arraycopy(excludes, 0, metadataExcludes, 0, excludes.length);
                metadataExcludes[metadataExcludes.length - 1] = "ui_metadata";
                return new FetchSourceContext(true, (String[])includes, metadataExcludes);
            }
            return new FetchSourceContext(true, (String[])includes, (String[])excludes);
        }
        Object[] excludes = new String[]{"content", "model_content"};
        if (!userAgent.contains(OPENSEARCH_DASHBOARDS_USER_AGENT)) {
            return new FetchSourceContext(true, Strings.EMPTY_ARRAY, (String[])ArrayUtils.add((Object[])excludes, (Object)"ui_metadata"));
        }
        return new FetchSourceContext(true, Strings.EMPTY_ARRAY, (String[])excludes);
    }

    public static FetchSourceContext getFetchSourceContext(boolean returnModelContent) {
        if (!returnModelContent) {
            return new FetchSourceContext(true, Strings.EMPTY_ARRAY, new String[]{"content", "model_content"});
        }
        return new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
    }

    public static String[] getAllNodes(ClusterService clusterService) {
        Iterator iterator = clusterService.state().nodes().iterator();
        ArrayList<String> nodeIds = new ArrayList<String>();
        while (iterator.hasNext()) {
            nodeIds.add(((DiscoveryNode)iterator.next()).getId());
        }
        return nodeIds.toArray(new String[0]);
    }

    public static void onFailure(RestChannel channel, RestStatus status, String errorMessage, Exception exception) {
        BytesRestResponse bytesRestResponse;
        try {
            bytesRestResponse = new BytesRestResponse(channel, exception);
        }
        catch (Exception e) {
            bytesRestResponse = new BytesRestResponse(status, errorMessage);
        }
        channel.sendResponse((RestResponse)bytesRestResponse);
    }

    @VisibleForTesting
    public static Optional<String[]> splitCommaSeparatedParam(RestRequest request, String paramName) {
        return Optional.ofNullable(request.param(paramName)).map(s -> s.split(","));
    }
}

