/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.ml.common.transport.upload_chunk.MLUploadModelChunkAction;
import org.opensearch.ml.common.transport.upload_chunk.MLUploadModelChunkInput;
import org.opensearch.ml.common.transport.upload_chunk.MLUploadModelChunkRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLUploadModelChunkAction
extends BaseRestHandler {
    private static final String ML_UPLOAD_MODEL_CHUNK_ACTION = "ml_upload_model_chunk_action";

    public String getName() {
        return ML_UPLOAD_MODEL_CHUNK_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/chunk/{%s}", "/_plugins/_ml", "model_id", "chunk_number")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLUploadModelChunkRequest mlUploadModelRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLUploadModelChunkAction.INSTANCE, (ActionRequest)mlUploadModelRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLUploadModelChunkRequest getRequest(RestRequest request) throws IOException {
        String modelId = request.param("model_id");
        String chunk_number = request.param("chunk_number");
        byte[] content = request.content().streamInput().readAllBytes();
        MLUploadModelChunkInput mlInput = new MLUploadModelChunkInput(modelId, Integer.valueOf(Integer.parseInt(chunk_number)), content);
        return new MLUploadModelChunkRequest(mlInput);
    }
}

