/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.ml.common.transport.unload.MLUnloadModelAction;
import org.opensearch.ml.common.transport.unload.UnloadModelInput;
import org.opensearch.ml.common.transport.unload.UnloadModelNodesRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLUnloadModelAction
extends BaseRestHandler {
    private static final String ML_UNLOAD_MODEL_ACTION = "ml_unload_model_action";
    private ClusterService clusterService;

    public RestMLUnloadModelAction(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public String getName() {
        return ML_UNLOAD_MODEL_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/_unload", "/_plugins/_ml", "model_id")), (Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/_unload", "/_plugins/_ml")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        UnloadModelNodesRequest unloadModelNodesRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLUnloadModelAction.INSTANCE, (ActionRequest)unloadModelNodesRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    UnloadModelNodesRequest getRequest(RestRequest request) throws IOException {
        String modelId = request.param("model_id");
        Object[] targetModelIds = null;
        if (modelId != null) {
            targetModelIds = new String[]{modelId};
        }
        Object[] targetNodeIds = this.getAllNodes();
        if (request.hasContent()) {
            XContentParser parser = request.contentParser();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            UnloadModelInput mlInput = UnloadModelInput.parse((XContentParser)parser);
            Object[] nodeIds = mlInput.getNodeIds();
            Object[] modelIds = mlInput.getModelIds();
            if (ArrayUtils.isNotEmpty((Object[])nodeIds)) {
                targetNodeIds = nodeIds;
            }
            if (ArrayUtils.isNotEmpty((Object[])modelIds)) {
                targetModelIds = modelIds;
            }
        }
        return new UnloadModelNodesRequest((String[])targetNodeIds, (String[])targetModelIds);
    }

    private String[] getAllNodes() {
        Iterator iterator = this.clusterService.state().nodes().iterator();
        ArrayList<String> nodeIds = new ArrayList<String>();
        while (iterator.hasNext()) {
            nodeIds.add(((DiscoveryNode)iterator.next()).getId());
        }
        return nodeIds.toArray(new String[0]);
    }
}

