/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.ml.action.profile.MLProfileAction;
import org.opensearch.ml.action.profile.MLProfileRequest;
import org.opensearch.ml.profile.MLProfileInput;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;

public class RestMLProfileAction
extends BaseRestHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(RestMLProfileAction.class);
    private static final String PROFILE_ML_ACTION = "profile_ml";
    private ClusterService clusterService;

    public RestMLProfileAction(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public String getName() {
        return PROFILE_ML_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_ml/profile/models/{model_id}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_ml/profile/models"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_ml/profile/tasks/{task_id}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_ml/profile/tasks"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_ml/profile"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLProfileInput mlProfileInput;
        boolean hasContent = request.hasContent();
        if (hasContent) {
            XContentParser parser = request.contentParser();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            mlProfileInput = MLProfileInput.parse(parser);
        } else {
            mlProfileInput = this.createMLProfileInputFromRequestParams(request);
        }
        String[] nodeIds = mlProfileInput.retrieveProfileOnAllNodes() ? RestActionUtils.getAllNodes(this.clusterService) : mlProfileInput.getNodeIds().toArray(new String[0]);
        MLProfileRequest mlProfileRequest = new MLProfileRequest(nodeIds, mlProfileInput);
        return channel -> {
            XContentBuilder builder = channel.newBuilder();
            client.execute((ActionType)MLProfileAction.INSTANCE, (ActionRequest)mlProfileRequest, ActionListener.wrap(r -> {
                builder.startObject();
                List nodeProfiles = r.getNodes().stream().filter(s -> !s.isEmpty()).collect(Collectors.toList());
                log.debug("Build MLProfileNodeResponse for size of {}", (Object)nodeProfiles.size());
                if (nodeProfiles.size() > 0) {
                    r.toXContent(builder, ToXContent.EMPTY_PARAMS);
                }
                builder.endObject();
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
            }, e -> {
                String errorMessage = "Failed to get ML node level profile";
                log.error(errorMessage, (Throwable)e);
                RestActionUtils.onFailure(channel, RestStatus.INTERNAL_SERVER_ERROR, errorMessage, e);
            }));
        };
    }

    MLProfileInput createMLProfileInputFromRequestParams(RestRequest request) {
        MLProfileInput mlProfileInput = new MLProfileInput();
        Optional<String[]> modelIds = RestActionUtils.splitCommaSeparatedParam(request, "model_id");
        String uri = request.getHttpRequest().uri();
        boolean profileModel = uri.contains("models");
        boolean profileTask = uri.contains("tasks");
        if (modelIds.isPresent()) {
            mlProfileInput.getModelIds().addAll(Arrays.asList(modelIds.get()));
        } else if (profileModel) {
            mlProfileInput.setReturnAllModels(true);
        }
        Optional<String[]> taskIds = RestActionUtils.splitCommaSeparatedParam(request, "task_id");
        if (taskIds.isPresent()) {
            mlProfileInput.getTaskIds().addAll(Arrays.asList(taskIds.get()));
        } else if (profileTask) {
            mlProfileInput.setReturnAllTasks(true);
        }
        if (!profileModel && !profileTask) {
            mlProfileInput.setReturnAllTasks(true);
            mlProfileInput.setReturnAllModels(true);
        }
        return mlProfileInput;
    }
}

