/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.transport.model.MLModelGetAction;
import org.opensearch.ml.common.transport.model.MLModelGetRequest;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskAction;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskRequest;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLPredictionAction
extends BaseRestHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(RestMLPredictionAction.class);
    private static final String ML_PREDICTION_ACTION = "ml_prediction_action";

    public String getName() {
        return ML_PREDICTION_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/_predict/{%s}/{%s}", "/_plugins/_ml", "algorithm", "model_id")), (Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/_predict", "/_plugins/_ml", "model_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String algorithm = request.param("algorithm");
        String modelId = RestActionUtils.getParameterId(request, "model_id");
        if (algorithm != null) {
            MLPredictionTaskRequest mlPredictionTaskRequest = this.getRequest(modelId, algorithm, request);
            return channel -> client.execute((ActionType)MLPredictionTaskAction.INSTANCE, (ActionRequest)mlPredictionTaskRequest, (ActionListener)new RestToXContentListener(channel));
        }
        return channel -> {
            MLModelGetRequest getModelRequest = new MLModelGetRequest(modelId, false);
            ActionListener listener = ActionListener.wrap(r -> {
                MLModel mlModel = r.getMlModel();
                String algoName = mlModel.getAlgorithm().name();
                client.execute((ActionType)MLPredictionTaskAction.INSTANCE, (ActionRequest)this.getRequest(modelId, algoName, request), (ActionListener)new RestToXContentListener(channel));
            }, e -> {
                log.error("Failed to get ML model", (Throwable)e);
                try {
                    channel.sendResponse((RestResponse)new BytesRestResponse(channel, e));
                }
                catch (IOException ex) {
                    log.error("Failed to send error response", (Throwable)ex);
                }
            });
            client.execute((ActionType)MLModelGetAction.INSTANCE, (ActionRequest)getModelRequest, listener);
        };
    }

    @VisibleForTesting
    MLPredictionTaskRequest getRequest(String modelId, String algorithm, RestRequest request) throws IOException {
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLInput mlInput = MLInput.parse((XContentParser)parser, (String)algorithm);
        return new MLPredictionTaskRequest(modelId, mlInput);
    }
}

