/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.ml.common.transport.upload_chunk.MLCreateModelMetaAction;
import org.opensearch.ml.common.transport.upload_chunk.MLCreateModelMetaInput;
import org.opensearch.ml.common.transport.upload_chunk.MLCreateModelMetaRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLCreateModelMetaAction
extends BaseRestHandler {
    private static final String ML_CREATE_MODEL_META_ACTION = "ml_create_model_meta_action";

    public String getName() {
        return ML_CREATE_MODEL_META_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/meta", "/_plugins/_ml")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLCreateModelMetaRequest mlCreateModelMetaRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLCreateModelMetaAction.INSTANCE, (ActionRequest)mlCreateModelMetaRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLCreateModelMetaRequest getRequest(RestRequest request) throws IOException {
        boolean hasContent = request.hasContent();
        if (!hasContent) {
            throw new IOException("Model meta request has empty body");
        }
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLCreateModelMetaInput mlInput = MLCreateModelMetaInput.parse((XContentParser)parser);
        return new MLCreateModelMetaRequest(mlInput);
    }
}

