/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.profile;

import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.ml.common.model.MLModelState;
import org.opensearch.ml.profile.MLPredictRequestStats;

public class MLModelProfile
implements ToXContentFragment,
Writeable {
    @Generated
    private static final Logger log = LogManager.getLogger(MLModelProfile.class);
    private final MLModelState modelState;
    private final String predictor;
    private final String[] workerNodes;
    private final MLPredictRequestStats modelInferenceStats;
    private final MLPredictRequestStats predictRequestStats;

    public MLModelProfile(MLModelState modelState, String predictor, String[] workerNodes, MLPredictRequestStats modelInferenceStats, MLPredictRequestStats predictRequestStats) {
        this.modelState = modelState;
        this.predictor = predictor;
        this.workerNodes = workerNodes;
        this.modelInferenceStats = modelInferenceStats;
        this.predictRequestStats = predictRequestStats;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.modelState != null) {
            builder.field("model_state", (Object)this.modelState);
        }
        if (this.predictor != null) {
            builder.field("predictor", this.predictor);
        }
        if (this.workerNodes != null) {
            builder.field("worker_nodes", (Object)this.workerNodes);
        }
        if (this.modelInferenceStats != null) {
            builder.field("model_inference_stats", (ToXContent)this.modelInferenceStats);
        }
        if (this.predictRequestStats != null) {
            builder.field("predict_request_stats", (ToXContent)this.predictRequestStats);
        }
        builder.endObject();
        return builder;
    }

    public MLModelProfile(StreamInput in) throws IOException {
        this.modelState = in.readBoolean() ? (MLModelState)in.readEnum(MLModelState.class) : null;
        this.predictor = in.readOptionalString();
        this.workerNodes = in.readOptionalStringArray();
        this.modelInferenceStats = in.readBoolean() ? new MLPredictRequestStats(in) : null;
        this.predictRequestStats = in.readBoolean() ? new MLPredictRequestStats(in) : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.modelState != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.modelState);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.predictor);
        out.writeOptionalStringArray(this.workerNodes);
        if (this.modelInferenceStats != null) {
            out.writeBoolean(true);
            this.modelInferenceStats.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.predictRequestStats != null) {
            out.writeBoolean(true);
            this.predictRequestStats.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Generated
    public static MLModelProfileBuilder builder() {
        return new MLModelProfileBuilder();
    }

    @Generated
    public MLModelState getModelState() {
        return this.modelState;
    }

    @Generated
    public String getPredictor() {
        return this.predictor;
    }

    @Generated
    public String[] getWorkerNodes() {
        return this.workerNodes;
    }

    @Generated
    public MLPredictRequestStats getModelInferenceStats() {
        return this.modelInferenceStats;
    }

    @Generated
    public MLPredictRequestStats getPredictRequestStats() {
        return this.predictRequestStats;
    }

    @Generated
    public static class MLModelProfileBuilder {
        @Generated
        private MLModelState modelState;
        @Generated
        private String predictor;
        @Generated
        private String[] workerNodes;
        @Generated
        private MLPredictRequestStats modelInferenceStats;
        @Generated
        private MLPredictRequestStats predictRequestStats;

        @Generated
        MLModelProfileBuilder() {
        }

        @Generated
        public MLModelProfileBuilder modelState(MLModelState modelState) {
            this.modelState = modelState;
            return this;
        }

        @Generated
        public MLModelProfileBuilder predictor(String predictor) {
            this.predictor = predictor;
            return this;
        }

        @Generated
        public MLModelProfileBuilder workerNodes(String[] workerNodes) {
            this.workerNodes = workerNodes;
            return this;
        }

        @Generated
        public MLModelProfileBuilder modelInferenceStats(MLPredictRequestStats modelInferenceStats) {
            this.modelInferenceStats = modelInferenceStats;
            return this;
        }

        @Generated
        public MLModelProfileBuilder predictRequestStats(MLPredictRequestStats predictRequestStats) {
            this.predictRequestStats = predictRequestStats;
            return this;
        }

        @Generated
        public MLModelProfile build() {
            return new MLModelProfile(this.modelState, this.predictor, this.workerNodes, this.modelInferenceStats, this.predictRequestStats);
        }

        @Generated
        public String toString() {
            return "MLModelProfile.MLModelProfileBuilder(modelState=" + this.modelState + ", predictor=" + this.predictor + ", workerNodes=" + Arrays.deepToString(this.workerNodes) + ", modelInferenceStats=" + this.modelInferenceStats + ", predictRequestStats=" + this.predictRequestStats + ")";
        }
    }
}

