/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.indices;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.ml.common.CommonValue;
import org.opensearch.ml.common.exception.MLException;
import org.opensearch.ml.indices.MLIndex;

public class MLIndicesHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(MLIndicesHandler.class);
    private final ClusterService clusterService;
    private final Client client;
    private static final Map<String, AtomicBoolean> indexMappingUpdated = new HashMap<String, AtomicBoolean>();

    public void initModelIndexIfAbsent(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.MODEL, listener);
    }

    public void initMLTaskIndex(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.TASK, listener);
    }

    public void initMLIndexIfAbsent(MLIndex index, ActionListener<Boolean> listener) {
        String indexName = index.getIndexName();
        String mapping = index.getMapping();
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListener.runBefore(listener, () -> threadContext.restore());
            if (!this.clusterService.state().metadata().hasIndex(indexName)) {
                ActionListener actionListener = ActionListener.wrap(r -> {
                    if (r.isAcknowledged()) {
                        log.info("create index:{}", (Object)indexName);
                        internalListener.onResponse((Object)true);
                    } else {
                        internalListener.onResponse((Object)false);
                    }
                }, e -> {
                    log.error("Failed to create index " + indexName, (Throwable)e);
                    internalListener.onFailure(e);
                });
                CreateIndexRequest request = new CreateIndexRequest(indexName).mapping(mapping);
                this.client.admin().indices().create(request, actionListener);
            } else {
                log.info("index:{} is already created", (Object)indexName);
                if (indexMappingUpdated.containsKey(indexName) && !indexMappingUpdated.get(indexName).get()) {
                    this.shouldUpdateIndex(indexName, index.getVersion(), (ActionListener<Boolean>)ActionListener.wrap(r -> {
                        if (r.booleanValue()) {
                            this.client.admin().indices().putMapping(new PutMappingRequest().indices(new String[]{indexName}).source(mapping, XContentType.JSON), ActionListener.wrap(response -> {
                                if (response.isAcknowledged()) {
                                    indexMappingUpdated.get(indexName).set(true);
                                    internalListener.onResponse((Object)true);
                                } else {
                                    internalListener.onFailure((Exception)new MLException("Failed to update index: " + indexName));
                                }
                            }, exception -> {
                                log.error("Failed to update index " + indexName, (Throwable)exception);
                                internalListener.onFailure(exception);
                            }));
                        } else {
                            indexMappingUpdated.get(indexName).set(true);
                            internalListener.onResponse((Object)true);
                        }
                    }, e -> {
                        log.error("Failed to update index mapping", (Throwable)e);
                        internalListener.onFailure(e);
                    }));
                } else {
                    internalListener.onResponse((Object)true);
                }
            }
        }
        catch (Exception e2) {
            log.error("Failed to init index " + indexName, (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    public void shouldUpdateIndex(String indexName, Integer newVersion, ActionListener<Boolean> listener) {
        Map metaMapping;
        Object schemaVersion;
        IndexMetadata indexMetaData = (IndexMetadata)this.clusterService.state().getMetadata().indices().get((Object)indexName);
        if (indexMetaData == null) {
            listener.onResponse((Object)Boolean.FALSE);
            return;
        }
        Integer oldVersion = CommonValue.NO_SCHEMA_VERSION;
        Map indexMapping = indexMetaData.mapping().getSourceAsMap();
        Object meta = indexMapping.get("_meta");
        if (meta != null && meta instanceof Map && (schemaVersion = (metaMapping = (Map)meta).get("schema_version")) instanceof Integer) {
            oldVersion = (Integer)schemaVersion;
        }
        listener.onResponse((Object)(newVersion > oldVersion ? 1 : 0));
    }

    @Generated
    public MLIndicesHandler(ClusterService clusterService, Client client) {
        this.clusterService = clusterService;
        this.client = client;
    }

    static {
        indexMappingUpdated.put(".plugins-ml-model", new AtomicBoolean(false));
        indexMappingUpdated.put(".plugins-ml-task", new AtomicBoolean(false));
    }
}

