/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.cluster;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.Client;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.ml.cluster.DiscoveryNodeHelper;
import org.opensearch.ml.common.transport.sync.MLSyncUpAction;
import org.opensearch.ml.common.transport.sync.MLSyncUpInput;
import org.opensearch.ml.common.transport.sync.MLSyncUpNodeResponse;
import org.opensearch.ml.common.transport.sync.MLSyncUpNodesRequest;

public class MLSyncUpCron
implements Runnable {
    @Generated
    private static final Logger log = LogManager.getLogger(MLSyncUpCron.class);
    private Client client;
    private DiscoveryNodeHelper nodeHelper;

    public MLSyncUpCron(Client client, DiscoveryNodeHelper nodeHelper) {
        this.client = client;
        this.nodeHelper = nodeHelper;
    }

    @Override
    public void run() {
        log.debug("ML sync job starts");
        DiscoveryNode[] allNodes = this.nodeHelper.getAllNodes();
        MLSyncUpInput gatherInfoInput = MLSyncUpInput.builder().getLoadedModels(true).build();
        MLSyncUpNodesRequest gatherInfoRequest = new MLSyncUpNodesRequest(allNodes, gatherInfoInput);
        this.client.execute((ActionType)MLSyncUpAction.INSTANCE, (ActionRequest)gatherInfoRequest, ActionListener.wrap(r -> {
            List responses = r.getNodes();
            HashMap<String, Set> modelWorkerNodes = new HashMap<String, Set>();
            HashMap<String, Set> runningLoadModelTasks = new HashMap<String, Set>();
            for (MLSyncUpNodeResponse mLSyncUpNodeResponse : responses) {
                String[] runningLoadModelTaskIds;
                String nodeId = mLSyncUpNodeResponse.getNode().getId();
                String[] loadedModelIds = mLSyncUpNodeResponse.getLoadedModelIds();
                if (loadedModelIds != null && loadedModelIds.length > 0) {
                    for (String modelId : loadedModelIds) {
                        Set workerNodes = modelWorkerNodes.computeIfAbsent(modelId, it -> new HashSet());
                        workerNodes.add(nodeId);
                    }
                }
                if ((runningLoadModelTaskIds = mLSyncUpNodeResponse.getRunningLoadModelTaskIds()) == null || runningLoadModelTaskIds.length <= 0) continue;
                for (String taskId : runningLoadModelTaskIds) {
                    Set workerNodes = runningLoadModelTasks.computeIfAbsent(taskId, it -> new HashSet());
                    workerNodes.add(nodeId);
                }
            }
            for (Map.Entry entry : modelWorkerNodes.entrySet()) {
                log.debug("will sync model worker nodes for model: {}: {}", entry.getKey(), (Object)((Set)entry.getValue()).toArray(new String[0]));
            }
            for (Map.Entry entry : runningLoadModelTasks.entrySet()) {
                log.debug("will sync running task: {}: {}", entry.getKey(), (Object)((Set)entry.getValue()).toArray(new String[0]));
            }
            MLSyncUpInput.MLSyncUpInputBuilder inputBuilder = MLSyncUpInput.builder().syncRunningLoadModelTasks(true).runningLoadModelTasks(runningLoadModelTasks);
            if (modelWorkerNodes.size() == 0) {
                log.debug("No loaded model found. Will clear model routing on all nodes");
                inputBuilder.clearRoutingTable(true);
            } else {
                inputBuilder.modelRoutingTable(modelWorkerNodes);
            }
            MLSyncUpInput mLSyncUpInput = inputBuilder.build();
            MLSyncUpNodesRequest syncUpRequest = new MLSyncUpNodesRequest(allNodes, mLSyncUpInput);
            this.client.execute((ActionType)MLSyncUpAction.INSTANCE, (ActionRequest)syncUpRequest, ActionListener.wrap(re -> log.debug("sync model routing job finished"), ex -> log.error("Failed to sync model routing", (Throwable)ex)));
        }, e -> log.error("Failed to sync model routing", (Throwable)e)));
    }
}

