/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.upload_chunk;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.ml.action.upload_chunk.MLModelMetaCreate;
import org.opensearch.ml.common.MLTaskState;
import org.opensearch.ml.common.transport.upload_chunk.MLCreateModelMetaInput;
import org.opensearch.ml.common.transport.upload_chunk.MLCreateModelMetaRequest;
import org.opensearch.ml.common.transport.upload_chunk.MLCreateModelMetaResponse;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportCreateModelMetaAction
extends HandledTransportAction<ActionRequest, MLCreateModelMetaResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportCreateModelMetaAction.class);
    TransportService transportService;
    ActionFilters actionFilters;
    MLModelMetaCreate mlModelMetaCreate;

    @Inject
    public TransportCreateModelMetaAction(TransportService transportService, ActionFilters actionFilters, MLModelMetaCreate mlModelMetaCreate) {
        super("cluster:admin/opensearch/ml/create_model_meta", transportService, actionFilters, MLCreateModelMetaRequest::new);
        this.transportService = transportService;
        this.actionFilters = actionFilters;
        this.mlModelMetaCreate = mlModelMetaCreate;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLCreateModelMetaResponse> listener) {
        MLCreateModelMetaRequest createModelMetaRequest = MLCreateModelMetaRequest.fromActionRequest((ActionRequest)request);
        MLCreateModelMetaInput mlUploadInput = createModelMetaRequest.getMlCreateModelMetaInput();
        this.mlModelMetaCreate.createModelMeta(mlUploadInput, (ActionListener<String>)ActionListener.wrap(modelId -> listener.onResponse((Object)new MLCreateModelMetaResponse(modelId, MLTaskState.CREATED.name())), ex -> {
            log.error("Failed to init model index", (Throwable)ex);
            listener.onFailure(ex);
        }));
    }
}

