/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.upload_chunk;

import java.time.Instant;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.model.MLModelState;
import org.opensearch.ml.common.transport.upload_chunk.MLCreateModelMetaInput;
import org.opensearch.ml.indices.MLIndicesHandler;
import org.opensearch.threadpool.ThreadPool;

public class MLModelMetaCreate {
    @Generated
    private static final Logger log = LogManager.getLogger(MLModelMetaCreate.class);
    private final MLIndicesHandler mlIndicesHandler;
    private final ThreadPool threadPool;
    private final Client client;

    @Inject
    public MLModelMetaCreate(MLIndicesHandler mlIndicesHandler, ThreadPool threadPool, Client client) {
        this.mlIndicesHandler = mlIndicesHandler;
        this.threadPool = threadPool;
        this.client = client;
    }

    public void createModelMeta(MLCreateModelMetaInput mlCreateModelMetaInput, ActionListener<String> listener) {
        try {
            String modelName = mlCreateModelMetaInput.getName();
            String version = mlCreateModelMetaInput.getVersion();
            FunctionName functionName = mlCreateModelMetaInput.getFunctionName();
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                this.mlIndicesHandler.initModelIndexIfAbsent((ActionListener<Boolean>)ActionListener.wrap(res -> {
                    MLModel mlModelMeta = MLModel.builder().name(modelName).algorithm(functionName).version(version).description(mlCreateModelMetaInput.getDescription()).modelFormat(mlCreateModelMetaInput.getModelFormat()).modelState(MLModelState.UPLOADING).modelConfig(mlCreateModelMetaInput.getModelConfig()).totalChunks(mlCreateModelMetaInput.getTotalChunks()).modelContentHash(mlCreateModelMetaInput.getModelContentHashValue()).modelContentSizeInBytes(mlCreateModelMetaInput.getModelContentSizeInBytes()).createdTime(Instant.now()).build();
                    IndexRequest indexRequest = new IndexRequest(".plugins-ml-model");
                    indexRequest.source(mlModelMeta.toXContent(XContentBuilder.builder((XContent)XContentType.JSON.xContent()), ToXContent.EMPTY_PARAMS));
                    indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                    this.client.index(indexRequest, ActionListener.wrap(r -> {
                        log.debug("Index model meta doc successfully {}", (Object)modelName);
                        listener.onResponse((Object)r.getId());
                    }, e -> {
                        log.error("Failed to index model meta doc", (Throwable)e);
                        listener.onFailure(e);
                    }));
                }, ex -> {
                    log.error("Failed to init model index", (Throwable)ex);
                    listener.onFailure(ex);
                }));
            }
            catch (Exception e) {
                log.error("Failed to create model meta doc", (Throwable)e);
                listener.onFailure(e);
            }
        }
        catch (Exception e) {
            log.error("Failed to init model index", (Throwable)e);
            listener.onFailure(e);
        }
    }
}

