/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.upload;

import java.time.Instant;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionListenerResponseHandler;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.ml.cluster.DiscoveryNodeHelper;
import org.opensearch.ml.common.MLTask;
import org.opensearch.ml.common.MLTaskState;
import org.opensearch.ml.common.MLTaskType;
import org.opensearch.ml.common.transport.forward.MLForwardInput;
import org.opensearch.ml.common.transport.forward.MLForwardRequest;
import org.opensearch.ml.common.transport.forward.MLForwardRequestType;
import org.opensearch.ml.common.transport.forward.MLForwardResponse;
import org.opensearch.ml.common.transport.upload.MLUploadInput;
import org.opensearch.ml.common.transport.upload.MLUploadModelRequest;
import org.opensearch.ml.common.transport.upload.UploadModelResponse;
import org.opensearch.ml.engine.ModelHelper;
import org.opensearch.ml.indices.MLIndicesHandler;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.settings.MLCommonsSettings;
import org.opensearch.ml.stats.MLNodeLevelStat;
import org.opensearch.ml.stats.MLStats;
import org.opensearch.ml.task.MLTaskDispatcher;
import org.opensearch.ml.task.MLTaskManager;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;

public class TransportUploadModelAction
extends HandledTransportAction<ActionRequest, UploadModelResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportUploadModelAction.class);
    TransportService transportService;
    ModelHelper modelHelper;
    MLIndicesHandler mlIndicesHandler;
    MLModelManager mlModelManager;
    MLTaskManager mlTaskManager;
    ClusterService clusterService;
    ThreadPool threadPool;
    Client client;
    DiscoveryNodeHelper nodeFilter;
    MLTaskDispatcher mlTaskDispatcher;
    MLStats mlStats;
    String trustedUrlRegex;

    @Inject
    public TransportUploadModelAction(TransportService transportService, ActionFilters actionFilters, ModelHelper modelHelper, MLIndicesHandler mlIndicesHandler, MLModelManager mlModelManager, MLTaskManager mlTaskManager, ClusterService clusterService, Settings settings, ThreadPool threadPool, Client client, DiscoveryNodeHelper nodeFilter, MLTaskDispatcher mlTaskDispatcher, MLStats mlStats) {
        super("cluster:admin/opensearch/ml/upload_model", transportService, actionFilters, MLUploadModelRequest::new);
        this.transportService = transportService;
        this.modelHelper = modelHelper;
        this.mlIndicesHandler = mlIndicesHandler;
        this.mlModelManager = mlModelManager;
        this.mlTaskManager = mlTaskManager;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.nodeFilter = nodeFilter;
        this.mlTaskDispatcher = mlTaskDispatcher;
        this.mlStats = mlStats;
        this.trustedUrlRegex = (String)MLCommonsSettings.ML_COMMONS_TRUSTED_URL_REGEX.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_TRUSTED_URL_REGEX, it -> {
            this.trustedUrlRegex = it;
        });
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<UploadModelResponse> listener) {
        MLUploadModelRequest uploadModelRequest = MLUploadModelRequest.fromActionRequest((ActionRequest)request);
        MLUploadInput mlUploadInput = uploadModelRequest.getMlUploadInput();
        Pattern pattern = Pattern.compile(this.trustedUrlRegex);
        boolean validUrl = pattern.matcher(mlUploadInput.getUrl()).find();
        if (!validUrl) {
            throw new IllegalArgumentException("URL can't match trusted url regex");
        }
        this.mlStats.getStat(MLNodeLevelStat.ML_NODE_TOTAL_REQUEST_COUNT).increment();
        MLTask mlTask = MLTask.builder().async(true).taskType(MLTaskType.UPLOAD_MODEL).functionName(mlUploadInput.getFunctionName()).createTime(Instant.now()).lastUpdateTime(Instant.now()).state(MLTaskState.CREATED).workerNode(this.clusterService.localNode().getId()).build();
        this.mlTaskDispatcher.dispatch((ActionListener<DiscoveryNode>)ActionListener.wrap(node -> {
            String nodeId = node.getId();
            mlTask.setWorkerNode(nodeId);
            this.mlTaskManager.createMLTask(mlTask, (ActionListener<IndexResponse>)ActionListener.wrap(response -> {
                String taskId = response.getId();
                mlTask.setTaskId(taskId);
                listener.onResponse((Object)new UploadModelResponse(taskId, MLTaskState.CREATED.name()));
                if (this.clusterService.localNode().getId().equals(nodeId)) {
                    this.mlModelManager.uploadMLModel(mlUploadInput, mlTask);
                } else {
                    MLForwardInput forwardInput = MLForwardInput.builder().requestType(MLForwardRequestType.UPLOAD_MODEL).uploadInput(mlUploadInput).mlTask(mlTask).build();
                    MLForwardRequest forwardRequest = new MLForwardRequest(forwardInput);
                    ActionListener myListener = ActionListener.wrap(res -> log.debug("Response from model node: " + res), ex -> log.error("Failure from model node", (Throwable)ex));
                    try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                        this.transportService.sendRequest(node, "cluster:admin/opensearch/mlinternal/forward", (TransportRequest)forwardRequest, (TransportResponseHandler)new ActionListenerResponseHandler(myListener, MLForwardResponse::new));
                    }
                }
            }, exception -> {
                log.error("Failed to create upload model task", (Throwable)exception);
                listener.onFailure(exception);
            }));
        }, e -> {
            log.error("Failed to dispatch upload model task ", (Throwable)e);
            listener.onFailure(e);
        }));
    }
}

