/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.syncup;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.ml.common.transport.sync.MLSyncUpInput;
import org.opensearch.ml.common.transport.sync.MLSyncUpNodeRequest;
import org.opensearch.ml.common.transport.sync.MLSyncUpNodeResponse;
import org.opensearch.ml.common.transport.sync.MLSyncUpNodesRequest;
import org.opensearch.ml.common.transport.sync.MLSyncUpNodesResponse;
import org.opensearch.ml.engine.MLEngine;
import org.opensearch.ml.engine.ModelHelper;
import org.opensearch.ml.engine.utils.FileUtils;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.task.MLTaskManager;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportSyncUpOnNodeAction
extends TransportNodesAction<MLSyncUpNodesRequest, MLSyncUpNodesResponse, MLSyncUpNodeRequest, MLSyncUpNodeResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportSyncUpOnNodeAction.class);
    TransportService transportService;
    ModelHelper modelHelper;
    MLTaskManager mlTaskManager;
    MLModelManager mlModelManager;
    ClusterService clusterService;
    ThreadPool threadPool;
    Client client;
    NamedXContentRegistry xContentRegistry;
    MLEngine mlEngine;

    @Inject
    public TransportSyncUpOnNodeAction(TransportService transportService, ActionFilters actionFilters, ModelHelper modelHelper, MLTaskManager mlTaskManager, MLModelManager mlModelManager, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry, MLEngine mlEngine) {
        super("cluster:admin/opensearch/mlinternal/syncup", threadPool, clusterService, transportService, actionFilters, MLSyncUpNodesRequest::new, MLSyncUpNodeRequest::new, "management", MLSyncUpNodeResponse.class);
        this.transportService = transportService;
        this.modelHelper = modelHelper;
        this.mlTaskManager = mlTaskManager;
        this.mlModelManager = mlModelManager;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.mlEngine = mlEngine;
    }

    protected MLSyncUpNodesResponse newResponse(MLSyncUpNodesRequest nodesRequest, List<MLSyncUpNodeResponse> responses, List<FailedNodeException> failures) {
        return new MLSyncUpNodesResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected MLSyncUpNodeRequest newNodeRequest(MLSyncUpNodesRequest request) {
        return new MLSyncUpNodeRequest(request);
    }

    protected MLSyncUpNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new MLSyncUpNodeResponse(in);
    }

    protected MLSyncUpNodeResponse nodeOperation(MLSyncUpNodeRequest request) {
        return this.createSyncUpNodeResponse(request.getSyncUpNodesRequest());
    }

    private MLSyncUpNodeResponse createSyncUpNodeResponse(MLSyncUpNodesRequest loadModelNodesRequest) {
        MLSyncUpInput syncUpInput = loadModelNodesRequest.getSyncUpInput();
        Map addedWorkerNodes = syncUpInput.getAddedWorkerNodes();
        Map removedWorkerNodes = syncUpInput.getRemovedWorkerNodes();
        Map modelRoutingTable = syncUpInput.getModelRoutingTable();
        Map runningLoadModelTasks = syncUpInput.getRunningLoadModelTasks();
        if (addedWorkerNodes != null && addedWorkerNodes.size() > 0) {
            for (Map.Entry entry : addedWorkerNodes.entrySet()) {
                this.mlModelManager.addModelWorkerNode((String)entry.getKey(), (String[])entry.getValue());
            }
        }
        if (removedWorkerNodes != null && removedWorkerNodes.size() > 0) {
            for (Map.Entry entry : removedWorkerNodes.entrySet()) {
                this.mlModelManager.removeModelWorkerNode((String)entry.getKey(), (String[])entry.getValue());
            }
        }
        String[] loadedModelIds = null;
        String[] runningLoadModelTaskIds = null;
        if (syncUpInput.isGetLoadedModels()) {
            loadedModelIds = this.mlModelManager.getLocalLoadedModels();
            runningLoadModelTaskIds = this.mlTaskManager.getLocalRunningLoadModelTasks();
        }
        if (syncUpInput.isClearRoutingTable()) {
            this.mlModelManager.clearRoutingTable();
        } else if (modelRoutingTable != null) {
            for (Map.Entry entry : modelRoutingTable.entrySet()) {
                log.debug("latest routing table for model: {}:  {}", entry.getKey(), (Object)((Set)entry.getValue()).toArray(new String[0]));
            }
            this.mlModelManager.syncModelWorkerNodes(modelRoutingTable);
        }
        if (syncUpInput.isSyncRunningLoadModelTasks()) {
            this.mlTaskManager.syncRunningLoadModelTasks(runningLoadModelTasks);
        }
        this.cleanUpLocalCacheFiles();
        return new MLSyncUpNodeResponse(this.clusterService.localNode(), "ok", loadedModelIds, runningLoadModelTaskIds);
    }

    private void cleanUpLocalCacheFiles() {
        Path modelCacheRootPath;
        Path loadModelRootPath;
        Path uploadModelRootPath = this.mlEngine.getUploadModelRootPath();
        Set modelsInCacheFolder = FileUtils.getFileNames((Path[])new Path[]{uploadModelRootPath, loadModelRootPath = this.mlEngine.getLoadModelRootPath(), modelCacheRootPath = this.mlEngine.getModelCacheRootPath()});
        if (modelsInCacheFolder.size() > 0) {
            log.debug("Found {} models in cache folder: {}", (Object)modelsInCacheFolder.size(), (Object)Arrays.toString(modelsInCacheFolder.toArray(new String[0])));
            for (String modelId : modelsInCacheFolder) {
                if (this.mlTaskManager.contains(modelId) || this.mlTaskManager.containsModel(modelId) || this.mlModelManager.isModelRunningOnNode(modelId)) continue;
                log.info("ML model not in cache. Remove all of its cache files. model id: {}", (Object)modelId);
                this.deleteFileCache(modelId);
            }
        }
    }

    private void deleteFileCache(String modelId) {
        FileUtils.deleteFileQuietly((Path)this.mlEngine.getModelCachePath(modelId));
        FileUtils.deleteFileQuietly((Path)this.mlEngine.getLoadModelPath(modelId));
        FileUtils.deleteFileQuietly((Path)this.mlEngine.getUploadModelPath(modelId));
    }
}

