/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common;

import java.io.IOException;
import java.time.Instant;
import lombok.Generated;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.authuser.User;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLTaskState;
import org.opensearch.ml.common.MLTaskType;
import org.opensearch.ml.common.dataset.MLInputDataType;

public class MLTask
implements ToXContentObject,
Writeable {
    public static final String TASK_ID_FIELD = "task_id";
    public static final String MODEL_ID_FIELD = "model_id";
    public static final String TASK_TYPE_FIELD = "task_type";
    public static final String FUNCTION_NAME_FIELD = "function_name";
    public static final String STATE_FIELD = "state";
    public static final String INPUT_TYPE_FIELD = "input_type";
    public static final String PROGRESS_FIELD = "progress";
    public static final String OUTPUT_INDEX_FIELD = "output_index";
    public static final String WORKER_NODE_FIELD = "worker_node";
    public static final String CREATE_TIME_FIELD = "create_time";
    public static final String LAST_UPDATE_TIME_FIELD = "last_update_time";
    public static final String ERROR_FIELD = "error";
    public static final String IS_ASYNC_TASK_FIELD = "is_async";
    private String taskId;
    private String modelId;
    private final MLTaskType taskType;
    private final FunctionName functionName;
    private MLTaskState state;
    private final MLInputDataType inputType;
    private Float progress;
    private final String outputIndex;
    private String workerNode;
    private final Instant createTime;
    private Instant lastUpdateTime;
    private String error;
    private User user;
    private boolean async;

    public MLTask(String taskId, String modelId, MLTaskType taskType, FunctionName functionName, MLTaskState state, MLInputDataType inputType, Float progress, String outputIndex, String workerNode, Instant createTime, Instant lastUpdateTime, String error, User user, boolean async) {
        this.taskId = taskId;
        this.modelId = modelId;
        this.taskType = taskType;
        this.functionName = functionName;
        this.state = state;
        this.inputType = inputType;
        this.progress = progress;
        this.outputIndex = outputIndex;
        this.workerNode = workerNode;
        this.createTime = createTime;
        this.lastUpdateTime = lastUpdateTime;
        this.error = error;
        this.user = user;
        this.async = async;
    }

    public MLTask(StreamInput input) throws IOException {
        this.taskId = input.readOptionalString();
        this.modelId = input.readOptionalString();
        this.taskType = (MLTaskType)input.readEnum(MLTaskType.class);
        this.functionName = (FunctionName)input.readEnum(FunctionName.class);
        this.state = (MLTaskState)input.readEnum(MLTaskState.class);
        this.inputType = input.readBoolean() ? (MLInputDataType)input.readEnum(MLInputDataType.class) : null;
        this.progress = input.readOptionalFloat();
        this.outputIndex = input.readOptionalString();
        this.workerNode = input.readString();
        this.createTime = input.readInstant();
        this.lastUpdateTime = input.readInstant();
        this.error = input.readOptionalString();
        this.user = input.readBoolean() ? new User(input) : null;
        this.async = input.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.taskId);
        out.writeOptionalString(this.modelId);
        out.writeEnum((Enum)this.taskType);
        out.writeEnum((Enum)this.functionName);
        out.writeEnum((Enum)this.state);
        if (this.inputType != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.inputType);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalFloat(this.progress);
        out.writeOptionalString(this.outputIndex);
        out.writeString(this.workerNode);
        out.writeInstant(this.createTime);
        out.writeInstant(this.lastUpdateTime);
        out.writeOptionalString(this.error);
        if (this.user != null) {
            this.user.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.async);
    }

    public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        XContentBuilder builder = xContentBuilder.startObject();
        if (this.taskId != null) {
            builder.field(TASK_ID_FIELD, this.taskId);
        }
        if (this.modelId != null) {
            builder.field(MODEL_ID_FIELD, this.modelId);
        }
        if (this.taskType != null) {
            builder.field(TASK_TYPE_FIELD, (Object)this.taskType);
        }
        if (this.functionName != null) {
            builder.field(FUNCTION_NAME_FIELD, (Object)this.functionName);
        }
        if (this.state != null) {
            builder.field(STATE_FIELD, (Object)this.state);
        }
        if (this.inputType != null) {
            builder.field(INPUT_TYPE_FIELD, (Object)this.inputType);
        }
        if (this.progress != null) {
            builder.field(PROGRESS_FIELD, this.progress);
        }
        if (this.outputIndex != null) {
            builder.field(OUTPUT_INDEX_FIELD, this.outputIndex);
        }
        if (this.workerNode != null) {
            builder.field(WORKER_NODE_FIELD, this.workerNode);
        }
        if (this.createTime != null) {
            builder.field(CREATE_TIME_FIELD, this.createTime.toEpochMilli());
        }
        if (this.lastUpdateTime != null) {
            builder.field(LAST_UPDATE_TIME_FIELD, this.lastUpdateTime.toEpochMilli());
        }
        if (this.error != null) {
            builder.field(ERROR_FIELD, this.error);
        }
        if (this.user != null) {
            builder.field("user", (ToXContent)this.user);
        }
        builder.field(IS_ASYNC_TASK_FIELD, this.async);
        return builder.endObject();
    }

    public static MLTask fromStream(StreamInput in) throws IOException {
        MLTask mlTask = new MLTask(in);
        return mlTask;
    }

    public static MLTask parse(XContentParser parser) throws IOException {
        String taskId = null;
        String modelId = null;
        MLTaskType taskType = null;
        FunctionName functionName = null;
        MLTaskState state = null;
        MLInputDataType inputType = null;
        Float progress = null;
        String outputIndex = null;
        String workerNode = null;
        Instant createTime = null;
        Instant lastUpdateTime = null;
        String error = null;
        User user = null;
        boolean async = false;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block32: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "task_id": {
                    taskId = parser.text();
                    continue block32;
                }
                case "model_id": {
                    modelId = parser.text();
                    continue block32;
                }
                case "task_type": {
                    taskType = MLTaskType.valueOf(parser.text());
                    continue block32;
                }
                case "function_name": {
                    functionName = FunctionName.from(parser.text());
                    continue block32;
                }
                case "state": {
                    state = MLTaskState.valueOf(parser.text());
                    continue block32;
                }
                case "input_type": {
                    inputType = MLInputDataType.valueOf(parser.text());
                    continue block32;
                }
                case "progress": {
                    progress = Float.valueOf(parser.floatValue());
                    continue block32;
                }
                case "output_index": {
                    outputIndex = parser.text();
                    continue block32;
                }
                case "worker_node": {
                    workerNode = parser.text();
                    continue block32;
                }
                case "create_time": {
                    createTime = Instant.ofEpochMilli(parser.longValue());
                    continue block32;
                }
                case "last_update_time": {
                    lastUpdateTime = Instant.ofEpochMilli(parser.longValue());
                    continue block32;
                }
                case "error": {
                    error = parser.text();
                    continue block32;
                }
                case "user": {
                    user = User.parse((XContentParser)parser);
                    continue block32;
                }
                case "is_async": {
                    async = parser.booleanValue();
                    continue block32;
                }
            }
            parser.skipChildren();
        }
        return MLTask.builder().taskId(taskId).modelId(modelId).taskType(taskType).functionName(functionName).state(state).inputType(inputType).progress(progress).outputIndex(outputIndex).workerNode(workerNode).createTime(createTime).lastUpdateTime(lastUpdateTime).error(error).user(user).async(async).build();
    }

    @Generated
    public static MLTaskBuilder builder() {
        return new MLTaskBuilder();
    }

    @Generated
    public MLTaskBuilder toBuilder() {
        return new MLTaskBuilder().taskId(this.taskId).modelId(this.modelId).taskType(this.taskType).functionName(this.functionName).state(this.state).inputType(this.inputType).progress(this.progress).outputIndex(this.outputIndex).workerNode(this.workerNode).createTime(this.createTime).lastUpdateTime(this.lastUpdateTime).error(this.error).user(this.user).async(this.async);
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public MLTaskType getTaskType() {
        return this.taskType;
    }

    @Generated
    public FunctionName getFunctionName() {
        return this.functionName;
    }

    @Generated
    public MLTaskState getState() {
        return this.state;
    }

    @Generated
    public MLInputDataType getInputType() {
        return this.inputType;
    }

    @Generated
    public Float getProgress() {
        return this.progress;
    }

    @Generated
    public String getOutputIndex() {
        return this.outputIndex;
    }

    @Generated
    public String getWorkerNode() {
        return this.workerNode;
    }

    @Generated
    public Instant getCreateTime() {
        return this.createTime;
    }

    @Generated
    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Generated
    public User getUser() {
        return this.user;
    }

    @Generated
    public boolean isAsync() {
        return this.async;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLTask)) {
            return false;
        }
        MLTask other = (MLTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAsync() != other.isAsync()) {
            return false;
        }
        Float this$progress = this.getProgress();
        Float other$progress = other.getProgress();
        if (this$progress == null ? other$progress != null : !((Object)this$progress).equals(other$progress)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$modelId = this.getModelId();
        String other$modelId = other.getModelId();
        if (this$modelId == null ? other$modelId != null : !this$modelId.equals(other$modelId)) {
            return false;
        }
        MLTaskType this$taskType = this.getTaskType();
        MLTaskType other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !((Object)((Object)this$taskType)).equals((Object)other$taskType)) {
            return false;
        }
        FunctionName this$functionName = this.getFunctionName();
        FunctionName other$functionName = other.getFunctionName();
        if (this$functionName == null ? other$functionName != null : !((Object)((Object)this$functionName)).equals((Object)other$functionName)) {
            return false;
        }
        MLTaskState this$state = this.getState();
        MLTaskState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        MLInputDataType this$inputType = this.getInputType();
        MLInputDataType other$inputType = other.getInputType();
        if (this$inputType == null ? other$inputType != null : !((Object)((Object)this$inputType)).equals((Object)other$inputType)) {
            return false;
        }
        String this$outputIndex = this.getOutputIndex();
        String other$outputIndex = other.getOutputIndex();
        if (this$outputIndex == null ? other$outputIndex != null : !this$outputIndex.equals(other$outputIndex)) {
            return false;
        }
        String this$workerNode = this.getWorkerNode();
        String other$workerNode = other.getWorkerNode();
        if (this$workerNode == null ? other$workerNode != null : !this$workerNode.equals(other$workerNode)) {
            return false;
        }
        Instant this$createTime = this.getCreateTime();
        Instant other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Instant this$lastUpdateTime = this.getLastUpdateTime();
        Instant other$lastUpdateTime = other.getLastUpdateTime();
        if (this$lastUpdateTime == null ? other$lastUpdateTime != null : !((Object)this$lastUpdateTime).equals(other$lastUpdateTime)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        return !(this$user == null ? other$user != null : !this$user.equals(other$user));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLTask;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAsync() ? 79 : 97);
        Float $progress = this.getProgress();
        result = result * 59 + ($progress == null ? 43 : ((Object)$progress).hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $modelId = this.getModelId();
        result = result * 59 + ($modelId == null ? 43 : $modelId.hashCode());
        MLTaskType $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : ((Object)((Object)$taskType)).hashCode());
        FunctionName $functionName = this.getFunctionName();
        result = result * 59 + ($functionName == null ? 43 : ((Object)((Object)$functionName)).hashCode());
        MLTaskState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        MLInputDataType $inputType = this.getInputType();
        result = result * 59 + ($inputType == null ? 43 : ((Object)((Object)$inputType)).hashCode());
        String $outputIndex = this.getOutputIndex();
        result = result * 59 + ($outputIndex == null ? 43 : $outputIndex.hashCode());
        String $workerNode = this.getWorkerNode();
        result = result * 59 + ($workerNode == null ? 43 : $workerNode.hashCode());
        Instant $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Instant $lastUpdateTime = this.getLastUpdateTime();
        result = result * 59 + ($lastUpdateTime == null ? 43 : ((Object)$lastUpdateTime).hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        return result;
    }

    @Generated
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Generated
    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    @Generated
    public void setState(MLTaskState state) {
        this.state = state;
    }

    @Generated
    public void setWorkerNode(String workerNode) {
        this.workerNode = workerNode;
    }

    @Generated
    public void setError(String error) {
        this.error = error;
    }

    @Generated
    public static class MLTaskBuilder {
        @Generated
        private String taskId;
        @Generated
        private String modelId;
        @Generated
        private MLTaskType taskType;
        @Generated
        private FunctionName functionName;
        @Generated
        private MLTaskState state;
        @Generated
        private MLInputDataType inputType;
        @Generated
        private Float progress;
        @Generated
        private String outputIndex;
        @Generated
        private String workerNode;
        @Generated
        private Instant createTime;
        @Generated
        private Instant lastUpdateTime;
        @Generated
        private String error;
        @Generated
        private User user;
        @Generated
        private boolean async;

        @Generated
        MLTaskBuilder() {
        }

        @Generated
        public MLTaskBuilder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Generated
        public MLTaskBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Generated
        public MLTaskBuilder taskType(MLTaskType taskType) {
            this.taskType = taskType;
            return this;
        }

        @Generated
        public MLTaskBuilder functionName(FunctionName functionName) {
            this.functionName = functionName;
            return this;
        }

        @Generated
        public MLTaskBuilder state(MLTaskState state) {
            this.state = state;
            return this;
        }

        @Generated
        public MLTaskBuilder inputType(MLInputDataType inputType) {
            this.inputType = inputType;
            return this;
        }

        @Generated
        public MLTaskBuilder progress(Float progress) {
            this.progress = progress;
            return this;
        }

        @Generated
        public MLTaskBuilder outputIndex(String outputIndex) {
            this.outputIndex = outputIndex;
            return this;
        }

        @Generated
        public MLTaskBuilder workerNode(String workerNode) {
            this.workerNode = workerNode;
            return this;
        }

        @Generated
        public MLTaskBuilder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        @Generated
        public MLTaskBuilder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Generated
        public MLTaskBuilder error(String error) {
            this.error = error;
            return this;
        }

        @Generated
        public MLTaskBuilder user(User user) {
            this.user = user;
            return this;
        }

        @Generated
        public MLTaskBuilder async(boolean async) {
            this.async = async;
            return this;
        }

        @Generated
        public MLTask build() {
            return new MLTask(this.taskId, this.modelId, this.taskType, this.functionName, this.state, this.inputType, this.progress, this.outputIndex, this.workerNode, this.createTime, this.lastUpdateTime, this.error, this.user, this.async);
        }

        @Generated
        public String toString() {
            return "MLTask.MLTaskBuilder(taskId=" + this.taskId + ", modelId=" + this.modelId + ", taskType=" + this.taskType + ", functionName=" + this.functionName + ", state=" + this.state + ", inputType=" + this.inputType + ", progress=" + this.progress + ", outputIndex=" + this.outputIndex + ", workerNode=" + this.workerNode + ", createTime=" + this.createTime + ", lastUpdateTime=" + this.lastUpdateTime + ", error=" + this.error + ", user=" + this.user + ", async=" + this.async + ")";
        }
    }
}

