/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.ml.common.transport.task.MLTaskGetAction;
import org.opensearch.ml.common.transport.task.MLTaskGetRequest;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLGetTaskAction
extends BaseRestHandler {
    private static final String ML_GET_Task_ACTION = "ml_get_task_action";

    public String getName() {
        return ML_GET_Task_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/tasks/{%s}", "/_plugins/_ml", "task_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLTaskGetRequest mlTaskGetRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLTaskGetAction.INSTANCE, (ActionRequest)mlTaskGetRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLTaskGetRequest getRequest(RestRequest request) throws IOException {
        String taskId = RestActionUtils.getParameterId(request, "task_id");
        return new MLTaskGetRequest(taskId);
    }
}

