/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.models;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.ml.common.transport.model.MLModelDeleteRequest;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class DeleteModelTransportAction
extends HandledTransportAction<ActionRequest, DeleteResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(DeleteModelTransportAction.class);
    private final Client client;

    @Inject
    public DeleteModelTransportAction(TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/opensearch/ml/models/delete", transportService, actionFilters, MLModelDeleteRequest::new);
        this.client = client;
    }

    protected void doExecute(Task task, ActionRequest request, final ActionListener<DeleteResponse> actionListener) {
        MLModelDeleteRequest mlModelDeleteRequest = MLModelDeleteRequest.fromActionRequest((ActionRequest)request);
        final String modelId = mlModelDeleteRequest.getModelId();
        DeleteRequest deleteRequest = new DeleteRequest(".plugins-ml-model", modelId);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.client.delete(deleteRequest, (ActionListener)new ActionListener<DeleteResponse>(){

                public void onResponse(DeleteResponse deleteResponse) {
                    log.info("Completed Delete Model Request, model id:{} deleted", (Object)modelId);
                    actionListener.onResponse((Object)deleteResponse);
                }

                public void onFailure(Exception e) {
                    log.error("Failed to delete ML model " + modelId, (Throwable)e);
                    actionListener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to delete ML model " + modelId, (Throwable)e);
            actionListener.onFailure(e);
        }
    }
}

