/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.opensearch.knn.index.codec.util.KNNVectorSerializer;

public class KNNVectorAsArraySerializer
implements KNNVectorSerializer {
    @Override
    public byte[] floatToByteArray(float[] input) {
        byte[] bytes;
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
             ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);){
            objectStream.writeObject(input);
            bytes = byteStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bytes;
    }

    @Override
    public float[] byteToFloatArray(ByteArrayInputStream byteStream) {
        try {
            ObjectInputStream objectStream = new ObjectInputStream(byteStream);
            float[] vector = (float[])objectStream.readObject();
            return vector;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

