/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.KnnVectorQuery;
import org.apache.lucene.search.Query;
import org.opensearch.knn.index.query.KNNQuery;
import org.opensearch.knn.index.util.KNNEngine;

public class KNNQueryFactory {
    @Generated
    private static final Logger log = LogManager.getLogger(KNNQueryFactory.class);

    public static Query create(KNNEngine knnEngine, String indexName, String fieldName, float[] vector, int k) {
        if (KNNEngine.getEnginesThatCreateCustomSegmentFiles().contains(knnEngine)) {
            log.debug(String.format("Creating custom k-NN query for index: %s \"\", field: %s \"\", k: %d", indexName, fieldName, k));
            return new KNNQuery(fieldName, vector, k, indexName);
        }
        log.debug(String.format("Creating Lucene k-NN query for index: %s \"\", field: %s \"\", k: %d", indexName, fieldName, k));
        return new KnnVectorQuery(fieldName, vector, k);
    }
}

