/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.indices;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.knn.index.IndexUtil;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.util.KNNEngine;
import org.opensearch.knn.indices.ModelState;

public class ModelMetadata
implements Writeable,
ToXContentObject {
    @Generated
    private static final Logger log = LogManager.getLogger(ModelMetadata.class);
    private static final String DELIMITER = ",";
    private final KNNEngine knnEngine;
    private final SpaceType spaceType;
    private final int dimension;
    private AtomicReference<ModelState> state;
    private final String timestamp;
    private final String description;
    private final String trainingNodeAssignment;
    private String error;

    public ModelMetadata(StreamInput in) throws IOException {
        this.knnEngine = KNNEngine.getEngine(in.readString());
        this.spaceType = SpaceType.getSpace(in.readString());
        this.dimension = in.readInt();
        this.state = new AtomicReference<ModelState>(ModelState.readFrom(in));
        this.timestamp = in.readString();
        this.description = in.readString();
        this.error = in.readString();
        this.trainingNodeAssignment = IndexUtil.isVersionOnOrAfterMinRequiredVersion(in.getVersion(), "training_node_assignment") ? in.readString() : "";
    }

    public ModelMetadata(KNNEngine knnEngine, SpaceType spaceType, int dimension, ModelState modelState, String timestamp, String description, String error, String trainingNodeAssignment) {
        this.knnEngine = Objects.requireNonNull(knnEngine, "knnEngine must not be null");
        this.spaceType = Objects.requireNonNull(spaceType, "spaceType must not be null");
        int maxDimensions = KNNEngine.getMaxDimensionByEngine(this.knnEngine);
        if (dimension <= 0 || dimension > maxDimensions) {
            throw new IllegalArgumentException(String.format("Dimension \"%s\" is invalid. Value must be greater than 0 and less than or equal to %d", dimension, maxDimensions));
        }
        this.dimension = dimension;
        this.state = new AtomicReference<ModelState>(Objects.requireNonNull(modelState, "modelState must not be null"));
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp must not be null");
        this.description = Objects.requireNonNull(description, "description must not be null");
        this.error = Objects.requireNonNull(error, "error must not be null");
        this.trainingNodeAssignment = Objects.requireNonNull(trainingNodeAssignment, "node assignment must not be null");
    }

    public KNNEngine getKnnEngine() {
        return this.knnEngine;
    }

    public SpaceType getSpaceType() {
        return this.spaceType;
    }

    public int getDimension() {
        return this.dimension;
    }

    public ModelState getState() {
        return this.state.get();
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getError() {
        return this.error;
    }

    public String getNodeAssignment() {
        return this.trainingNodeAssignment;
    }

    public synchronized void setState(ModelState state) {
        this.state.set(Objects.requireNonNull(state, "state must not be null"));
    }

    public synchronized void setError(String error) {
        this.error = error;
    }

    public String toString() {
        return String.join((CharSequence)DELIMITER, this.knnEngine.getName(), this.spaceType.getValue(), Integer.toString(this.dimension), this.getState().toString(), this.timestamp, this.description, this.error, this.trainingNodeAssignment);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ModelMetadata other = (ModelMetadata)obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.getKnnEngine(), (Object)other.getKnnEngine());
        equalsBuilder.append((Object)this.getSpaceType(), (Object)other.getSpaceType());
        equalsBuilder.append(this.getDimension(), other.getDimension());
        equalsBuilder.append((Object)this.getState(), (Object)other.getState());
        equalsBuilder.append((Object)this.getTimestamp(), (Object)other.getTimestamp());
        equalsBuilder.append((Object)this.getDescription(), (Object)other.getDescription());
        equalsBuilder.append((Object)this.getError(), (Object)other.getError());
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getKnnEngine()).append((Object)this.getSpaceType()).append(this.getDimension()).append((Object)this.getState()).append((Object)this.getTimestamp()).append((Object)this.getDescription()).append((Object)this.getError()).toHashCode();
    }

    public static ModelMetadata fromString(String modelMetadataString) {
        String[] modelMetadataArray = modelMetadataString.split(DELIMITER, -1);
        if (modelMetadataArray.length == 7) {
            log.debug("Model metadata array does not contain training node assignment. Assuming empty string.");
            KNNEngine knnEngine = KNNEngine.getEngine(modelMetadataArray[0]);
            SpaceType spaceType = SpaceType.getSpace(modelMetadataArray[1]);
            int dimension = Integer.parseInt(modelMetadataArray[2]);
            ModelState modelState = ModelState.getModelState(modelMetadataArray[3]);
            String timestamp = modelMetadataArray[4];
            String description = modelMetadataArray[5];
            String error = modelMetadataArray[6];
            return new ModelMetadata(knnEngine, spaceType, dimension, modelState, timestamp, description, error, "");
        }
        if (modelMetadataArray.length == 8) {
            log.debug("Model metadata contains training node assignment");
            KNNEngine knnEngine = KNNEngine.getEngine(modelMetadataArray[0]);
            SpaceType spaceType = SpaceType.getSpace(modelMetadataArray[1]);
            int dimension = Integer.parseInt(modelMetadataArray[2]);
            ModelState modelState = ModelState.getModelState(modelMetadataArray[3]);
            String timestamp = modelMetadataArray[4];
            String description = modelMetadataArray[5];
            String error = modelMetadataArray[6];
            String trainingNodeAssignment = modelMetadataArray[7];
            return new ModelMetadata(knnEngine, spaceType, dimension, modelState, timestamp, description, error, trainingNodeAssignment);
        }
        throw new IllegalArgumentException("Illegal format for model metadata. Must be of the form \"<KNNEngine>,<SpaceType>,<Dimension>,<ModelState>,<Timestamp>,<Description>,<Error>\" or \"<KNNEngine>,<SpaceType>,<Dimension>,<ModelState>,<Timestamp>,<Description>,<Error>,<NodeAssignment>\".");
    }

    private static String objectToString(Object value) {
        if (value == null) {
            return null;
        }
        return (String)value;
    }

    private static Integer objectToInteger(Object value) {
        if (value == null) {
            return null;
        }
        return (Integer)value;
    }

    public static ModelMetadata getMetadataFromSourceMap(Map<String, Object> modelSourceMap) {
        Object engine = modelSourceMap.get("engine");
        Object space = modelSourceMap.get("space_type");
        Object dimension = modelSourceMap.get("dimension");
        Object state = modelSourceMap.get("state");
        Object timestamp = modelSourceMap.get("timestamp");
        Object description = modelSourceMap.get("description");
        Object error = modelSourceMap.get("error");
        Object trainingNodeAssignment = modelSourceMap.get("training_node_assignment");
        if (trainingNodeAssignment == null) {
            trainingNodeAssignment = "";
        }
        ModelMetadata modelMetadata = new ModelMetadata(KNNEngine.getEngine(ModelMetadata.objectToString(engine)), SpaceType.getSpace(ModelMetadata.objectToString(space)), ModelMetadata.objectToInteger(dimension), ModelState.getModelState(ModelMetadata.objectToString(state)), ModelMetadata.objectToString(timestamp), ModelMetadata.objectToString(description), ModelMetadata.objectToString(error), ModelMetadata.objectToString(trainingNodeAssignment));
        return modelMetadata;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.getKnnEngine().getName());
        out.writeString(this.getSpaceType().getValue());
        out.writeInt(this.getDimension());
        this.getState().writeTo(out);
        out.writeString(this.getTimestamp());
        out.writeString(this.getDescription());
        out.writeString(this.getError());
        if (IndexUtil.isVersionOnOrAfterMinRequiredVersion(out.getVersion(), "training_node_assignment")) {
            out.writeString(this.getNodeAssignment());
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("state", this.getState().getName());
        builder.field("timestamp", this.getTimestamp());
        builder.field("description", this.getDescription());
        builder.field("error", this.getError());
        builder.field("space_type", this.getSpaceType().getValue());
        builder.field("dimension", this.getDimension());
        builder.field("engine", this.getKnnEngine().getName());
        if (IndexUtil.isClusterOnOrAfterMinRequiredVersion("training_node_assignment")) {
            builder.field("training_node_assignment", this.getNodeAssignment());
        }
        return builder;
    }
}

