/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.filtered;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BitSet;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.query.filtered.FilteredIdsKNNIterator;

public class NestedFilteredIdsKNNIterator
extends FilteredIdsKNNIterator {
    private final BitSet parentBitSet;

    public NestedFilteredIdsKNNIterator(int[] filterIdsArray, float[] queryVector, BinaryDocValues values, SpaceType spaceType, BitSet parentBitSet) {
        super(filterIdsArray, queryVector, values, spaceType);
        this.parentBitSet = parentBitSet;
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.currentPos >= this.filterIdsArray.length) {
            return Integer.MAX_VALUE;
        }
        this.currentScore = Float.NEGATIVE_INFINITY;
        int currentParent = this.parentBitSet.nextSetBit(this.filterIdsArray[this.currentPos]);
        int bestChild = -1;
        while (this.currentPos < this.filterIdsArray.length && this.filterIdsArray[this.currentPos] < currentParent) {
            this.binaryDocValues.advance(this.filterIdsArray[this.currentPos]);
            float score = this.computeScore();
            if (score > this.currentScore) {
                bestChild = this.filterIdsArray[this.currentPos];
                this.currentScore = score;
            }
            ++this.currentPos;
        }
        return bestChild;
    }
}

