/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.filtered;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.codec.util.KNNVectorSerializer;
import org.opensearch.knn.index.codec.util.KNNVectorSerializerFactory;

public class FilteredIdsKNNIterator {
    protected final int[] filterIdsArray;
    protected final float[] queryVector;
    protected final BinaryDocValues binaryDocValues;
    protected final SpaceType spaceType;
    protected float currentScore = Float.NEGATIVE_INFINITY;
    protected int currentPos = 0;

    public FilteredIdsKNNIterator(int[] filterIdsArray, float[] queryVector, BinaryDocValues binaryDocValues, SpaceType spaceType) {
        this.filterIdsArray = filterIdsArray;
        this.queryVector = queryVector;
        this.binaryDocValues = binaryDocValues;
        this.spaceType = spaceType;
    }

    public int nextDoc() throws IOException {
        if (this.currentPos >= this.filterIdsArray.length) {
            return Integer.MAX_VALUE;
        }
        int docId = this.binaryDocValues.advance(this.filterIdsArray[this.currentPos]);
        this.currentScore = this.computeScore();
        ++this.currentPos;
        return docId;
    }

    public float score() {
        return this.currentScore;
    }

    protected float computeScore() throws IOException {
        BytesRef value = this.binaryDocValues.binaryValue();
        ByteArrayInputStream byteStream = new ByteArrayInputStream(value.bytes, value.offset, value.length);
        KNNVectorSerializer vectorSerializer = KNNVectorSerializerFactory.getSerializerByStreamContent(byteStream);
        float[] vector = vectorSerializer.byteToFloatArray(byteStream);
        return this.spaceType.getVectorSimilarityFunction().compare(this.queryVector, vector);
    }
}

