/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.mapper.MapperParsingException;

public class MethodComponentContext
implements ToXContentFragment,
Writeable {
    private final String name;
    private final Map<String, Object> parameters;
    private Version indexVersion;

    public MethodComponentContext(StreamInput in) throws IOException {
        this.name = in.readString();
        this.parameters = in.available() > 0 ? in.readMap(StreamInput::readString, (Writeable.Reader)new ParameterMapValueReader()) : null;
    }

    public static MethodComponentContext parse(Object in) {
        if (!(in instanceof Map)) {
            throw new MapperParsingException("Unable to parse MethodComponent");
        }
        Map methodMap = (Map)in;
        String name = "";
        Map<String, Object> parameters = new HashMap<String, Object>();
        for (Map.Entry methodEntry : methodMap.entrySet()) {
            String key = (String)methodEntry.getKey();
            Object value = methodEntry.getValue();
            if ("name".equals(key)) {
                if (!(value instanceof String)) {
                    throw new MapperParsingException("Component name should be a string");
                }
                name = (String)value;
                continue;
            }
            if ("parameters".equals(key)) {
                if (value == null) {
                    parameters = null;
                    continue;
                }
                if (!(value instanceof Map)) {
                    throw new MapperParsingException("Unable to parse parameters for  method component");
                }
                Map<String, Object> parameters1 = ((Map)value).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
                    Object v = e.getValue();
                    if (v instanceof Map) {
                        return MethodComponentContext.parse(v);
                    }
                    return v;
                }));
                parameters = parameters1;
                continue;
            }
            throw new MapperParsingException("Invalid parameter for MethodComponentContext: " + key);
        }
        if (name.isEmpty()) {
            throw new MapperParsingException("name needs to be set");
        }
        return new MethodComponentContext(name, parameters);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("name", this.name);
        if (this.parameters == null) {
            builder.field("parameters", (String)null);
        } else {
            builder.startObject("parameters");
            this.parameters.forEach((key, value) -> {
                try {
                    if (value instanceof MethodComponentContext) {
                        builder.startObject(key);
                        ((MethodComponentContext)value).toXContent(builder, params);
                        builder.endObject();
                    } else {
                        builder.field(key, value);
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Unable to generate xcontent for method component");
                }
            });
            builder.endObject();
        }
        return builder;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MethodComponentContext other = (MethodComponentContext)obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.name, (Object)other.name);
        equalsBuilder.append(this.parameters, other.parameters);
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).append(this.parameters).toHashCode();
    }

    public Map<String, Object> getParameters() {
        if (this.parameters == null) {
            return Collections.emptyMap();
        }
        return this.parameters;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        if (this.parameters != null) {
            out.writeMap(this.parameters, StreamOutput::writeString, (Writeable.Writer)new ParameterMapValueWriter());
        }
    }

    @Generated
    public MethodComponentContext(String name, Map<String, Object> parameters) {
        this.name = name;
        this.parameters = parameters;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Version getIndexVersion() {
        return this.indexVersion;
    }

    @Generated
    public void setIndexVersion(Version indexVersion) {
        this.indexVersion = indexVersion;
    }

    private static class ParameterMapValueReader
    implements Writeable.Reader<Object> {
        private ParameterMapValueReader() {
        }

        public Object read(StreamInput in) throws IOException {
            boolean isValueMethodComponentContext = in.readBoolean();
            if (isValueMethodComponentContext) {
                return new MethodComponentContext(in);
            }
            return in.readGenericValue();
        }
    }

    private static class ParameterMapValueWriter
    implements Writeable.Writer<Object> {
        private ParameterMapValueWriter() {
        }

        public void write(StreamOutput out, Object o) throws IOException {
            if (o instanceof MethodComponentContext) {
                out.writeBoolean(true);
                ((MethodComponentContext)o).writeTo(out);
            } else {
                out.writeBoolean(false);
                out.writeGenericValue(o);
            }
        }
    }
}

