/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.opensearch.Version;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.ValidationException;
import org.opensearch.knn.common.KNNConstants;
import org.opensearch.knn.index.KNNClusterUtil;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.util.KNNEngine;
import org.opensearch.knn.indices.ModelDao;
import org.opensearch.knn.indices.ModelMetadata;

public class IndexUtil {
    public static final String MODEL_NODE_ASSIGNMENT_KEY = "training_node_assignment";
    private static final Version MINIMAL_SUPPORTED_VERSION_FOR_LUCENE_HNSW_FILTER = Version.V_2_4_0;
    private static final Version MINIMAL_SUPPORTED_VERSION_FOR_IGNORE_UNMAPPED = Version.V_2_11_0;
    private static final Version MINIMAL_SUPPORTED_VERSION_FOR_MODEL_NODE_ASSIGNMENT = Version.V_2_12_0;
    public static final Map<String, Version> minimalRequiredVersionMap = new HashMap<String, Version>(){
        {
            this.put("filter", MINIMAL_SUPPORTED_VERSION_FOR_LUCENE_HNSW_FILTER);
            this.put("ignore_unmapped", MINIMAL_SUPPORTED_VERSION_FOR_IGNORE_UNMAPPED);
            this.put(IndexUtil.MODEL_NODE_ASSIGNMENT_KEY, MINIMAL_SUPPORTED_VERSION_FOR_MODEL_NODE_ASSIGNMENT);
        }
    };

    public static int getFileSizeInKB(String filePath) {
        if (filePath == null || filePath.isEmpty()) {
            return 0;
        }
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            return 0;
        }
        return Math.toIntExact(file.length() / (long)KNNConstants.BYTES_PER_KILOBYTES.intValue() + 1L);
    }

    private static Object getFieldMapping(Map<String, Object> properties, String fieldPath) {
        String[] fieldPaths = fieldPath.split("\\.");
        Object currentFieldMapping = properties;
        for (String path : fieldPaths) {
            Object possibleProperties;
            if ((currentFieldMapping = currentFieldMapping.get(path)) == null) {
                return null;
            }
            if (!(currentFieldMapping instanceof Map) || !((possibleProperties = ((Map)currentFieldMapping).get("properties")) instanceof Map)) continue;
            currentFieldMapping = possibleProperties;
        }
        return currentFieldMapping;
    }

    public static ValidationException validateKnnField(IndexMetadata indexMetadata, String field, int expectedDimension, ModelDao modelDao) {
        if (indexMetadata == null) {
            throw new IllegalArgumentException("IndexMetadata should not be null");
        }
        ValidationException exception = new ValidationException();
        MappingMetadata mappingMetadata = indexMetadata.mapping();
        if (mappingMetadata == null) {
            exception.addValidationError("Invalid index. Index does not contain a mapping");
            return exception;
        }
        Map properties = (Map)mappingMetadata.getSourceAsMap().get("properties");
        if (properties == null) {
            exception.addValidationError("Properties in map does not exists. This is unexpected");
            return exception;
        }
        if (StringUtils.isEmpty((String)field)) {
            exception.addValidationError(String.format(Locale.ROOT, "Field path is empty.", new Object[0]));
            return exception;
        }
        Object fieldMapping = IndexUtil.getFieldMapping(properties, field);
        if (fieldMapping == null) {
            exception.addValidationError(String.format("Field \"%s\" does not exist.", field));
            return exception;
        }
        if (!(fieldMapping instanceof Map)) {
            exception.addValidationError(String.format("Field info for \"%s\" is not a map.", field));
            return exception;
        }
        Map fieldMap = (Map)fieldMapping;
        Object type = fieldMap.get("type");
        if (!(type instanceof String) || !"knn_vector".equals(type)) {
            exception.addValidationError(String.format("Field \"%s\" is not of type %s.", field, "knn_vector"));
            return exception;
        }
        if (expectedDimension < 0) {
            return null;
        }
        Object dimension = fieldMap.get("dimension");
        if (dimension == null) {
            String modelId = (String)fieldMap.get("model_id");
            if (modelId == null) {
                exception.addValidationError(String.format("Field \"%s\" does not have a dimension set.", field));
                return exception;
            }
            if (modelDao == null) {
                throw new IllegalArgumentException(String.format("Field \"%s\" uses model. modelDao cannot be null.", field));
            }
            ModelMetadata modelMetadata = modelDao.getMetadata(modelId);
            if (modelMetadata == null) {
                exception.addValidationError(String.format("Model \"%s\" for field \"%s\" does not exist.", modelId, field));
                return exception;
            }
            dimension = modelMetadata.getDimension();
            if ((Integer)dimension != expectedDimension) {
                exception.addValidationError(String.format("Field \"%s\" has dimension %d, which is different from dimension specified in the training request: %d", field, dimension, expectedDimension));
                return exception;
            }
            return null;
        }
        if ((Integer)dimension != expectedDimension) {
            exception.addValidationError(String.format("Field \"%s\" has dimension %d, which is different from dimension specified in the training request: %d", field, dimension, expectedDimension));
            return exception;
        }
        return null;
    }

    public static Map<String, Object> getParametersAtLoading(SpaceType spaceType, KNNEngine knnEngine, String indexName) {
        HashMap loadParameters = Maps.newHashMap((Map)ImmutableMap.of((Object)"spaceType", (Object)spaceType.getValue()));
        if (KNNEngine.NMSLIB.equals(knnEngine)) {
            loadParameters.put("efSearch", KNNSettings.getEfSearchParam(indexName));
        }
        return Collections.unmodifiableMap(loadParameters);
    }

    public static boolean isClusterOnOrAfterMinRequiredVersion(String key) {
        Version minimalRequiredVersion = minimalRequiredVersionMap.get(key);
        if (minimalRequiredVersion == null) {
            return false;
        }
        return KNNClusterUtil.instance().getClusterMinVersion().onOrAfter(minimalRequiredVersion);
    }

    public static boolean isVersionOnOrAfterMinRequiredVersion(Version version, String key) {
        Version minimalRequiredVersion = minimalRequiredVersionMap.get(key);
        if (minimalRequiredVersion == null) {
            return false;
        }
        return version.onOrAfter(minimalRequiredVersion);
    }
}

