/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.transport;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.ValidationException;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.knn.common.KNNConstants;
import org.opensearch.knn.index.IndexUtil;
import org.opensearch.knn.index.KNNMethodContext;
import org.opensearch.knn.indices.ModelDao;

public class TrainingModelRequest
extends ActionRequest {
    private static ClusterService clusterService;
    private static ModelDao modelDao;
    private final String modelId;
    private final KNNMethodContext knnMethodContext;
    private final int dimension;
    private final String trainingIndex;
    private final String trainingField;
    private final String preferredNodeId;
    private final String description;
    private int maximumVectorCount;
    private int searchSize;
    private int trainingDataSizeInKB;

    public TrainingModelRequest(String modelId, KNNMethodContext knnMethodContext, int dimension, String trainingIndex, String trainingField, String preferredNodeId, String description) {
        this.modelId = modelId;
        this.knnMethodContext = knnMethodContext;
        this.dimension = dimension;
        this.trainingIndex = trainingIndex;
        this.trainingField = trainingField;
        this.preferredNodeId = preferredNodeId;
        this.description = description;
        this.maximumVectorCount = Integer.MAX_VALUE;
        this.searchSize = 10000;
        this.trainingDataSizeInKB = -1;
    }

    public TrainingModelRequest(StreamInput in) throws IOException {
        super(in);
        this.modelId = in.readOptionalString();
        this.knnMethodContext = new KNNMethodContext(in);
        this.trainingIndex = in.readString();
        this.trainingField = in.readString();
        this.preferredNodeId = in.readOptionalString();
        this.dimension = in.readInt();
        this.description = in.readOptionalString();
        this.maximumVectorCount = in.readInt();
        this.searchSize = in.readInt();
        this.trainingDataSizeInKB = in.readInt();
    }

    public static void initialize(ModelDao modelDao, ClusterService clusterService) {
        TrainingModelRequest.modelDao = modelDao;
        TrainingModelRequest.clusterService = clusterService;
    }

    public String getModelId() {
        return this.modelId;
    }

    public KNNMethodContext getKnnMethodContext() {
        return this.knnMethodContext;
    }

    public int getDimension() {
        return this.dimension;
    }

    public String getTrainingIndex() {
        return this.trainingIndex;
    }

    public String getTrainingField() {
        return this.trainingField;
    }

    public String getPreferredNodeId() {
        return this.preferredNodeId;
    }

    public String getDescription() {
        return this.description;
    }

    public int getMaximumVectorCount() {
        return this.maximumVectorCount;
    }

    public void setMaximumVectorCount(int maximumVectorCount) {
        if (maximumVectorCount <= 0) {
            throw new IllegalArgumentException(String.format("Maximum vector count %d is invalid. Maximum vector count must be greater than 0", maximumVectorCount));
        }
        this.maximumVectorCount = maximumVectorCount;
    }

    public int getSearchSize() {
        return this.searchSize;
    }

    public void setSearchSize(int searchSize) {
        if (searchSize <= 0 || searchSize > 10000) {
            throw new IllegalArgumentException(String.format("Search size %d is invalid. Search size must be between 0 and 10,000", searchSize));
        }
        this.searchSize = searchSize;
    }

    public int getTrainingDataSizeInKB() {
        return this.trainingDataSizeInKB;
    }

    void setTrainingDataSizeInKB(int trainingDataSizeInKB) {
        if (trainingDataSizeInKB <= 0) {
            throw new IllegalArgumentException(String.format("Training data size %d is invalid. Training data size must be greater than 0", trainingDataSizeInKB));
        }
        this.trainingDataSizeInKB = trainingDataSizeInKB;
    }

    public ActionRequestValidationException validate() {
        IndexMetadata indexMetadata;
        ActionRequestValidationException exception = null;
        if (modelDao.getMetadata(this.modelId) != null) {
            exception = new ActionRequestValidationException();
            exception.addValidationError("Model with id=\"" + this.modelId + "\" already exists");
            return exception;
        }
        ValidationException validationException = this.knnMethodContext.validate();
        if (validationException != null) {
            exception = new ActionRequestValidationException();
            exception.addValidationErrors((Iterable)validationException.validationErrors());
        }
        if (!this.knnMethodContext.isTrainingRequired()) {
            exception = exception == null ? new ActionRequestValidationException() : exception;
            exception.addValidationError("Method does not require training.");
        }
        if (this.preferredNodeId != null && !clusterService.state().nodes().getDataNodes().containsKey((Object)this.preferredNodeId)) {
            exception = exception == null ? new ActionRequestValidationException() : exception;
            exception.addValidationError("Preferred node \"" + this.preferredNodeId + "\" does not exist");
        }
        if (this.description != null && this.description.length() > KNNConstants.MAX_MODEL_DESCRIPTION_LENGTH) {
            exception = exception == null ? new ActionRequestValidationException() : exception;
            exception.addValidationError("Description exceeds limit of " + KNNConstants.MAX_MODEL_DESCRIPTION_LENGTH + " characters");
        }
        if ((indexMetadata = clusterService.state().metadata().index(this.trainingIndex)) == null) {
            exception = exception == null ? new ActionRequestValidationException() : exception;
            exception.addValidationError("Index \"" + this.trainingIndex + "\" does not exist.");
            return exception;
        }
        ValidationException fieldValidation = IndexUtil.validateKnnField(indexMetadata, this.trainingField, this.dimension, modelDao);
        if (fieldValidation != null) {
            exception = exception == null ? new ActionRequestValidationException() : exception;
            exception.addValidationErrors((Iterable)fieldValidation.validationErrors());
        }
        return exception;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.modelId);
        this.knnMethodContext.writeTo(out);
        out.writeString(this.trainingIndex);
        out.writeString(this.trainingField);
        out.writeOptionalString(this.preferredNodeId);
        out.writeInt(this.dimension);
        out.writeOptionalString(this.description);
        out.writeInt(this.maximumVectorCount);
        out.writeInt(this.searchSize);
        out.writeInt(this.trainingDataSizeInKB);
    }
}

