/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.indices;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.delete.DeleteAction;
import org.opensearch.action.delete.DeleteRequestBuilder;
import org.opensearch.action.get.GetAction;
import org.opensearch.action.get.GetRequestBuilder;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequestBuilder;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.cluster.health.ClusterIndexHealth;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.indices.Model;
import org.opensearch.knn.indices.ModelMetadata;
import org.opensearch.knn.indices.ModelState;
import org.opensearch.knn.plugin.transport.DeleteModelResponse;
import org.opensearch.knn.plugin.transport.GetModelResponse;
import org.opensearch.knn.plugin.transport.RemoveModelFromCacheAction;
import org.opensearch.knn.plugin.transport.RemoveModelFromCacheRequest;
import org.opensearch.knn.plugin.transport.RemoveModelFromCacheResponse;
import org.opensearch.knn.plugin.transport.UpdateModelMetadataAction;
import org.opensearch.knn.plugin.transport.UpdateModelMetadataRequest;

public interface ModelDao {
    public void create(ActionListener<CreateIndexResponse> var1) throws IOException;

    public boolean isCreated();

    public ClusterHealthStatus getHealthStatus();

    public void put(Model var1, ActionListener<IndexResponse> var2) throws IOException;

    public void update(Model var1, ActionListener<IndexResponse> var2) throws IOException;

    public Model get(String var1) throws ExecutionException, InterruptedException;

    public void get(String var1, ActionListener<GetModelResponse> var2) throws IOException;

    public void search(SearchRequest var1, ActionListener<SearchResponse> var2) throws IOException;

    public ModelMetadata getMetadata(String var1);

    public void delete(String var1, ActionListener<DeleteModelResponse> var2);

    public static final class OpenSearchKNNModelDao
    implements ModelDao {
        public static Logger logger = LogManager.getLogger(ModelDao.class);
        private int numberOfShards = (Integer)KNNSettings.MODEL_INDEX_NUMBER_OF_SHARDS_SETTING.get(settings);
        private int numberOfReplicas = (Integer)KNNSettings.MODEL_INDEX_NUMBER_OF_REPLICAS_SETTING.get(settings);
        private static OpenSearchKNNModelDao INSTANCE;
        private static Client client;
        private static ClusterService clusterService;
        private static Settings settings;

        public static synchronized OpenSearchKNNModelDao getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new OpenSearchKNNModelDao();
            }
            return INSTANCE;
        }

        public static void initialize(Client client, ClusterService clusterService, Settings settings) {
            OpenSearchKNNModelDao.client = client;
            OpenSearchKNNModelDao.clusterService = clusterService;
            OpenSearchKNNModelDao.settings = settings;
        }

        private OpenSearchKNNModelDao() {
            clusterService.getClusterSettings().addSettingsUpdateConsumer(KNNSettings.MODEL_INDEX_NUMBER_OF_SHARDS_SETTING, it -> {
                this.numberOfShards = it;
            });
            clusterService.getClusterSettings().addSettingsUpdateConsumer(KNNSettings.MODEL_INDEX_NUMBER_OF_REPLICAS_SETTING, it -> {
                this.numberOfReplicas = it;
            });
        }

        @Override
        public void create(ActionListener<CreateIndexResponse> actionListener) throws IOException {
            if (this.isCreated()) {
                return;
            }
            CreateIndexRequest request = new CreateIndexRequest(".opensearch-knn-models").mapping(this.getMapping()).settings(Settings.builder().put("index.hidden", true).put("index.number_of_shards", this.numberOfShards).put("index.number_of_replicas", this.numberOfReplicas));
            client.admin().indices().create(request, actionListener);
        }

        @Override
        public boolean isCreated() {
            return clusterService.state().getRoutingTable().hasIndex(".opensearch-knn-models");
        }

        @Override
        public ClusterHealthStatus getHealthStatus() throws IndexNotFoundException {
            if (!this.isCreated()) {
                throw new IndexNotFoundException(".opensearch-knn-models");
            }
            ClusterIndexHealth indexHealth = new ClusterIndexHealth(clusterService.state().metadata().index(".opensearch-knn-models"), clusterService.state().getRoutingTable().index(".opensearch-knn-models"));
            return indexHealth.getStatus();
        }

        @Override
        public void put(Model model, ActionListener<IndexResponse> listener) throws IOException {
            this.putInternal(model, listener, DocWriteRequest.OpType.CREATE);
        }

        @Override
        public void update(Model model, ActionListener<IndexResponse> listener) throws IOException {
            this.putInternal(model, listener, DocWriteRequest.OpType.INDEX);
        }

        private void putInternal(final Model model, ActionListener<IndexResponse> listener, DocWriteRequest.OpType requestOpType) throws IOException {
            if (model == null) {
                throw new IllegalArgumentException("Model cannot be null");
            }
            final ModelMetadata modelMetadata = model.getModelMetadata();
            HashMap<String, Object> parameters = new HashMap<String, Object>(){
                {
                    this.put("model_id", model.getModelID());
                    this.put("engine", modelMetadata.getKnnEngine().getName());
                    this.put("space_type", modelMetadata.getSpaceType().getValue());
                    this.put("dimension", modelMetadata.getDimension());
                    this.put("state", modelMetadata.getState().getName());
                    this.put("timestamp", modelMetadata.getTimestamp());
                    this.put("description", modelMetadata.getDescription());
                    this.put("error", modelMetadata.getError());
                }
            };
            byte[] modelBlob = model.getModelBlob();
            if (modelBlob == null && ModelState.CREATED.equals((Object)modelMetadata.getState())) {
                throw new IllegalArgumentException("Model binary cannot be null when model state is CREATED");
            }
            if (modelBlob != null) {
                String base64Model = Base64.getEncoder().encodeToString(modelBlob);
                parameters.put("model_blob", base64Model);
            }
            IndexRequestBuilder indexRequestBuilder = client.prepareIndex(".opensearch-knn-models");
            indexRequestBuilder.setId(model.getModelID());
            indexRequestBuilder.setSource((Map)parameters);
            indexRequestBuilder.setOpType(requestOpType);
            indexRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            ActionListener<IndexResponse> onMetaListener = ActionListener.wrap(indexResponse -> client.execute((ActionType)RemoveModelFromCacheAction.INSTANCE, (ActionRequest)new RemoveModelFromCacheRequest(model.getModelID(), new String[0]), ActionListener.wrap(removeModelFromCacheResponse -> {
                if (!removeModelFromCacheResponse.hasFailures()) {
                    listener.onResponse(indexResponse);
                    return;
                }
                String failureMessage = this.buildRemoveModelErrorMessage(model.getModelID(), (RemoveModelFromCacheResponse)((Object)((Object)removeModelFromCacheResponse)));
                listener.onFailure((Exception)new RuntimeException(failureMessage));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0));
            ActionListener<IndexResponse> onIndexListener = ModelState.CREATED.equals((Object)model.getModelMetadata().getState()) ? this.getUpdateModelMetadataListener(model.getModelMetadata(), onMetaListener) : onMetaListener;
            if (!this.isCreated()) {
                this.create((ActionListener<CreateIndexResponse>)ActionListener.wrap(createIndexResponse -> indexRequestBuilder.execute(onIndexListener), arg_0 -> onIndexListener.onFailure(arg_0)));
                return;
            }
            indexRequestBuilder.execute(onIndexListener);
        }

        private ActionListener<IndexResponse> getUpdateModelMetadataListener(ModelMetadata modelMetadata, ActionListener<IndexResponse> listener) {
            return ActionListener.wrap(indexResponse -> client.execute((ActionType)UpdateModelMetadataAction.INSTANCE, (ActionRequest)new UpdateModelMetadataRequest(indexResponse.getId(), false, modelMetadata), ActionListener.wrap(acknowledgedResponse -> listener.onResponse(indexResponse), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0));
        }

        @Override
        public Model get(String modelId) throws ExecutionException, InterruptedException {
            GetRequestBuilder getRequestBuilder = new GetRequestBuilder((OpenSearchClient)client, GetAction.INSTANCE, ".opensearch-knn-models").setId(modelId).setPreference("_local");
            GetResponse getResponse = (GetResponse)getRequestBuilder.execute().get();
            Map responseMap = getResponse.getSourceAsMap();
            return Model.getModelFromSourceMap(responseMap);
        }

        @Override
        public void get(String modelId, ActionListener<GetModelResponse> actionListener) throws IOException {
            GetRequestBuilder getRequestBuilder = new GetRequestBuilder((OpenSearchClient)client, GetAction.INSTANCE, ".opensearch-knn-models").setId(modelId).setPreference("_local");
            getRequestBuilder.execute(ActionListener.wrap(response -> {
                if (response.isSourceEmpty()) {
                    String errorMessage = String.format("Model \" %s \" does not exist", modelId);
                    actionListener.onFailure((Exception)new ResourceNotFoundException(modelId, new Object[]{errorMessage}));
                    return;
                }
                Map responseMap = response.getSourceAsMap();
                Model model = Model.getModelFromSourceMap(responseMap);
                actionListener.onResponse((Object)new GetModelResponse(model));
            }, arg_0 -> actionListener.onFailure(arg_0)));
        }

        @Override
        public void search(SearchRequest request, ActionListener<SearchResponse> actionListener) {
            request.indices(new String[]{".opensearch-knn-models"});
            client.search(request, actionListener);
        }

        @Override
        public ModelMetadata getMetadata(String modelId) {
            IndexMetadata indexMetadata = clusterService.state().metadata().index(".opensearch-knn-models");
            if (indexMetadata == null) {
                logger.debug("ModelMetadata for model \"" + modelId + "\" is null. .opensearch-knn-models index does not exist.");
                return null;
            }
            Map models = indexMetadata.getCustomData("knn-models");
            if (models == null) {
                logger.debug("ModelMetadata for model \"" + modelId + "\" is null. .opensearch-knn-models's custom metadata does not exist.");
                return null;
            }
            String modelMetadata = (String)models.get(modelId);
            if (modelMetadata == null) {
                logger.debug("ModelMetadata for model \"" + modelId + "\" is null. Model \"" + modelId + "\" does not exist.");
                return null;
            }
            return ModelMetadata.fromString(modelMetadata);
        }

        private String getMapping() throws IOException {
            URL url = ModelDao.class.getClassLoader().getResource("mappings/model-index.json");
            if (url == null) {
                throw new IllegalStateException("Unable to retrieve mapping for \".opensearch-knn-models\"");
            }
            return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        }

        @Override
        public void delete(String modelId, ActionListener<DeleteModelResponse> listener) {
            if (!this.isCreated()) {
                logger.error("Cannot delete model \"" + modelId + "\". Model index .opensearch-knn-modelsdoes not exist.");
                String errorMessage = String.format("Cannot delete model \"%s\". Model index does not exist", modelId);
                listener.onResponse((Object)new DeleteModelResponse(modelId, "failed", errorMessage));
                return;
            }
            DeleteRequestBuilder deleteRequestBuilder = new DeleteRequestBuilder((OpenSearchClient)client, DeleteAction.INSTANCE, ".opensearch-knn-models");
            deleteRequestBuilder.setId(modelId);
            deleteRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            ActionListener onModelDeleteListener = ActionListener.wrap(deleteResponse -> {
                if (deleteResponse.getResult() != DocWriteResponse.Result.DELETED) {
                    String errorMessage = String.format("Model \" %s \" does not exist", modelId);
                    listener.onResponse((Object)new DeleteModelResponse(modelId, deleteResponse.getResult().getLowercase(), errorMessage));
                    return;
                }
                client.execute((ActionType)RemoveModelFromCacheAction.INSTANCE, (ActionRequest)new RemoveModelFromCacheRequest(modelId, new String[0]), ActionListener.wrap(removeModelFromCacheResponse -> {
                    if (!removeModelFromCacheResponse.hasFailures()) {
                        listener.onResponse((Object)new DeleteModelResponse(modelId, deleteResponse.getResult().getLowercase(), null));
                        return;
                    }
                    String failureMessage = this.buildRemoveModelErrorMessage(modelId, (RemoveModelFromCacheResponse)((Object)((Object)removeModelFromCacheResponse)));
                    listener.onResponse((Object)new DeleteModelResponse(modelId, "failed", failureMessage));
                }, e -> listener.onResponse((Object)new DeleteModelResponse(modelId, "failed", e.getMessage()))));
            }, e -> listener.onResponse((Object)new DeleteModelResponse(modelId, "failed", e.getMessage())));
            ActionListener onMetadataUpdateListener = ActionListener.wrap(acknowledgedResponse -> deleteRequestBuilder.execute(onModelDeleteListener), arg_0 -> listener.onFailure(arg_0));
            client.execute((ActionType)UpdateModelMetadataAction.INSTANCE, (ActionRequest)new UpdateModelMetadataRequest(modelId, true, null), onMetadataUpdateListener);
        }

        private String buildRemoveModelErrorMessage(String modelId, RemoveModelFromCacheResponse response) {
            String failureMessage = "Failed to remove \"" + modelId + "\" from nodes: ";
            StringBuilder stringBuilder = new StringBuilder(failureMessage);
            for (FailedNodeException nodeException : response.failures()) {
                stringBuilder.append("Node \"").append(nodeException.nodeId()).append("\" ").append(nodeException.getMessage()).append("; ");
            }
            return stringBuilder.toString();
        }
    }
}

