/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.util;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.opensearch.common.TriFunction;
import org.opensearch.common.ValidationException;
import org.opensearch.knn.common.KNNConstants;
import org.opensearch.knn.index.KNNMethod;
import org.opensearch.knn.index.KNNMethodContext;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.MethodComponent;
import org.opensearch.knn.index.MethodComponentContext;
import org.opensearch.knn.index.Parameter;
import org.opensearch.knn.index.SpaceType;

public interface KNNLibrary {
    public String getLatestBuildVersion();

    public String getLatestLibVersion();

    public String getExtension();

    public String getCompoundExtension();

    public KNNMethod getMethod(String var1);

    public float score(float var1, SpaceType var2);

    public ValidationException validateMethod(KNNMethodContext var1);

    public boolean isTrainingRequired(KNNMethodContext var1);

    public int estimateOverheadInKB(KNNMethodContext var1, int var2);

    public Map<String, Object> getMethodAsMap(KNNMethodContext var1);

    public Boolean isInitialized();

    public void setInitialized(Boolean var1);

    public static class Faiss
    extends NativeLibrary {
        public static final Map<SpaceType, Function<Float, Float>> SCORE_TRANSLATIONS = ImmutableMap.of((Object)((Object)SpaceType.INNER_PRODUCT), rawScore -> Float.valueOf(SpaceType.INNER_PRODUCT.scoreTranslation(-1.0f * rawScore.floatValue())));
        public static final MethodComponentContext ENCODER_DEFAULT = new MethodComponentContext("flat", Collections.emptyMap());
        public static final Map<String, MethodComponent> encoderComponents = ImmutableMap.of((Object)"flat", (Object)MethodComponent.Builder.builder("flat").setMapGenerator((methodComponent, methodComponentContext) -> MethodAsMapBuilder.builder("Flat", methodComponent, methodComponentContext).build()).build(), (Object)"pq", (Object)MethodComponent.Builder.builder("pq").addParameter("m", new Parameter.IntegerParameter("m", KNNConstants.ENCODER_PARAMETER_PQ_CODE_COUNT_DEFAULT, v -> v > 0 && v < KNNConstants.ENCODER_PARAMETER_PQ_CODE_COUNT_LIMIT)).addParameter("code_size", new Parameter.IntegerParameter("code_size", KNNConstants.ENCODER_PARAMETER_PQ_CODE_SIZE_DEFAULT, v -> v > 0 && v < KNNConstants.ENCODER_PARAMETER_PQ_CODE_SIZE_LIMIT)).setRequiresTraining(true).setMapGenerator((methodComponent, methodComponentContext) -> MethodAsMapBuilder.builder("PQ", methodComponent, methodComponentContext).addParameter("m", "", "").addParameter("code_size", "x", "").build()).setOverheadInKBEstimator((TriFunction<MethodComponent, MethodComponentContext, Integer, Long>)((TriFunction)(methodComponent, methodComponentContext, dimension) -> {
            Object codeSizeObject = methodComponentContext.getParameters().get("code_size");
            if (codeSizeObject == null) {
                Parameter<?> codeSizeParameter = methodComponent.getParameters().get("code_size");
                if (codeSizeParameter == null) {
                    throw new IllegalStateException("code_size is not a valid  parameter. This is a bug.");
                }
                codeSizeObject = codeSizeParameter.getDefaultValue();
            }
            if (!(codeSizeObject instanceof Integer)) {
                throw new IllegalStateException("code_size must be an integer.");
            }
            int codeSize = (Integer)codeSizeObject;
            return 4L * (long)(1 << codeSize) * (long)dimension.intValue() / (long)KNNConstants.BYTES_PER_KILOBYTES.intValue() + 1L;
        })).build());
        public static final Map<String, KNNMethod> METHODS = ImmutableMap.of((Object)"hnsw", (Object)KNNMethod.Builder.builder(MethodComponent.Builder.builder("hnsw").addParameter("m", new Parameter.IntegerParameter("m", KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_M, v -> v > 0)).addParameter("ef_construction", new Parameter.IntegerParameter("ef_construction", KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_EF_CONSTRUCTION, v -> v > 0)).addParameter("ef_search", new Parameter.IntegerParameter("ef_search", KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_EF_SEARCH, v -> v > 0)).addParameter("encoder", new Parameter.MethodComponentContextParameter("encoder", ENCODER_DEFAULT, encoderComponents)).setMapGenerator((methodComponent, methodComponentContext) -> MethodAsMapBuilder.builder("HNSW", methodComponent, methodComponentContext).addParameter("m", "", "").addParameter("encoder", ",", "").build()).build()).addSpaces(SpaceType.L2, SpaceType.INNER_PRODUCT).build(), (Object)"ivf", (Object)KNNMethod.Builder.builder(MethodComponent.Builder.builder("ivf").addParameter("nprobes", new Parameter.IntegerParameter("nprobes", KNNConstants.METHOD_PARAMETER_NPROBES_DEFAULT, v -> v > 0 && v < KNNConstants.METHOD_PARAMETER_NPROBES_LIMIT)).addParameter("nlist", new Parameter.IntegerParameter("nlist", KNNConstants.METHOD_PARAMETER_NLIST_DEFAULT, v -> v > 0 && v < KNNConstants.METHOD_PARAMETER_NLIST_LIMIT)).addParameter("encoder", new Parameter.MethodComponentContextParameter("encoder", ENCODER_DEFAULT, encoderComponents)).setRequiresTraining(true).setMapGenerator((methodComponent, methodComponentContext) -> MethodAsMapBuilder.builder("IVF", methodComponent, methodComponentContext).addParameter("nlist", "", "").addParameter("encoder", ",", "").build()).setOverheadInKBEstimator((TriFunction<MethodComponent, MethodComponentContext, Integer, Long>)((TriFunction)(methodComponent, methodComponentContext, dimension) -> {
            Object nlistObject = methodComponentContext.getParameters().get("nlist");
            if (nlistObject == null) {
                Parameter<?> nlistParameter = methodComponent.getParameters().get("nlist");
                if (nlistParameter == null) {
                    throw new IllegalStateException("nlist is not a valid  parameter. This is a bug.");
                }
                nlistObject = nlistParameter.getDefaultValue();
            }
            if (!(nlistObject instanceof Integer)) {
                throw new IllegalStateException("nlist must be an integer.");
            }
            int centroids = (Integer)nlistObject;
            return 4L * (long)centroids * (long)dimension.intValue() / (long)KNNConstants.BYTES_PER_KILOBYTES.intValue() + 1L;
        })).build()).addSpaces(SpaceType.L2, SpaceType.INNER_PRODUCT).build());
        public static final Faiss INSTANCE = new Faiss(METHODS, SCORE_TRANSLATIONS, Version.LATEST.getBuildVersion(), Version.LATEST.indexLibraryVersion(), ".faiss");

        private Faiss(Map<String, KNNMethod> methods, Map<SpaceType, Function<Float, Float>> scoreTranslation, String latestLibraryBuildVersion, String latestLibraryVersion, String extension) {
            super(methods, scoreTranslation, latestLibraryBuildVersion, latestLibraryVersion, extension);
        }

        protected static class MethodAsMapBuilder {
            String indexDescription;
            MethodComponent methodComponent;
            Map<String, Object> methodAsMap;

            MethodAsMapBuilder(String baseDescription, MethodComponent methodComponent, Map<String, Object> initialMap) {
                this.indexDescription = baseDescription;
                this.methodComponent = methodComponent;
                this.methodAsMap = initialMap;
            }

            MethodAsMapBuilder addParameter(String parameterName, String prefix, String suffix) {
                Object value;
                this.indexDescription = this.indexDescription + prefix;
                Map methodParameters = (Map)this.methodAsMap.get("parameters");
                Parameter<?> parameter = this.methodComponent.getParameters().get(parameterName);
                Object object = value = methodParameters.containsKey(parameterName) ? methodParameters.get(parameterName) : parameter.getDefaultValue();
                if (parameter instanceof Parameter.MethodComponentContextParameter) {
                    MethodComponentContext subMethodComponentContext = (MethodComponentContext)value;
                    MethodComponent subMethodComponent = ((Parameter.MethodComponentContextParameter)parameter).getMethodComponent(subMethodComponentContext.getName());
                    Map<String, Object> subMethodAsMap = subMethodComponent.getAsMap(subMethodComponentContext);
                    this.indexDescription = this.indexDescription + subMethodAsMap.get("index_description");
                    subMethodAsMap.remove("index_description");
                    methodParameters.put(parameterName, subMethodAsMap);
                } else {
                    this.indexDescription = this.indexDescription + value;
                    methodParameters.remove(parameterName);
                }
                this.indexDescription = this.indexDescription + suffix;
                return this;
            }

            Map<String, Object> build() {
                this.methodAsMap.put("index_description", this.indexDescription);
                return this.methodAsMap;
            }

            static MethodAsMapBuilder builder(String baseDescription, MethodComponent methodComponent, MethodComponentContext methodComponentContext) {
                HashMap<String, Object> initialMap = new HashMap<String, Object>();
                initialMap.put("name", methodComponent.getName());
                initialMap.put("parameters", MethodComponent.getParameterMapWithDefaultsAdded(methodComponentContext, methodComponent));
                return new MethodAsMapBuilder(baseDescription, methodComponent, initialMap);
            }
        }

        private static enum Version {
            V165("165"){

                @Override
                public String indexLibraryVersion() {
                    return "opensearchknn_faiss";
                }
            };

            static final Version LATEST;
            String buildVersion;

            private Version(String buildVersion) {
                this.buildVersion = buildVersion;
            }

            abstract String indexLibraryVersion();

            String getBuildVersion() {
                return this.buildVersion;
            }

            static {
                LATEST = V165;
            }
        }
    }

    public static class Nmslib
    extends NativeLibrary {
        public static final String HNSW_LIB_NAME = "hnsw";
        public static final String EXTENSION = ".hnsw";
        public static final Map<String, KNNMethod> METHODS = ImmutableMap.of((Object)"hnsw", (Object)KNNMethod.Builder.builder(MethodComponent.Builder.builder("hnsw").addParameter("m", new Parameter.IntegerParameter("m", KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_M, v -> v > 0)).addParameter("ef_construction", new Parameter.IntegerParameter("ef_construction", KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_EF_CONSTRUCTION, v -> v > 0)).build()).addSpaces(SpaceType.L2, SpaceType.L1, SpaceType.LINF, SpaceType.COSINESIMIL, SpaceType.INNER_PRODUCT).build());
        public static final Nmslib INSTANCE = new Nmslib(METHODS, Collections.emptyMap(), Version.LATEST.getBuildVersion(), Version.LATEST.indexLibraryVersion(), ".hnsw");

        private Nmslib(Map<String, KNNMethod> methods, Map<SpaceType, Function<Float, Float>> scoreTranslation, String latestLibraryBuildVersion, String latestLibraryVersion, String extension) {
            super(methods, scoreTranslation, latestLibraryBuildVersion, latestLibraryVersion, extension);
        }

        public static enum Version {
            V2011("2011"){

                @Override
                public String indexLibraryVersion() {
                    return "opensearchknn_nmslib";
                }
            };

            public static final Version LATEST;
            private String buildVersion;

            private Version(String buildVersion) {
                this.buildVersion = buildVersion;
            }

            public abstract String indexLibraryVersion();

            public String getBuildVersion() {
                return this.buildVersion;
            }

            static {
                LATEST = V2011;
            }
        }
    }

    public static abstract class NativeLibrary
    implements KNNLibrary {
        protected Map<String, KNNMethod> methods;
        private Map<SpaceType, Function<Float, Float>> scoreTranslation;
        private String latestLibraryBuildVersion;
        private String latestLibraryVersion;
        private String extension;
        private AtomicBoolean initialized;

        public NativeLibrary(Map<String, KNNMethod> methods, Map<SpaceType, Function<Float, Float>> scoreTranslation, String latestLibraryBuildVersion, String latestLibraryVersion, String extension) {
            this.methods = methods;
            this.scoreTranslation = scoreTranslation;
            this.latestLibraryBuildVersion = latestLibraryBuildVersion;
            this.latestLibraryVersion = latestLibraryVersion;
            this.extension = extension;
            this.initialized = new AtomicBoolean(false);
        }

        @Override
        public String getLatestBuildVersion() {
            return this.latestLibraryBuildVersion;
        }

        @Override
        public String getLatestLibVersion() {
            return this.latestLibraryVersion;
        }

        @Override
        public String getExtension() {
            return this.extension;
        }

        @Override
        public String getCompoundExtension() {
            return this.getExtension() + "c";
        }

        @Override
        public KNNMethod getMethod(String methodName) {
            KNNMethod method = this.methods.get(methodName);
            if (method != null) {
                return method;
            }
            throw new IllegalArgumentException("Invalid method name: " + methodName);
        }

        @Override
        public float score(float rawScore, SpaceType spaceType) {
            if (this.scoreTranslation.containsKey((Object)spaceType)) {
                return this.scoreTranslation.get((Object)spaceType).apply(Float.valueOf(rawScore)).floatValue();
            }
            return spaceType.scoreTranslation(rawScore);
        }

        @Override
        public ValidationException validateMethod(KNNMethodContext knnMethodContext) {
            String methodName = knnMethodContext.getMethodComponent().getName();
            return this.getMethod(methodName).validate(knnMethodContext);
        }

        @Override
        public boolean isTrainingRequired(KNNMethodContext knnMethodContext) {
            String methodName = knnMethodContext.getMethodComponent().getName();
            return this.getMethod(methodName).isTrainingRequired(knnMethodContext);
        }

        @Override
        public int estimateOverheadInKB(KNNMethodContext knnMethodContext, int dimension) {
            String methodName = knnMethodContext.getMethodComponent().getName();
            return this.getMethod(methodName).estimateOverheadInKB(knnMethodContext, dimension);
        }

        @Override
        public Map<String, Object> getMethodAsMap(KNNMethodContext knnMethodContext) {
            KNNMethod knnMethod = this.methods.get(knnMethodContext.getMethodComponent().getName());
            if (knnMethod == null) {
                throw new IllegalArgumentException("Invalid method name: " + knnMethodContext.getMethodComponent().getName());
            }
            return knnMethod.getAsMap(knnMethodContext);
        }

        @Override
        public Boolean isInitialized() {
            return this.initialized.get();
        }

        @Override
        public void setInitialized(Boolean isInitialized) {
            this.initialized.set(isInitialized);
        }
    }
}

