/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.util;

import java.util.Map;
import org.opensearch.common.ValidationException;
import org.opensearch.knn.index.KNNMethod;
import org.opensearch.knn.index.KNNMethodContext;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.util.KNNLibrary;

public enum KNNEngine implements KNNLibrary
{
    NMSLIB("nmslib", KNNLibrary.Nmslib.INSTANCE),
    FAISS("faiss", KNNLibrary.Faiss.INSTANCE);

    public static final KNNEngine DEFAULT;
    private String name;
    private KNNLibrary knnLibrary;

    private KNNEngine(String name, KNNLibrary knnLibrary) {
        this.name = name;
        this.knnLibrary = knnLibrary;
    }

    public static KNNEngine getEngine(String name) {
        if (NMSLIB.getName().equalsIgnoreCase(name)) {
            return NMSLIB;
        }
        if (FAISS.getName().equals(name)) {
            return FAISS;
        }
        throw new IllegalArgumentException("Invalid engine type: " + name);
    }

    public static KNNEngine getEngineNameFromPath(String path) {
        if (path.endsWith(NMSLIB.getExtension()) || path.endsWith(NMSLIB.getCompoundExtension())) {
            return NMSLIB;
        }
        if (path.endsWith(FAISS.getExtension()) || path.endsWith(FAISS.getCompoundExtension())) {
            return FAISS;
        }
        throw new IllegalArgumentException("No engine matches the path's suffix");
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getLatestBuildVersion() {
        return this.knnLibrary.getLatestBuildVersion();
    }

    @Override
    public String getLatestLibVersion() {
        return this.knnLibrary.getLatestLibVersion();
    }

    @Override
    public String getExtension() {
        return this.knnLibrary.getExtension();
    }

    @Override
    public String getCompoundExtension() {
        return this.knnLibrary.getCompoundExtension();
    }

    @Override
    public KNNMethod getMethod(String methodName) {
        return this.knnLibrary.getMethod(methodName);
    }

    @Override
    public float score(float rawScore, SpaceType spaceType) {
        return this.knnLibrary.score(rawScore, spaceType);
    }

    @Override
    public ValidationException validateMethod(KNNMethodContext knnMethodContext) {
        return this.knnLibrary.validateMethod(knnMethodContext);
    }

    @Override
    public boolean isTrainingRequired(KNNMethodContext knnMethodContext) {
        return this.knnLibrary.isTrainingRequired(knnMethodContext);
    }

    @Override
    public Map<String, Object> getMethodAsMap(KNNMethodContext knnMethodContext) {
        return this.knnLibrary.getMethodAsMap(knnMethodContext);
    }

    @Override
    public int estimateOverheadInKB(KNNMethodContext knnMethodContext, int dimension) {
        return this.knnLibrary.estimateOverheadInKB(knnMethodContext, dimension);
    }

    @Override
    public Boolean isInitialized() {
        return this.knnLibrary.isInitialized();
    }

    @Override
    public void setInitialized(Boolean isInitialized) {
        this.knnLibrary.setInitialized(isInitialized);
    }

    static {
        DEFAULT = NMSLIB;
    }
}

