/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.KNN80Codec;

import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.codec.KNN80Codec.KNN80DocValuesReader;
import org.opensearch.knn.index.codec.util.KNNCodecUtil;
import org.opensearch.knn.index.util.KNNEngine;
import org.opensearch.knn.indices.Model;
import org.opensearch.knn.indices.ModelCache;
import org.opensearch.knn.jni.JNIService;
import org.opensearch.knn.plugin.stats.KNNCounter;

class KNN80DocValuesConsumer
extends DocValuesConsumer
implements Closeable {
    private final Logger logger = LogManager.getLogger(KNN80DocValuesConsumer.class);
    private final DocValuesConsumer delegatee;
    private final SegmentWriteState state;
    private static final Long CRC32_CHECKSUM_SANITY = -4294967296L;

    KNN80DocValuesConsumer(DocValuesConsumer delegatee, SegmentWriteState state) {
        this.delegatee = delegatee;
        this.state = state;
    }

    public void addBinaryField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegatee.addBinaryField(field, valuesProducer);
        if (field.attributes().containsKey("knn_field")) {
            this.addKNNBinaryField(field, valuesProducer);
        }
    }

    public void addKNNBinaryField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        NativeIndexCreator indexCreator;
        String indexPath;
        String engineFileName;
        BinaryDocValues values = valuesProducer.getBinary(field);
        KNNCodecUtil.Pair pair = KNNCodecUtil.getFloats(values);
        if (pair.vectors.length == 0 || pair.docs.length == 0) {
            this.logger.info("Skipping engine index creation as there are no vectors or docs in the documents");
            return;
        }
        KNNCounter.GRAPH_INDEX_REQUESTS.increment();
        if (field.attributes().containsKey("model_id")) {
            String modelId = (String)field.attributes().get("model_id");
            Model model = ModelCache.getInstance().get(modelId);
            KNNEngine knnEngine = model.getModelMetadata().getKnnEngine();
            engineFileName = KNNCodecUtil.buildEngineFileName(this.state.segmentInfo.name, knnEngine.getLatestBuildVersion(), field.name, knnEngine.getExtension());
            indexPath = Paths.get(((FSDirectory)FilterDirectory.unwrap((Directory)this.state.directory)).getDirectory().toString(), engineFileName).toString();
            if (model.getModelBlob() == null) {
                throw new RuntimeException("There is no trained model with id \"" + modelId + "\"");
            }
            indexCreator = () -> this.createKNNIndexFromTemplate(model.getModelBlob(), pair, knnEngine, indexPath);
        } else {
            String engineName = field.attributes().getOrDefault("engine", KNNEngine.DEFAULT.getName());
            KNNEngine knnEngine = KNNEngine.getEngine(engineName);
            engineFileName = KNNCodecUtil.buildEngineFileName(this.state.segmentInfo.name, knnEngine.getLatestBuildVersion(), field.name, knnEngine.getExtension());
            indexPath = Paths.get(((FSDirectory)FilterDirectory.unwrap((Directory)this.state.directory)).getDirectory().toString(), engineFileName).toString();
            indexCreator = () -> this.createKNNIndexFromScratch(field, pair, knnEngine, indexPath);
        }
        this.state.directory.createOutput(engineFileName, this.state.context).close();
        indexCreator.createIndex();
        this.writeFooter(indexPath, engineFileName);
    }

    private void createKNNIndexFromTemplate(byte[] model, KNNCodecUtil.Pair pair, KNNEngine knnEngine, String indexPath) {
        ImmutableMap parameters = ImmutableMap.of((Object)"indexThreadQty", KNNSettings.state().getSettingValue("knn.algo_param.index_thread_qty"));
        AccessController.doPrivileged(() -> KNN80DocValuesConsumer.lambda$createKNNIndexFromTemplate$2(pair, indexPath, model, (Map)parameters, knnEngine));
    }

    private void createKNNIndexFromScratch(FieldInfo fieldInfo, KNNCodecUtil.Pair pair, KNNEngine knnEngine, String indexPath) throws IOException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Map fieldAttributes = fieldInfo.attributes();
        String parametersString = (String)fieldAttributes.get("parameters");
        if (parametersString == null) {
            String m;
            parameters.put("spaceType", fieldAttributes.getOrDefault("spaceType", SpaceType.DEFAULT.getValue()));
            String efConstruction = (String)fieldAttributes.get("efConstruction");
            HashMap<String, Integer> algoParams = new HashMap<String, Integer>();
            if (efConstruction != null) {
                algoParams.put("ef_construction", Integer.parseInt(efConstruction));
            }
            if ((m = (String)fieldAttributes.get("M")) != null) {
                algoParams.put("m", Integer.parseInt(m));
            }
            parameters.put("parameters", algoParams);
        } else {
            parameters.putAll(XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, parametersString).map());
        }
        parameters.put("indexThreadQty", KNNSettings.state().getSettingValue("knn.algo_param.index_thread_qty"));
        AccessController.doPrivileged(() -> {
            JNIService.createIndex(pair.docs, pair.vectors, indexPath, parameters, knnEngine.getName());
            return null;
        });
    }

    public void merge(MergeState mergeState) {
        try {
            this.delegatee.merge(mergeState);
            assert (mergeState != null);
            assert (mergeState.mergeFieldInfos != null);
            for (FieldInfo fieldInfo : mergeState.mergeFieldInfos) {
                DocValuesType type = fieldInfo.getDocValuesType();
                if (type != DocValuesType.BINARY || !fieldInfo.attributes().containsKey("knn_field")) continue;
                this.addKNNBinaryField(fieldInfo, (DocValuesProducer)new KNN80DocValuesReader(mergeState));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addSortedSetField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegatee.addSortedSetField(field, valuesProducer);
    }

    public void addSortedNumericField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegatee.addSortedNumericField(field, valuesProducer);
    }

    public void addSortedField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegatee.addSortedField(field, valuesProducer);
    }

    public void addNumericField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegatee.addNumericField(field, valuesProducer);
    }

    @Override
    public void close() throws IOException {
        this.delegatee.close();
    }

    private void writeFooter(String indexPath, String engineFileName) throws IOException {
        OutputStream os = Files.newOutputStream(Paths.get(indexPath, new String[0]), StandardOpenOption.APPEND);
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
        byteBuffer.putInt(-1071082520);
        byteBuffer.putInt(0);
        os.write(byteBuffer.array());
        os.flush();
        ChecksumIndexInput checksumIndexInput = this.state.directory.openChecksumInput(engineFileName, this.state.context);
        checksumIndexInput.seek(checksumIndexInput.length());
        long value = checksumIndexInput.getChecksum();
        checksumIndexInput.close();
        if (this.isChecksumValid(value)) {
            throw new IllegalStateException("Illegal CRC-32 checksum: " + value + " (resource=" + os + ")");
        }
        byteBuffer.putLong(0, value);
        os.write(byteBuffer.array());
        os.close();
    }

    private boolean isChecksumValid(long value) {
        return (value & CRC32_CHECKSUM_SANITY) != 0L;
    }

    private static /* synthetic */ Void lambda$createKNNIndexFromTemplate$2(KNNCodecUtil.Pair pair, String indexPath, byte[] model, Map parameters, KNNEngine knnEngine) {
        JNIService.createIndexFromTemplate(pair.docs, pair.vectors, indexPath, model, parameters, knnEngine.getName());
        return null;
    }

    @FunctionalInterface
    private static interface NativeIndexCreator {
        public void createIndex() throws IOException;
    }
}

