/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import java.util.HashSet;
import java.util.Set;

public enum SpaceType {
    L2("l2"){

        @Override
        public float scoreTranslation(float rawScore) {
            return 1.0f / (1.0f + rawScore);
        }
    }
    ,
    COSINESIMIL("cosinesimil"){

        @Override
        public float scoreTranslation(float rawScore) {
            return 1.0f / (1.0f + rawScore);
        }
    }
    ,
    L1("l1"){

        @Override
        public float scoreTranslation(float rawScore) {
            return 1.0f / (1.0f + rawScore);
        }
    }
    ,
    LINF("linf"){

        @Override
        public float scoreTranslation(float rawScore) {
            return 1.0f / (1.0f + rawScore);
        }
    }
    ,
    INNER_PRODUCT("innerproduct"){

        @Override
        public float scoreTranslation(float rawScore) {
            if (rawScore >= 0.0f) {
                return 1.0f / (1.0f + rawScore);
            }
            return -rawScore + 1.0f;
        }
    }
    ,
    HAMMING_BIT("hammingbit"){

        @Override
        public float scoreTranslation(float rawScore) {
            return 1.0f / (1.0f + rawScore);
        }
    };

    public static SpaceType DEFAULT;
    private final String value;

    private SpaceType(String value) {
        this.value = value;
    }

    public abstract float scoreTranslation(float var1);

    public String getValue() {
        return this.value;
    }

    public static Set<String> getValues() {
        HashSet<String> values = new HashSet<String>();
        for (SpaceType spaceType : SpaceType.values()) {
            values.add(spaceType.getValue());
        }
        return values;
    }

    public static SpaceType getSpace(String spaceTypeName) {
        for (SpaceType currentSpaceType : SpaceType.values()) {
            if (!currentSpaceType.getValue().equalsIgnoreCase(spaceTypeName)) continue;
            return currentSpaceType;
        }
        throw new IllegalArgumentException("Unable to find space: " + spaceTypeName);
    }

    static {
        DEFAULT = L2;
    }
}

