/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.opensearch.common.Explicit;
import org.opensearch.common.Strings;
import org.opensearch.common.ValidationException;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;
import org.opensearch.knn.index.KNNMethodContext;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.KNNVectorIndexFieldData;
import org.opensearch.knn.index.VectorField;
import org.opensearch.knn.index.util.KNNEngine;
import org.opensearch.knn.indices.ModelDao;
import org.opensearch.knn.indices.ModelMetadata;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.aggregations.support.ValuesSourceType;
import org.opensearch.search.lookup.SearchLookup;

public abstract class KNNVectorFieldMapper
extends ParametrizedFieldMapper {
    private static Logger logger = LogManager.getLogger(KNNVectorFieldMapper.class);
    public static final String CONTENT_TYPE = "knn_vector";
    public static final String KNN_FIELD = "knn_field";
    public static final int MAX_DIMENSION = 10000;
    protected Explicit<Boolean> ignoreMalformed;
    protected boolean stored;
    protected boolean hasDocValues;
    protected Integer dimension;
    protected ModelDao modelDao;
    protected KNNMethodContext knnMethod;
    protected String modelId;

    private static KNNVectorFieldMapper toType(FieldMapper in) {
        return (KNNVectorFieldMapper)in;
    }

    public KNNVectorFieldMapper(String simpleName, KNNVectorFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Explicit<Boolean> ignoreMalformed, boolean stored, boolean hasDocValues) {
        super(simpleName, (MappedFieldType)mappedFieldType, multiFields, copyTo);
        this.ignoreMalformed = ignoreMalformed;
        this.stored = stored;
        this.hasDocValues = hasDocValues;
        this.dimension = mappedFieldType.getDimension();
    }

    public KNNVectorFieldMapper clone() {
        return (KNNVectorFieldMapper)super.clone();
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        this.parseCreateField(context, this.fieldType().getDimension());
    }

    protected void parseCreateField(ParseContext context, int dimension) throws IOException {
        float value;
        if (!KNNSettings.isKNNPluginEnabled()) {
            throw new IllegalStateException("KNN plugin is disabled. To enable update knn.plugin.enabled setting to true");
        }
        if (KNNSettings.isCircuitBreakerTriggered()) {
            throw new IllegalStateException("Indexing knn vector fields is rejected as circuit breaker triggered. Check _opendistro/_knn/stats for detailed state");
        }
        context.path().add(this.simpleName());
        ArrayList<Float> vector = new ArrayList<Float>();
        XContentParser.Token token = context.parser().currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            token = context.parser().nextToken();
            while (token != XContentParser.Token.END_ARRAY) {
                value = context.parser().floatValue();
                if (Float.isNaN(value)) {
                    throw new IllegalArgumentException("KNN vector values cannot be NaN");
                }
                if (Float.isInfinite(value)) {
                    throw new IllegalArgumentException("KNN vector values cannot be infinity");
                }
                vector.add(Float.valueOf(value));
                token = context.parser().nextToken();
            }
        } else if (token == XContentParser.Token.VALUE_NUMBER) {
            value = context.parser().floatValue();
            if (Float.isNaN(value)) {
                throw new IllegalArgumentException("KNN vector values cannot be NaN");
            }
            if (Float.isInfinite(value)) {
                throw new IllegalArgumentException("KNN vector values cannot be infinity");
            }
            vector.add(Float.valueOf(value));
            context.parser().nextToken();
        } else if (token == XContentParser.Token.VALUE_NULL) {
            context.path().remove();
            return;
        }
        if (dimension != vector.size()) {
            String errorMessage = String.format("Vector dimension mismatch. Expected: %d, Given: %d", dimension, vector.size());
            throw new IllegalArgumentException(errorMessage);
        }
        float[] array = new float[vector.size()];
        int i = 0;
        for (Float f : vector) {
            array[i++] = f.floatValue();
        }
        VectorField point = new VectorField(this.name(), array, (IndexableFieldType)this.fieldType);
        context.doc().add((IndexableField)point);
        if (this.fieldType.stored()) {
            context.doc().add((IndexableField)new StoredField(this.name(), point.toString()));
        }
        context.path().remove();
    }

    protected boolean docValuesByDefault() {
        return true;
    }

    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.modelDao).init((FieldMapper)this);
    }

    public final boolean parsesArrayValue() {
        return true;
    }

    public KNNVectorFieldType fieldType() {
        return (KNNVectorFieldType)super.fieldType();
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", (Boolean)this.ignoreMalformed.value());
        }
    }

    public static class KNNVectorFieldType
    extends MappedFieldType {
        int dimension;
        String modelId;

        public KNNVectorFieldType(String name, Map<String, String> meta, int dimension) {
            this(name, meta, dimension, null);
        }

        public KNNVectorFieldType(String name, Map<String, String> meta, int dimension, String modelId) {
            super(name, false, false, true, TextSearchInfo.NONE, meta);
            this.dimension = dimension;
            this.modelId = modelId;
        }

        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            throw new UnsupportedOperationException("KNN Vector do not support fields search");
        }

        public String typeName() {
            return KNNVectorFieldMapper.CONTENT_TYPE;
        }

        public Query existsQuery(QueryShardContext context) {
            return new DocValuesFieldExistsQuery(this.name());
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "KNN vector do not support exact searching, use KNN queries instead: [" + this.name() + "]", new Object[0]);
        }

        public int getDimension() {
            return this.dimension;
        }

        public String getModelId() {
            return this.modelId;
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new KNNVectorIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.BYTES);
        }
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        protected Boolean ignoreMalformed;
        protected final ParametrizedFieldMapper.Parameter<Boolean> stored = ParametrizedFieldMapper.Parameter.boolParam((String)"store", (boolean)false, m -> KNNVectorFieldMapper.toType((FieldMapper)m).stored, (boolean)false);
        protected final ParametrizedFieldMapper.Parameter<Boolean> hasDocValues = ParametrizedFieldMapper.Parameter.boolParam((String)"doc_values", (boolean)false, m -> KNNVectorFieldMapper.toType((FieldMapper)m).hasDocValues, (boolean)true);
        protected final ParametrizedFieldMapper.Parameter<Integer> dimension = new ParametrizedFieldMapper.Parameter("dimension", false, () -> -1, (n, c, o) -> {
            if (o == null) {
                throw new IllegalArgumentException("Dimension cannot be null");
            }
            int value = XContentMapValues.nodeIntegerValue((Object)o);
            if (value > 10000) {
                throw new IllegalArgumentException("Dimension value cannot be greater than 10000 for vector: " + this.name);
            }
            if (value <= 0) {
                throw new IllegalArgumentException("Dimension value must be greater than 0 for vector: " + this.name);
            }
            return value;
        }, m -> KNNVectorFieldMapper.toType((FieldMapper)m).dimension);
        protected final ParametrizedFieldMapper.Parameter<String> modelId = ParametrizedFieldMapper.Parameter.stringParam((String)"model_id", (boolean)false, m -> KNNVectorFieldMapper.toType((FieldMapper)m).modelId, null);
        protected final ParametrizedFieldMapper.Parameter<KNNMethodContext> knnMethodContext = new ParametrizedFieldMapper.Parameter("method", false, () -> null, (n, c, o) -> KNNMethodContext.parse(o), m -> KNNVectorFieldMapper.toType((FieldMapper)m).knnMethod).setSerializer((b, n, v) -> {
            b.startObject(n);
            v.toXContent(b, ToXContent.EMPTY_PARAMS);
            b.endObject();
        }, m -> m.getMethodComponent().getName()).setValidator(v -> {
            ValidationException methodValidation;
            if (v == null) {
                return;
            }
            ValidationException validationException = null;
            if (v.isTrainingRequired()) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("\"%s\" requires training.", "method"));
            }
            if ((methodValidation = v.validate()) != null) {
                validationException = validationException == null ? new ValidationException() : validationException;
                validationException.addValidationErrors((Iterable)methodValidation.validationErrors());
            }
            if (validationException != null) {
                throw validationException;
            }
        });
        protected final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();
        protected String spaceType;
        protected String m;
        protected String efConstruction;
        protected ModelDao modelDao;

        public Builder(String name, ModelDao modelDao) {
            super(name);
            this.modelDao = modelDao;
        }

        public Builder(String name, String spaceType, String m2, String efConstruction) {
            super(name);
            this.spaceType = spaceType;
            this.m = m2;
            this.efConstruction = efConstruction;
        }

        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.stored, this.hasDocValues, this.dimension, this.meta, this.knnMethodContext, this.modelId);
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit((Object)this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit((Object)((Boolean)FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings())), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        public KNNVectorFieldMapper build(Mapper.BuilderContext context) {
            KNNMethodContext knnMethodContext = (KNNMethodContext)this.knnMethodContext.getValue();
            if (knnMethodContext != null) {
                return new MethodFieldMapper(this.name, new KNNVectorFieldType(this.buildFullName(context), (Map)this.meta.getValue(), (Integer)this.dimension.getValue()), this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo.build(), this.ignoreMalformed(context), (Boolean)this.stored.get(), (Boolean)this.hasDocValues.get(), knnMethodContext);
            }
            String modelIdAsString = (String)this.modelId.get();
            if (modelIdAsString != null) {
                return new ModelFieldMapper(this.name, new KNNVectorFieldType(this.buildFullName(context), (Map)this.meta.getValue(), -1, modelIdAsString), this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo.build(), this.ignoreMalformed(context), (Boolean)this.stored.get(), (Boolean)this.hasDocValues.get(), this.modelDao, modelIdAsString);
            }
            if (this.spaceType == null) {
                this.spaceType = LegacyFieldMapper.getSpaceType(context.indexSettings());
            }
            if (this.m == null) {
                this.m = LegacyFieldMapper.getM(context.indexSettings());
            }
            if (this.efConstruction == null) {
                this.efConstruction = LegacyFieldMapper.getEfConstruction(context.indexSettings());
            }
            return new LegacyFieldMapper(this.name, new KNNVectorFieldType(this.buildFullName(context), (Map)this.meta.getValue(), (Integer)this.dimension.getValue()), this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo.build(), this.ignoreMalformed(context), (Boolean)this.stored.get(), (Boolean)this.hasDocValues.get(), this.spaceType, this.m, this.efConstruction);
        }
    }

    public static class Names {
        public static final String IGNORE_MALFORMED = "ignore_malformed";
    }

    protected static class ModelFieldMapper
    extends KNNVectorFieldMapper {
        private ModelFieldMapper(String simpleName, KNNVectorFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Explicit<Boolean> ignoreMalformed, boolean stored, boolean hasDocValues, ModelDao modelDao, String modelId) {
            super(simpleName, mappedFieldType, multiFields, copyTo, ignoreMalformed, stored, hasDocValues);
            this.modelId = modelId;
            this.modelDao = modelDao;
            this.fieldType = new FieldType((IndexableFieldType)Defaults.FIELD_TYPE);
            this.fieldType.putAttribute("model_id", modelId);
            this.fieldType.freeze();
        }

        @Override
        protected void parseCreateField(ParseContext context) throws IOException {
            ModelMetadata modelMetadata = this.modelDao.getMetadata(this.modelId);
            if (modelMetadata == null) {
                throw new IllegalStateException("Model \"" + this.modelId + "\" from " + context.mapperService().index().getName() + "'s mapping does not exist. Because the \"model_id\" parameter is not updateable, this index will need to be recreated with a valid model.");
            }
            this.parseCreateField(context, modelMetadata.getDimension());
        }
    }

    protected static class MethodFieldMapper
    extends KNNVectorFieldMapper {
        private MethodFieldMapper(String simpleName, KNNVectorFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Explicit<Boolean> ignoreMalformed, boolean stored, boolean hasDocValues, KNNMethodContext knnMethodContext) {
            super(simpleName, mappedFieldType, multiFields, copyTo, ignoreMalformed, stored, hasDocValues);
            this.knnMethod = knnMethodContext;
            this.fieldType = new FieldType((IndexableFieldType)Defaults.FIELD_TYPE);
            this.fieldType.putAttribute("dimension", String.valueOf(this.dimension));
            this.fieldType.putAttribute("spaceType", knnMethodContext.getSpaceType().getValue());
            KNNEngine knnEngine = knnMethodContext.getEngine();
            this.fieldType.putAttribute("engine", knnEngine.getName());
            try {
                this.fieldType.putAttribute("parameters", Strings.toString((XContentBuilder)XContentFactory.jsonBuilder().map(knnEngine.getMethodAsMap(knnMethodContext))));
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to create KNNVectorFieldMapper: " + ioe);
            }
            this.fieldType.freeze();
        }
    }

    protected static class LegacyFieldMapper
    extends KNNVectorFieldMapper {
        protected String spaceType;
        protected String m;
        protected String efConstruction;

        private LegacyFieldMapper(String simpleName, KNNVectorFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Explicit<Boolean> ignoreMalformed, boolean stored, boolean hasDocValues, String spaceType, String m, String efConstruction) {
            super(simpleName, mappedFieldType, multiFields, copyTo, ignoreMalformed, stored, hasDocValues);
            this.spaceType = spaceType;
            this.m = m;
            this.efConstruction = efConstruction;
            this.fieldType = new FieldType((IndexableFieldType)Defaults.FIELD_TYPE);
            this.fieldType.putAttribute("dimension", String.valueOf(this.dimension));
            this.fieldType.putAttribute("spaceType", spaceType);
            this.fieldType.putAttribute("engine", KNNEngine.NMSLIB.getName());
            this.fieldType.putAttribute("M", m);
            this.fieldType.putAttribute("efConstruction", efConstruction);
            this.fieldType.freeze();
        }

        @Override
        public ParametrizedFieldMapper.Builder getMergeBuilder() {
            return new Builder(this.simpleName(), this.spaceType, this.m, this.efConstruction).init((FieldMapper)this);
        }

        static String getSpaceType(Settings indexSettings) {
            String spaceType = indexSettings.get(KNNSettings.INDEX_KNN_SPACE_TYPE.getKey());
            if (spaceType == null) {
                logger.info("[KNN] The setting \"space_type\" was not set for the index. Likely caused by recent version upgrade. Setting the setting to the default value=l2");
                return "l2";
            }
            return spaceType;
        }

        static String getM(Settings indexSettings) {
            String m = indexSettings.get(KNNSettings.INDEX_KNN_ALGO_PARAM_M_SETTING.getKey());
            if (m == null) {
                logger.info("[KNN] The setting \"M\" was not set for the index. Likely caused by recent version upgrade. Setting the setting to the default value=" + KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_M);
                return String.valueOf(KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_M);
            }
            return m;
        }

        static String getEfConstruction(Settings indexSettings) {
            String efConstruction = indexSettings.get(KNNSettings.INDEX_KNN_ALGO_PARAM_EF_CONSTRUCTION_SETTING.getKey());
            if (efConstruction == null) {
                logger.info("[KNN] The setting \"efConstruction\" was not set for the index. Likely caused by recent version upgrade. Setting the setting to the default value=" + KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_EF_CONSTRUCTION);
                return String.valueOf(KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_EF_CONSTRUCTION);
            }
            return efConstruction;
        }
    }

    public static class Defaults {
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit((Object)false, false);
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setDocValuesType(DocValuesType.BINARY);
            FIELD_TYPE.putAttribute(KNNVectorFieldMapper.KNN_FIELD, "true");
            FIELD_TYPE.freeze();
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        private Supplier<ModelDao> modelDaoSupplier;

        public TypeParser(Supplier<ModelDao> modelDaoSupplier) {
            this.modelDaoSupplier = modelDaoSupplier;
        }

        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name, this.modelDaoSupplier.get());
            builder.parse(name, parserContext, node);
            if (builder.knnMethodContext.get() != null && builder.modelId.get() != null) {
                throw new IllegalArgumentException("Method and model can not be both specified in the mapping: " + name);
            }
            if ((Integer)builder.dimension.getValue() == -1 && builder.modelId.get() == null) {
                throw new IllegalArgumentException("Dimension value missing for vector: " + name);
            }
            return builder;
        }
    }
}

