/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opensearch.common.ValidationException;
import org.opensearch.knn.index.KNNMethodContext;
import org.opensearch.knn.index.MethodComponent;
import org.opensearch.knn.index.SpaceType;

public class KNNMethod {
    private final MethodComponent methodComponent;
    private final Set<SpaceType> spaces;

    public KNNMethod(MethodComponent methodComponent, Set<SpaceType> spaces) {
        this.methodComponent = methodComponent;
        this.spaces = spaces;
    }

    public MethodComponent getMethodComponent() {
        return this.methodComponent;
    }

    public boolean containsSpace(SpaceType space) {
        return this.spaces.contains((Object)space);
    }

    public Set<SpaceType> getSpaces() {
        return this.spaces;
    }

    public ValidationException validate(KNNMethodContext knnMethodContext) {
        ValidationException methodValidation;
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (!this.containsSpace(knnMethodContext.getSpaceType())) {
            errorMessages.add(String.format("\"%s\" configuration does not support space type: \"%s\".", this.methodComponent.getName(), knnMethodContext.getSpaceType().getValue()));
        }
        if ((methodValidation = this.methodComponent.validate(knnMethodContext.getMethodComponent())) != null) {
            errorMessages.addAll(methodValidation.validationErrors());
        }
        if (errorMessages.isEmpty()) {
            return null;
        }
        ValidationException validationException = new ValidationException();
        validationException.addValidationErrors(errorMessages);
        return validationException;
    }

    public boolean isTrainingRequired(KNNMethodContext knnMethodContext) {
        return this.methodComponent.isTrainingRequired(knnMethodContext.getMethodComponent());
    }

    public int estimateOverheadInKB(KNNMethodContext knnMethodContext, int dimension) {
        return this.methodComponent.estimateOverheadInKB(knnMethodContext.getMethodComponent(), dimension);
    }

    public Map<String, Object> getAsMap(KNNMethodContext knnMethodContext) {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>(this.methodComponent.getAsMap(knnMethodContext.getMethodComponent()));
        parameterMap.put("spaceType", knnMethodContext.getSpaceType().getValue());
        return parameterMap;
    }

    public static class Builder {
        private MethodComponent methodComponent;
        private Set<SpaceType> spaces;

        public static Builder builder(MethodComponent methodComponent) {
            return new Builder(methodComponent);
        }

        private Builder(MethodComponent methodComponent) {
            this.methodComponent = methodComponent;
            this.spaces = new HashSet<SpaceType>();
        }

        public Builder addSpaces(SpaceType ... spaceTypes) {
            this.spaces.addAll(Arrays.asList(spaceTypes));
            return this;
        }

        public KNNMethod build() {
            return new KNNMethod(this.methodComponent, this.spaces);
        }
    }
}

