/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.knn.index.IndexUtil;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.codec.util.KNNCodecUtil;
import org.opensearch.knn.index.memory.NativeMemoryCacheManager;
import org.opensearch.knn.index.memory.NativeMemoryEntryContext;
import org.opensearch.knn.index.memory.NativeMemoryLoadStrategy;
import org.opensearch.knn.index.util.KNNEngine;

public class KNNIndexShard {
    private IndexShard indexShard;
    private NativeMemoryCacheManager nativeMemoryCacheManager;
    private static Logger logger = LogManager.getLogger(KNNIndexShard.class);

    public KNNIndexShard(IndexShard indexShard) {
        this.indexShard = indexShard;
        this.nativeMemoryCacheManager = NativeMemoryCacheManager.getInstance();
    }

    public IndexShard getIndexShard() {
        return this.indexShard;
    }

    public String getIndexName() {
        return this.indexShard.shardId().getIndexName();
    }

    public void warmup() throws IOException {
        logger.info("[KNN] Warming up index: " + this.getIndexName());
        try (Engine.Searcher searcher = this.indexShard.acquireSearcher("knn-warmup");){
            this.getAllEnginePaths(searcher.getIndexReader()).forEach((key, value) -> {
                try {
                    this.nativeMemoryCacheManager.get(new NativeMemoryEntryContext.IndexEntryContext((String)key, NativeMemoryLoadStrategy.IndexLoadStrategy.getInstance(), IndexUtil.getParametersAtLoading(value, KNNEngine.getEngineNameFromPath(key), this.getIndexName()), this.getIndexName()), true);
                }
                catch (ExecutionException ex) {
                    throw new RuntimeException(ex);
                }
            });
        }
    }

    public Map<String, SpaceType> getAllEnginePaths(IndexReader indexReader) throws IOException {
        HashMap<String, SpaceType> engineFiles = new HashMap<String, SpaceType>();
        for (KNNEngine knnEngine : KNNEngine.values()) {
            engineFiles.putAll(this.getEnginePaths(indexReader, knnEngine));
        }
        return engineFiles;
    }

    private Map<String, SpaceType> getEnginePaths(IndexReader indexReader, KNNEngine knnEngine) throws IOException {
        HashMap<String, SpaceType> engineFiles = new HashMap<String, SpaceType>();
        for (LeafReaderContext leafReaderContext : indexReader.leaves()) {
            SegmentReader reader = (SegmentReader)FilterLeafReader.unwrap((LeafReader)leafReaderContext.reader());
            Path shardPath = ((FSDirectory)FilterDirectory.unwrap((Directory)reader.directory())).getDirectory();
            String fileExtension = reader.getSegmentInfo().info.getUseCompoundFile() ? knnEngine.getCompoundExtension() : knnEngine.getExtension();
            for (FieldInfo fieldInfo : reader.getFieldInfos()) {
                if (!fieldInfo.attributes().containsKey("knn_field")) continue;
                String spaceTypeName = fieldInfo.attributes().getOrDefault("spaceType", SpaceType.L2.getValue());
                SpaceType spaceType = SpaceType.getSpace(spaceTypeName);
                engineFiles.putAll(this.getEnginePaths(reader.getSegmentInfo().files(), reader.getSegmentInfo().info.name, fieldInfo.name, fileExtension, shardPath, spaceType));
            }
        }
        return engineFiles;
    }

    protected Map<String, SpaceType> getEnginePaths(Collection<String> files, String segmentName, String fieldName, String fileExtension, Path shardPath, SpaceType spaceType) {
        String prefix = KNNCodecUtil.buildEngineFilePrefix(segmentName);
        String suffix = KNNCodecUtil.buildEngineFileSuffix(fieldName, fileExtension);
        return files.stream().filter(fileName -> fileName.startsWith(prefix)).filter(fileName -> fileName.endsWith(suffix)).map(fileName -> shardPath.resolve((String)fileName).toString()).collect(Collectors.toMap(fileName -> fileName, fileName -> spaceType));
    }
}

