/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jobscheduler.model;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.Nullable;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class JobDetails
implements ToXContentObject {
    private String jobIndex;
    private String jobType;
    private String jobParameterAction;
    private String jobRunnerAction;
    private String extensionUniqueId;
    public static final String DOCUMENT_ID = "document_id";
    public static final String JOB_INDEX = "job_index";
    public static final String JOB_TYPE = "job_type";
    public static final String JOB_PARAMETER_ACTION = "job_parser_action";
    public static final String JOB_RUNNER_ACTION = "job_runner_action";
    public static final String EXTENSION_UNIQUE_ID = "extension_unique_id";

    public JobDetails() {
    }

    public JobDetails(String jobIndex, String jobType, String jobParameterAction, String jobRunnerAction, String extensionUniqueId) {
        this.jobIndex = jobIndex;
        this.jobType = jobType;
        this.jobParameterAction = jobParameterAction;
        this.jobRunnerAction = jobRunnerAction;
        this.extensionUniqueId = extensionUniqueId;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        if (this.jobIndex != null) {
            xContentBuilder.field(JOB_INDEX, this.jobIndex);
        }
        if (this.jobType != null) {
            xContentBuilder.field(JOB_TYPE, this.jobType);
        }
        if (this.jobParameterAction != null) {
            xContentBuilder.field(JOB_PARAMETER_ACTION, this.jobParameterAction);
        }
        if (this.jobRunnerAction != null) {
            xContentBuilder.field(JOB_RUNNER_ACTION, this.jobRunnerAction);
        }
        if (this.extensionUniqueId != null) {
            xContentBuilder.field(EXTENSION_UNIQUE_ID, this.extensionUniqueId);
        }
        return xContentBuilder.endObject();
    }

    public static JobDetails parse(XContentParser parser) throws IOException {
        String jobIndex = null;
        String jobType = null;
        String jobParameterAction = null;
        String jobRunnerAction = null;
        String extensionUniqueId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block14: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "job_index": {
                    jobIndex = parser.text();
                    continue block14;
                }
                case "job_type": {
                    jobType = parser.text();
                    continue block14;
                }
                case "job_parser_action": {
                    jobParameterAction = parser.text();
                    continue block14;
                }
                case "job_runner_action": {
                    jobRunnerAction = parser.text();
                    continue block14;
                }
                case "extension_unique_id": {
                    extensionUniqueId = parser.text();
                    continue block14;
                }
            }
            parser.skipChildren();
        }
        return new JobDetails(jobIndex, jobType, jobParameterAction, jobRunnerAction, extensionUniqueId);
    }

    public JobDetails(JobDetails copyJobDetails) {
        this(copyJobDetails.jobIndex, copyJobDetails.jobType, copyJobDetails.jobParameterAction, copyJobDetails.jobRunnerAction, copyJobDetails.extensionUniqueId);
    }

    @Nullable
    public String getJobIndex() {
        return this.jobIndex;
    }

    public void setJobIndex(String jobIndex) {
        this.jobIndex = jobIndex;
    }

    @Nullable
    public String getJobType() {
        return this.jobType;
    }

    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    @Nullable
    public String getJobParameterAction() {
        return this.jobParameterAction;
    }

    public void setJobParameterAction(String jobParameterAction) {
        this.jobParameterAction = jobParameterAction;
    }

    @Nullable
    public String getJobRunnerAction() {
        return this.jobRunnerAction;
    }

    public void setJobRunnerAction(String jobRunnerAction) {
        this.jobRunnerAction = jobRunnerAction;
    }

    @Nullable
    public String getExtensionUniqueId() {
        return this.extensionUniqueId;
    }

    public void setExtensionUniqueId(String extensionUniqueId) {
        this.extensionUniqueId = extensionUniqueId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobDetails that = (JobDetails)o;
        return Objects.equals(this.jobIndex, that.jobIndex) && Objects.equals(this.jobType, that.jobType) && Objects.equals(this.jobParameterAction, that.jobParameterAction) && Objects.equals(this.jobRunnerAction, that.jobRunnerAction) && Objects.equals(this.extensionUniqueId, that.extensionUniqueId);
    }

    public int hashCode() {
        return Objects.hash(this.jobIndex, this.jobType, this.jobParameterAction, this.jobRunnerAction, this.extensionUniqueId);
    }

    public String toString() {
        return "JobDetails{jobIndex='" + this.jobIndex + "', jobType='" + this.jobType + "', jobParameterAction='" + this.jobParameterAction + "', jobRunnerAction='" + this.jobRunnerAction + "', extensionUniqueId='" + this.extensionUniqueId + "'}";
    }
}

