/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.core.action.ActionListener;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.exception.WorkflowStepException;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;
import org.opensearch.ml.client.MachineLearningNodeClient;
import org.opensearch.ml.common.transport.undeploy.MLUndeployModelsResponse;

public class UndeployModelStep
implements WorkflowStep {
    private static final Logger logger = LogManager.getLogger(UndeployModelStep.class);
    private MachineLearningNodeClient mlClient;
    public static final String NAME = "undeploy_model";

    public UndeployModelStep(MachineLearningNodeClient mlClient) {
        this.mlClient = mlClient;
    }

    @Override
    public PlainActionFuture<WorkflowData> execute(String currentNodeId, final WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs, Map<String, String> params) {
        final PlainActionFuture undeployModelFuture = PlainActionFuture.newFuture();
        Set<String> requiredKeys = Set.of("model_id");
        Set<String> optionalKeys = Collections.emptySet();
        try {
            Map<String, Object> inputs = ParseUtils.getInputsFromPreviousSteps(requiredKeys, optionalKeys, currentNodeInputs, outputs, previousNodeInputs, params);
            final String modelId = inputs.get("model_id").toString();
            this.mlClient.undeploy(new String[]{modelId}, null, (ActionListener)new ActionListener<MLUndeployModelsResponse>(){

                public void onResponse(MLUndeployModelsResponse mlUndeployModelsResponse) {
                    List failures = mlUndeployModelsResponse.getResponse().failures();
                    if (failures.isEmpty()) {
                        undeployModelFuture.onResponse((Object)new WorkflowData(Map.ofEntries(Map.entry("success", !mlUndeployModelsResponse.getResponse().hasFailures())), currentNodeInputs.getWorkflowId(), currentNodeInputs.getNodeId()));
                    } else {
                        List failedNodes = failures.stream().map(FailedNodeException::nodeId).collect(Collectors.toList());
                        String message = "Failed to undeploy model on nodes " + String.valueOf(failedNodes);
                        logger.error(message);
                        undeployModelFuture.onFailure((Exception)new OpenSearchException(message, new Object[0]));
                    }
                }

                public void onFailure(Exception ex) {
                    Exception e = WorkflowStepException.getSafeException(ex);
                    Object errorMessage = e == null ? "Failed to undeploy model " + modelId : e.getMessage();
                    logger.error((String)errorMessage, (Throwable)e);
                    undeployModelFuture.onFailure((Exception)new WorkflowStepException((String)errorMessage, ExceptionsHelper.status((Throwable)e)));
                }
            });
        }
        catch (FlowFrameworkException e) {
            undeployModelFuture.onFailure((Exception)e);
        }
        return undeployModelFuture;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

