/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.common.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.flowframework.model.Template;

public class WorkflowRequest
extends ActionRequest {
    @Nullable
    private String workflowId;
    @Nullable
    private Template template;
    private String[] validation;
    private boolean provision;
    private Map<String, String> params;
    private String useCase;
    private Map<String, String> defaultParams;

    public WorkflowRequest(@Nullable String workflowId, @Nullable Template template) {
        this(workflowId, template, new String[]{"all"}, false, Collections.emptyMap(), null, Collections.emptyMap());
    }

    public WorkflowRequest(@Nullable String workflowId, @Nullable Template template, Map<String, String> params) {
        this(workflowId, template, new String[]{"all"}, true, params, null, Collections.emptyMap());
    }

    public WorkflowRequest(@Nullable String workflowId, @Nullable Template template, String useCase, Map<String, String> defaultParams) {
        this(workflowId, template, new String[]{"all"}, false, Collections.emptyMap(), useCase, defaultParams);
    }

    public WorkflowRequest(@Nullable String workflowId, @Nullable Template template, String[] validation, boolean provision, Map<String, String> params, String useCase, Map<String, String> defaultParams) {
        this.workflowId = workflowId;
        this.template = template;
        this.validation = validation;
        this.provision = provision;
        if (!provision && !params.isEmpty()) {
            throw new IllegalArgumentException("Params may only be included when provisioning.");
        }
        this.params = params;
        this.useCase = useCase;
        this.defaultParams = defaultParams;
    }

    public WorkflowRequest(StreamInput in) throws IOException {
        super(in);
        this.workflowId = in.readOptionalString();
        String templateJson = in.readOptionalString();
        this.template = templateJson == null ? null : Template.parse(templateJson);
        this.validation = in.readStringArray();
        this.provision = in.readBoolean();
        this.params = this.provision ? in.readMap(StreamInput::readString, StreamInput::readString) : Collections.emptyMap();
    }

    @Nullable
    public String getWorkflowId() {
        return this.workflowId;
    }

    @Nullable
    public Template getTemplate() {
        return this.template;
    }

    public String[] getValidation() {
        return this.validation;
    }

    public boolean isProvision() {
        return this.provision;
    }

    public Map<String, String> getParams() {
        return Map.copyOf(this.params);
    }

    public String getUseCase() {
        return this.useCase;
    }

    public Map<String, String> getDefaultParams() {
        return Map.copyOf(this.defaultParams);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.workflowId);
        out.writeOptionalString(this.template == null ? null : this.template.toJson());
        out.writeStringArray(this.validation);
        out.writeBoolean(this.provision);
        if (this.provision) {
            out.writeMap(this.params, StreamOutput::writeString, StreamOutput::writeString);
        }
    }

    public ActionRequestValidationException validate() {
        return null;
    }
}

