/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.model.WorkflowState;
import org.opensearch.flowframework.transport.GetWorkflowStateRequest;
import org.opensearch.flowframework.transport.GetWorkflowStateResponse;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class GetWorkflowStateTransportAction
extends HandledTransportAction<GetWorkflowStateRequest, GetWorkflowStateResponse> {
    private final Logger logger = LogManager.getLogger(GetWorkflowStateTransportAction.class);
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public GetWorkflowStateTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/opensearch/flow_framework/workflow_state/get", transportService, actionFilters, GetWorkflowStateRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    protected void doExecute(Task task, GetWorkflowStateRequest request, ActionListener<GetWorkflowStateResponse> listener) {
        String workflowId = request.getWorkflowId();
        User user = ParseUtils.getUserContext(this.client);
        GetRequest getRequest = new GetRequest(".plugins-flow-framework-state").id(workflowId);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.logger.info("Querying state workflow doc: {}", (Object)workflowId);
            this.client.get(getRequest, ActionListener.runBefore((ActionListener)ActionListener.wrap(r -> {
                if (r != null && r.isExists()) {
                    try (XContentParser parser = ParseUtils.createXContentParserFromRegistry(this.xContentRegistry, r.getSourceAsBytesRef());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        WorkflowState workflowState = WorkflowState.parse(parser);
                        listener.onResponse((Object)new GetWorkflowStateResponse(workflowState, request.getAll()));
                    }
                    catch (Exception e) {
                        String errorMessage = "Failed to parse workflowState: " + r.getId();
                        this.logger.error(errorMessage, (Throwable)e);
                        listener.onFailure((Exception)new FlowFrameworkException(errorMessage, RestStatus.BAD_REQUEST));
                    }
                } else {
                    listener.onFailure((Exception)new FlowFrameworkException("Fail to find workflow " + workflowId, RestStatus.NOT_FOUND));
                }
            }, e -> {
                if (e instanceof IndexNotFoundException) {
                    listener.onFailure((Exception)new FlowFrameworkException("Fail to find workflow " + workflowId, RestStatus.NOT_FOUND));
                } else {
                    String errorMessage = "Failed to get workflow status of: " + workflowId;
                    this.logger.error(errorMessage, (Throwable)e);
                    listener.onFailure((Exception)new FlowFrameworkException(errorMessage, RestStatus.NOT_FOUND));
                }
            }), () -> ((ThreadContext.StoredContext)context).restore()));
        }
        catch (Exception e2) {
            String errorMessage = "Failed to get workflow: " + workflowId;
            this.logger.error(errorMessage, (Throwable)e2);
            listener.onFailure((Exception)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)e2)));
        }
    }
}

