/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.model.PipelineProcessor;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.ml.common.model.Guardrails;

public class WorkflowNode
implements ToXContentObject {
    public static final String ID_FIELD = "id";
    public static final String TYPE_FIELD = "type";
    public static final String PREVIOUS_NODE_INPUTS_FIELD = "previous_node_inputs";
    public static final String USER_INPUTS_FIELD = "user_inputs";
    public static final String PROCESSORS_FIELD = "processors";
    public static final String NODE_TIMEOUT_FIELD = "node_timeout";
    public static final TimeValue NODE_TIMEOUT_DEFAULT_VALUE = new TimeValue(10L, TimeUnit.SECONDS);
    private final String id;
    private final String type;
    private final Map<String, String> previousNodeInputs;
    private final Map<String, Object> userInputs;
    private static final Logger logger = LogManager.getLogger(WorkflowNode.class);

    public WorkflowNode(String id, String type, Map<String, String> previousNodeInputs, Map<String, Object> userInputs) {
        this.id = id;
        this.type = type;
        this.previousNodeInputs = Map.copyOf(previousNodeInputs);
        this.userInputs = Map.copyOf(userInputs);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        xContentBuilder.field(ID_FIELD, this.id);
        xContentBuilder.field(TYPE_FIELD, this.type);
        xContentBuilder.field(PREVIOUS_NODE_INPUTS_FIELD);
        ParseUtils.buildStringToStringMap(xContentBuilder, this.previousNodeInputs);
        xContentBuilder.startObject(USER_INPUTS_FIELD);
        for (Map.Entry<String, Object> e : this.userInputs.entrySet()) {
            xContentBuilder.field(e.getKey());
            if (e.getValue() instanceof String || e.getValue() instanceof Number || e.getValue() instanceof Boolean) {
                xContentBuilder.value(e.getValue());
                continue;
            }
            if ("guardrails".equals(e.getKey())) {
                Guardrails g = (Guardrails)e.getValue();
                xContentBuilder.value((Object)g);
                continue;
            }
            if (e.getValue() instanceof Map) {
                ParseUtils.buildStringToStringMap(xContentBuilder, (Map)e.getValue());
                continue;
            }
            if (!(e.getValue() instanceof Object[])) continue;
            xContentBuilder.startArray();
            if (PROCESSORS_FIELD.equals(e.getKey())) {
                for (PipelineProcessor p : (PipelineProcessor[])e.getValue()) {
                    xContentBuilder.value((Object)p);
                }
            } else if ("tools_order".equals(e.getKey())) {
                for (String t : (String[])e.getValue()) {
                    xContentBuilder.value(t);
                }
            } else {
                for (Map map : (Map[])e.getValue()) {
                    ParseUtils.buildStringToObjectMap(xContentBuilder, map);
                }
            }
            xContentBuilder.endArray();
        }
        xContentBuilder.endObject();
        return xContentBuilder.endObject();
    }

    public static WorkflowNode parse(XContentParser parser) throws IOException {
        String id = null;
        String type = null;
        Map<String, String> previousNodeInputs = new HashMap<String, String>();
        HashMap<String, Object> userInputs = new HashMap<String, Object>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block28: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "id": {
                    id = parser.text();
                    continue block28;
                }
                case "type": {
                    type = parser.text();
                    continue block28;
                }
                case "previous_node_inputs": {
                    previousNodeInputs = ParseUtils.parseStringToStringMap(parser);
                    continue block28;
                }
                case "user_inputs": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    block29: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String inputFieldName = parser.currentName();
                        switch (parser.nextToken()) {
                            case VALUE_STRING: {
                                userInputs.put(inputFieldName, parser.text());
                                continue block29;
                            }
                            case START_OBJECT: {
                                if ("guardrails".equals(inputFieldName)) {
                                    userInputs.put(inputFieldName, Guardrails.parse((XContentParser)parser));
                                    continue block29;
                                }
                                if ("configurations".equals(inputFieldName) || "interface".equals(inputFieldName)) {
                                    Map configurationsMap = parser.map();
                                    try {
                                        String configurationsString = ParseUtils.parseArbitraryStringToObjectMapToString(configurationsMap);
                                        userInputs.put(inputFieldName, configurationsString);
                                        continue block29;
                                    }
                                    catch (Exception ex) {
                                        String errorMessage = "Failed to parse" + inputFieldName + "map";
                                        logger.error(errorMessage, (Throwable)ex);
                                        throw new FlowFrameworkException(errorMessage, RestStatus.BAD_REQUEST);
                                    }
                                }
                                userInputs.put(inputFieldName, ParseUtils.parseStringToStringMap(parser));
                                continue block29;
                            }
                            case START_ARRAY: {
                                if (PROCESSORS_FIELD.equals(inputFieldName)) {
                                    ArrayList<PipelineProcessor> processorList = new ArrayList<PipelineProcessor>();
                                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                        processorList.add(PipelineProcessor.parse(parser));
                                    }
                                    userInputs.put(inputFieldName, processorList.toArray(new PipelineProcessor[0]));
                                    continue block29;
                                }
                                if ("tools_order".equals(inputFieldName)) {
                                    ArrayList<String> toolsList = new ArrayList<String>();
                                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                        toolsList.add(parser.text());
                                    }
                                    userInputs.put(inputFieldName, toolsList.toArray(new String[0]));
                                    continue block29;
                                }
                                ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
                                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                    mapList.add(ParseUtils.parseStringToObjectMap(parser));
                                }
                                userInputs.put(inputFieldName, mapList.toArray(new Map[0]));
                                continue block29;
                            }
                            case VALUE_NUMBER: {
                                switch (parser.numberType()) {
                                    case INT: {
                                        userInputs.put(inputFieldName, parser.intValue());
                                        continue block29;
                                    }
                                    case LONG: {
                                        userInputs.put(inputFieldName, parser.longValue());
                                        continue block29;
                                    }
                                    case FLOAT: {
                                        userInputs.put(inputFieldName, Float.valueOf(parser.floatValue()));
                                        continue block29;
                                    }
                                    case DOUBLE: {
                                        userInputs.put(inputFieldName, parser.doubleValue());
                                        continue block29;
                                    }
                                    case BIG_INTEGER: {
                                        userInputs.put(inputFieldName, parser.bigIntegerValue());
                                        continue block29;
                                    }
                                }
                                throw new FlowFrameworkException("Unable to parse field [" + inputFieldName + "] in a node object.", RestStatus.BAD_REQUEST);
                            }
                            case VALUE_BOOLEAN: {
                                userInputs.put(inputFieldName, parser.booleanValue());
                                continue block29;
                            }
                        }
                        throw new FlowFrameworkException("Unable to parse field [" + inputFieldName + "] in a node object.", RestStatus.BAD_REQUEST);
                    }
                    continue block28;
                }
            }
            throw new FlowFrameworkException("Unable to parse field [" + fieldName + "] in a node object.", RestStatus.BAD_REQUEST);
        }
        if (id == null || type == null) {
            throw new FlowFrameworkException("An node object requires both an id and type field.", RestStatus.BAD_REQUEST);
        }
        return new WorkflowNode(id, type, previousNodeInputs, userInputs);
    }

    public String id() {
        return this.id;
    }

    public String type() {
        return this.type;
    }

    public Map<String, Object> userInputs() {
        return this.userInputs;
    }

    public Map<String, String> previousNodeInputs() {
        return this.previousNodeInputs;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkflowNode other = (WorkflowNode)obj;
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        return this.id;
    }
}

