/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.flowframework.exception.FlowFrameworkException;

public enum DefaultUseCases {
    OPEN_AI_EMBEDDING_MODEL_DEPLOY("open_ai_embedding_model_deploy", "defaults/openai-embedding-defaults.json", "substitutionTemplates/deploy-remote-model-template.json", List.of("create_connector.credential.key")),
    COHERE_EMBEDDING_MODEL_DEPLOY("cohere_embedding_model_deploy", "defaults/cohere-embedding-defaults.json", "substitutionTemplates/deploy-remote-model-extra-params-template.json", List.of("create_connector.credential.key")),
    BEDROCK_TITAN_EMBEDDING_MODEL_DEPLOY("bedrock_titan_embedding_model_deploy", "defaults/bedrock-titan-embedding-defaults.json", "substitutionTemplates/deploy-remote-bedrock-model-template.json", List.of("create_connector.credential.access_key", "create_connector.credential.secret_key", "create_connector.credential.session_token")),
    BEDROCK_TITAN_MULTIMODAL_MODEL_DEPLOY("bedrock_titan_multimodal_model_deploy", "defaults/bedrock-titan-multimodal-defaults.json", "substitutionTemplates/deploy-remote-bedrock-model-template.json", List.of("create_connector.credential.access_key", "create_connector.credential.secret_key", "create_connector.credential.session_token")),
    COHERE_CHAT_MODEL_DEPLOY("cohere_chat_model_deploy", "defaults/cohere-chat-defaults.json", "substitutionTemplates/deploy-remote-model-chat-template.json", List.of("create_connector.credential.key")),
    OPENAI_CHAT_MODEL_DEPLOY("openai_chat_model_deploy", "defaults/openai-chat-defaults.json", "substitutionTemplates/deploy-remote-model-chat-template.json", List.of("create_connector.credential.key")),
    LOCAL_NEURAL_SPARSE_SEARCH_BI_ENCODER("local_neural_sparse_search_bi_encoder", "defaults/local-sparse-search-biencoder-defaults.json", "substitutionTemplates/neural-sparse-local-biencoder-template.json", Collections.emptyList()),
    SEMANTIC_SEARCH("semantic_search", "defaults/semantic-search-defaults.json", "substitutionTemplates/semantic-search-template.json", List.of("create_ingest_pipeline.model_id")),
    MULTI_MODAL_SEARCH("multimodal_search", "defaults/multi-modal-search-defaults.json", "substitutionTemplates/multi-modal-search-template.json", List.of("create_ingest_pipeline.model_id")),
    MULTI_MODAL_SEARCH_WITH_BEDROCK_TITAN("multimodal_search_with_bedrock_titan", "defaults/multimodal-search-bedrock-titan-defaults.json", "substitutionTemplates/multi-modal-search-with-bedrock-titan-template.json", List.of("create_connector.credential.access_key", "create_connector.credential.secret_key", "create_connector.credential.session_token")),
    SEMANTIC_SEARCH_WITH_QUERY_ENRICHER("semantic_search_with_query_enricher", "defaults/semantic-search-query-enricher-defaults.json", "substitutionTemplates/semantic-search-with-query-enricher-template.json", List.of("create_ingest_pipeline.model_id")),
    SEMANTIC_SEARCH_WITH_COHERE_EMBEDDING("semantic_search_with_cohere_embedding", "defaults/cohere-embedding-semantic-search-defaults.json", "substitutionTemplates/semantic-search-with-model-template.json", List.of("create_connector.credential.key")),
    SEMANTIC_SEARCH_WITH_COHERE_EMBEDDING_AND_QUERY_ENRICHER("semantic_search_with_cohere_embedding_query_enricher", "defaults/cohere-embedding-semantic-search-with-query-enricher-defaults.json", "substitutionTemplates/semantic-search-with-model-and-query-enricher-template.json", List.of("create_connector.credential.key")),
    HYBRID_SEARCH("hybrid_search", "defaults/hybrid-search-defaults.json", "substitutionTemplates/hybrid-search-template.json", List.of("create_ingest_pipeline.model_id")),
    CONVERSATIONAL_SEARCH_WITH_COHERE_DEPLOY("conversational_search_with_llm_deploy", "defaults/conversational-search-defaults.json", "substitutionTemplates/conversational-search-with-cohere-model-template.json", List.of("create_connector.credential.key"));

    private final String useCaseName;
    private final String defaultsFile;
    private final String substitutionReadyFile;
    private final List<String> requiredParams;
    private static final Logger logger;

    private DefaultUseCases(String useCaseName, String defaultsFile, String substitutionReadyFile, List<String> requiredParams) {
        this.useCaseName = useCaseName;
        this.defaultsFile = defaultsFile;
        this.substitutionReadyFile = substitutionReadyFile;
        this.requiredParams = requiredParams;
    }

    public String getUseCaseName() {
        return this.useCaseName;
    }

    public String getDefaultsFile() {
        return this.defaultsFile;
    }

    public String getSubstitutionReadyFile() {
        return this.substitutionReadyFile;
    }

    public List<String> getRequiredParams() {
        return this.requiredParams;
    }

    public static String getDefaultsFileByUseCaseName(String useCaseName) throws FlowFrameworkException {
        if (useCaseName != null && !useCaseName.isEmpty()) {
            for (DefaultUseCases usecase : DefaultUseCases.values()) {
                if (!useCaseName.equals(usecase.getUseCaseName())) continue;
                return usecase.getDefaultsFile();
            }
        }
        logger.error("Unable to find defaults file for use case: {}", (Object)useCaseName);
        throw new FlowFrameworkException("Unable to find defaults file for use case: " + useCaseName, RestStatus.BAD_REQUEST);
    }

    public static String getSubstitutionReadyFileByUseCaseName(String useCaseName) throws FlowFrameworkException {
        if (useCaseName != null && !useCaseName.isEmpty()) {
            for (DefaultUseCases useCase : DefaultUseCases.values()) {
                if (!useCase.getUseCaseName().equals(useCaseName)) continue;
                return useCase.getSubstitutionReadyFile();
            }
        }
        logger.error("Unable to find substitution ready file for use case: {}", (Object)useCaseName);
        throw new FlowFrameworkException("Unable to find substitution ready file for use case: " + useCaseName, RestStatus.BAD_REQUEST);
    }

    public static List<String> getRequiredParamsByUseCaseName(String useCaseName) {
        if (useCaseName != null && !useCaseName.isEmpty()) {
            for (DefaultUseCases useCase : DefaultUseCases.values()) {
                if (!useCase.getUseCaseName().equals(useCaseName)) continue;
                return new ArrayList<String>(useCase.getRequiredParams());
            }
        }
        logger.error("Default use case [" + useCaseName + "] does not exist");
        throw new FlowFrameworkException("Default use case [" + useCaseName + "] does not exist", RestStatus.BAD_REQUEST);
    }

    static {
        logger = LogManager.getLogger(DefaultUseCases.class);
    }
}

