/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.connector;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.text.StringSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.AccessMode;
import org.opensearch.ml.common.connector.AbstractConnector;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.connector.ConnectorAction;
import org.opensearch.ml.common.connector.ConnectorProtocols;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorInput;
import org.opensearch.ml.common.utils.StringUtils;

@org.opensearch.ml.common.annotation.Connector(value="http")
public class HttpConnector
extends AbstractConnector {
    @Generated
    private static final Logger log = LogManager.getLogger(HttpConnector.class);
    public static final String CREDENTIAL_FIELD = "credential";
    public static final String RESPONSE_FILTER_FIELD = "response_filter";
    public static final String PARAMETERS_FIELD = "parameters";
    public static final String SERVICE_NAME_FIELD = "service_name";
    public static final String REGION_FIELD = "region";

    public HttpConnector(String name, String description, String version, String protocol, Map<String, String> parameters, Map<String, String> credential, List<ConnectorAction> actions, List<String> backendRoles, AccessMode accessMode, User owner) {
        ConnectorProtocols.validateProtocol(protocol);
        this.name = name;
        this.description = description;
        this.version = version;
        this.protocol = protocol;
        this.parameters = parameters;
        this.credential = credential;
        this.actions = actions;
        this.backendRoles = backendRoles;
        this.access = accessMode;
        this.owner = owner;
    }

    public HttpConnector(String protocol, XContentParser parser) throws IOException {
        this.protocol = protocol;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block28: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    this.name = parser.text();
                    continue block28;
                }
                case "version": {
                    this.version = parser.text();
                    continue block28;
                }
                case "description": {
                    this.description = parser.text();
                    continue block28;
                }
                case "protocol": {
                    this.protocol = parser.text();
                    continue block28;
                }
                case "parameters": {
                    Map map = parser.map();
                    this.parameters = StringUtils.getParameterMap(map);
                    continue block28;
                }
                case "credential": {
                    this.credential = new HashMap();
                    this.credential.putAll(parser.mapStrings());
                    continue block28;
                }
                case "actions": {
                    this.actions = new ArrayList();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        this.actions.add(ConnectorAction.parse(parser));
                    }
                    continue block28;
                }
                case "backend_roles": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    this.backendRoles = new ArrayList();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        this.backendRoles.add(parser.text());
                    }
                    continue block28;
                }
                case "owner": {
                    this.owner = User.parse((XContentParser)parser);
                    continue block28;
                }
                case "access": {
                    this.access = AccessMode.from(parser.text());
                    continue block28;
                }
                case "created_time": {
                    this.createdTime = Instant.ofEpochMilli(parser.longValue());
                    continue block28;
                }
                case "last_updated_time": {
                    this.lastUpdateTime = Instant.ofEpochMilli(parser.longValue());
                    continue block28;
                }
            }
            parser.skipChildren();
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.name != null) {
            builder.field("name", this.name);
        }
        if (this.version != null) {
            builder.field("version", this.version);
        }
        if (this.description != null) {
            builder.field("description", this.description);
        }
        if (this.protocol != null) {
            builder.field("protocol", this.protocol);
        }
        if (this.parameters != null) {
            builder.field(PARAMETERS_FIELD, (Object)this.parameters);
        }
        if (this.credential != null) {
            builder.field(CREDENTIAL_FIELD, (Object)this.credential);
        }
        if (this.actions != null) {
            builder.field("actions", (Iterable)this.actions);
        }
        if (this.backendRoles != null) {
            builder.field("backend_roles", (Iterable)this.backendRoles);
        }
        if (this.owner != null) {
            builder.field("owner", (ToXContent)this.owner);
        }
        if (this.access != null) {
            builder.field("access", this.access.getValue());
        }
        if (this.createdTime != null) {
            builder.field("created_time", this.createdTime.toEpochMilli());
        }
        if (this.lastUpdateTime != null) {
            builder.field("last_updated_time", this.lastUpdateTime.toEpochMilli());
        }
        builder.endObject();
        return builder;
    }

    public HttpConnector(String protocol, StreamInput input) throws IOException {
        this.protocol = protocol;
        this.parseFromStream(input);
    }

    public HttpConnector(StreamInput input) throws IOException {
        this.protocol = input.readString();
        this.parseFromStream(input);
    }

    private void parseFromStream(StreamInput input) throws IOException {
        this.name = input.readOptionalString();
        this.version = input.readOptionalString();
        this.description = input.readOptionalString();
        if (input.readBoolean()) {
            this.parameters = input.readMap(StreamInput::readString, StreamInput::readString);
        }
        if (input.readBoolean()) {
            this.credential = input.readMap(StreamInput::readString, StreamInput::readString);
        }
        if (input.readBoolean()) {
            this.actions = new ArrayList();
            int size = input.readInt();
            for (int i = 0; i < size; ++i) {
                this.actions.add(new ConnectorAction(input));
            }
        }
        this.backendRoles = input.readOptionalStringList();
        if (input.readBoolean()) {
            this.access = (AccessMode)input.readEnum(AccessMode.class);
        }
        if (input.readBoolean()) {
            this.owner = new User(input);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.protocol);
        out.writeOptionalString(this.name);
        out.writeOptionalString(this.version);
        out.writeOptionalString(this.description);
        if (this.parameters != null) {
            out.writeBoolean(true);
            out.writeMap(this.parameters, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        if (this.credential != null) {
            out.writeBoolean(true);
            out.writeMap(this.credential, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        if (this.actions != null) {
            out.writeBoolean(true);
            out.writeInt(this.actions.size());
            for (ConnectorAction action : this.actions) {
                action.writeTo(out);
            }
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalStringCollection((Collection)this.backendRoles);
        if (this.access != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.access);
        } else {
            out.writeBoolean(false);
        }
        if (this.owner != null) {
            out.writeBoolean(true);
            this.owner.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void update(MLCreateConnectorInput updateContent, Function<String, String> function) {
        if (updateContent.getName() != null) {
            this.name = updateContent.getName();
        }
        if (updateContent.getDescription() != null) {
            this.description = updateContent.getDescription();
        }
        if (updateContent.getVersion() != null) {
            this.version = updateContent.getVersion();
        }
        if (updateContent.getProtocol() != null) {
            this.protocol = updateContent.getProtocol();
        }
        if (updateContent.getParameters() != null && updateContent.getParameters().size() > 0) {
            this.parameters = updateContent.getParameters();
        }
        if (updateContent.getCredential() != null && updateContent.getCredential().size() > 0) {
            this.credential = updateContent.getCredential();
            this.encrypt(function);
        }
        if (updateContent.getActions() != null) {
            this.actions = updateContent.getActions();
        }
        if (updateContent.getBackendRoles() != null) {
            this.backendRoles = updateContent.getBackendRoles();
        }
        if (updateContent.getAccess() != null) {
            this.access = updateContent.getAccess();
        }
    }

    @Override
    public <T> T createPredictPayload(Map<String, String> parameters) {
        Optional<ConnectorAction> predictAction = this.findPredictAction();
        if (predictAction.isPresent() && predictAction.get().getRequestBody() != null) {
            String payload = predictAction.get().getRequestBody();
            payload = this.fillNullParameters(parameters, payload);
            StringSubstitutor substitutor = new StringSubstitutor(parameters, "${parameters.", "}");
            if (!StringUtils.isJson(payload = substitutor.replace(payload))) {
                throw new IllegalArgumentException("Invalid payload: " + payload);
            }
            return (T)payload;
        }
        return (T)parameters.get("http_body");
    }

    protected String fillNullParameters(Map<String, String> parameters, String payload) {
        List<String> bodyParams = this.findStringParametersWithNullDefaultValue(payload);
        String newPayload = payload;
        for (String key : bodyParams) {
            if (parameters.containsKey(key) && parameters.get(key) != null) continue;
            newPayload = newPayload.replace("\"${parameters." + key + ":-null}\"", "null");
        }
        return newPayload;
    }

    private List<String> findStringParametersWithNullDefaultValue(String input) {
        String regex = "\"\\$\\{parameters\\.(\\w+):-null}\"";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        ArrayList<String> paramList = new ArrayList<String>();
        while (matcher.find()) {
            String parameterValue = matcher.group(1);
            paramList.add(parameterValue);
        }
        return paramList;
    }

    @Override
    public void decrypt(Function<String, String> function) {
        HashMap<String, String> decrypted = new HashMap<String, String>();
        for (String key : this.credential.keySet()) {
            decrypted.put(key, function.apply((String)this.credential.get(key)));
        }
        this.decryptedCredential = decrypted;
        Optional<ConnectorAction> predictAction = this.findPredictAction();
        Map<String, String> headers = predictAction.isPresent() ? predictAction.get().getHeaders() : null;
        this.decryptedHeaders = this.createPredictDecryptedHeaders(headers);
    }

    @Override
    public Connector cloneConnector() {
        HttpConnector httpConnector;
        BytesStreamOutput bytesStreamOutput = new BytesStreamOutput();
        try {
            this.writeTo((StreamOutput)bytesStreamOutput);
            StreamInput streamInput = bytesStreamOutput.bytes().streamInput();
            httpConnector = new HttpConnector(streamInput);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bytesStreamOutput.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        bytesStreamOutput.close();
        return httpConnector;
    }

    @Override
    public void encrypt(Function<String, String> function) {
        for (String key : this.credential.keySet()) {
            String encrypted = function.apply((String)this.credential.get(key));
            this.credential.put(key, encrypted);
        }
    }

    @Override
    public String getPredictHttpMethod() {
        return this.findPredictAction().get().getMethod();
    }

    @Generated
    public static HttpConnectorBuilder builder() {
        return new HttpConnectorBuilder();
    }

    @Generated
    public HttpConnector() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpConnector)) {
            return false;
        }
        HttpConnector other = (HttpConnector)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpConnector;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public static class HttpConnectorBuilder {
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private String version;
        @Generated
        private String protocol;
        @Generated
        private Map<String, String> parameters;
        @Generated
        private Map<String, String> credential;
        @Generated
        private List<ConnectorAction> actions;
        @Generated
        private List<String> backendRoles;
        @Generated
        private AccessMode accessMode;
        @Generated
        private User owner;

        @Generated
        HttpConnectorBuilder() {
        }

        @Generated
        public HttpConnectorBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public HttpConnectorBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public HttpConnectorBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public HttpConnectorBuilder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Generated
        public HttpConnectorBuilder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        @Generated
        public HttpConnectorBuilder credential(Map<String, String> credential) {
            this.credential = credential;
            return this;
        }

        @Generated
        public HttpConnectorBuilder actions(List<ConnectorAction> actions) {
            this.actions = actions;
            return this;
        }

        @Generated
        public HttpConnectorBuilder backendRoles(List<String> backendRoles) {
            this.backendRoles = backendRoles;
            return this;
        }

        @Generated
        public HttpConnectorBuilder accessMode(AccessMode accessMode) {
            this.accessMode = accessMode;
            return this;
        }

        @Generated
        public HttpConnectorBuilder owner(User owner) {
            this.owner = owner;
            return this;
        }

        @Generated
        public HttpConnector build() {
            return new HttpConnector(this.name, this.description, this.version, this.protocol, this.parameters, this.credential, this.actions, this.backendRoles, this.accessMode, this.owner);
        }

        @Generated
        public String toString() {
            return "HttpConnector.HttpConnectorBuilder(name=" + this.name + ", description=" + this.description + ", version=" + this.version + ", protocol=" + this.protocol + ", parameters=" + String.valueOf(this.parameters) + ", credential=" + String.valueOf(this.credential) + ", actions=" + String.valueOf(this.actions) + ", backendRoles=" + String.valueOf(this.backendRoles) + ", accessMode=" + String.valueOf((Object)this.accessMode) + ", owner=" + String.valueOf(this.owner) + ")";
        }
    }
}

