/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.flowframework.common.FlowFrameworkSettings;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.workflow.CreateConnectorStep;
import org.opensearch.flowframework.workflow.DeleteAgentStep;
import org.opensearch.flowframework.workflow.DeleteConnectorStep;
import org.opensearch.flowframework.workflow.DeleteModelStep;
import org.opensearch.flowframework.workflow.DeployModelStep;
import org.opensearch.flowframework.workflow.NoOpStep;
import org.opensearch.flowframework.workflow.RegisterAgentStep;
import org.opensearch.flowframework.workflow.RegisterLocalCustomModelStep;
import org.opensearch.flowframework.workflow.RegisterLocalPretrainedModelStep;
import org.opensearch.flowframework.workflow.RegisterLocalSparseEncodingModelStep;
import org.opensearch.flowframework.workflow.RegisterModelGroupStep;
import org.opensearch.flowframework.workflow.RegisterRemoteModelStep;
import org.opensearch.flowframework.workflow.ToolStep;
import org.opensearch.flowframework.workflow.UndeployModelStep;
import org.opensearch.flowframework.workflow.WorkflowStep;
import org.opensearch.ml.client.MachineLearningNodeClient;
import org.opensearch.threadpool.ThreadPool;

public class WorkflowStepFactory {
    private final Map<String, Supplier<WorkflowStep>> stepMap = new HashMap<String, Supplier<WorkflowStep>>();

    public WorkflowStepFactory(ThreadPool threadPool, ClusterService clusterService, Client client, MachineLearningNodeClient mlClient, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler, FlowFrameworkSettings flowFrameworkSettings) {
        this.stepMap.put("noop", NoOpStep::new);
        this.stepMap.put("register_local_custom_model", () -> new RegisterLocalCustomModelStep(threadPool, mlClient, flowFrameworkIndicesHandler, flowFrameworkSettings));
        this.stepMap.put("register_local_sparse_encoding_model", () -> new RegisterLocalSparseEncodingModelStep(threadPool, mlClient, flowFrameworkIndicesHandler, flowFrameworkSettings));
        this.stepMap.put("register_local_pretrained_model", () -> new RegisterLocalPretrainedModelStep(threadPool, mlClient, flowFrameworkIndicesHandler, flowFrameworkSettings));
        this.stepMap.put("register_remote_model", () -> new RegisterRemoteModelStep(mlClient, flowFrameworkIndicesHandler));
        this.stepMap.put("delete_model", () -> new DeleteModelStep(mlClient));
        this.stepMap.put("deploy_model", () -> new DeployModelStep(threadPool, mlClient, flowFrameworkIndicesHandler, flowFrameworkSettings));
        this.stepMap.put("undeploy_model", () -> new UndeployModelStep(mlClient));
        this.stepMap.put("create_connector", () -> new CreateConnectorStep(mlClient, flowFrameworkIndicesHandler));
        this.stepMap.put("delete_connector", () -> new DeleteConnectorStep(mlClient));
        this.stepMap.put("register_model_group", () -> new RegisterModelGroupStep(mlClient, flowFrameworkIndicesHandler));
        this.stepMap.put("noop", NoOpStep::new);
        this.stepMap.put("create_tool", ToolStep::new);
        this.stepMap.put("register_agent", () -> new RegisterAgentStep(mlClient, flowFrameworkIndicesHandler));
        this.stepMap.put("delete_agent", () -> new DeleteAgentStep(mlClient));
    }

    public WorkflowStep createStep(String type) {
        if (this.stepMap.containsKey(type)) {
            return this.stepMap.get(type).get();
        }
        throw new FlowFrameworkException("Workflow step type [" + type + "] is not implemented.", RestStatus.NOT_IMPLEMENTED);
    }

    public Map<String, Supplier<WorkflowStep>> getStepMap() {
        return Map.copyOf(this.stepMap);
    }
}

