/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;
import org.opensearch.ml.common.agent.MLToolSpec;

public class ToolStep
implements WorkflowStep {
    private static final Logger logger = LogManager.getLogger(ToolStep.class);
    PlainActionFuture<WorkflowData> toolFuture = PlainActionFuture.newFuture();
    static final String NAME = "create_tool";

    @Override
    public PlainActionFuture<WorkflowData> execute(String currentNodeId, WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs) {
        Set<String> requiredKeys = Set.of("type");
        Set<String> optionalKeys = Set.of("name", "description", "parameters", "include_output_in_agent_response");
        try {
            Map<String, Object> inputs = ParseUtils.getInputsFromPreviousSteps(requiredKeys, optionalKeys, currentNodeInputs, outputs, previousNodeInputs);
            String type = (String)inputs.get("type");
            String name = (String)inputs.get("name");
            String description = (String)inputs.get("description");
            Boolean includeOutputInAgentResponse = (Boolean)inputs.get("include_output_in_agent_response");
            Map<String, String> parameters = this.getToolsParametersMap(inputs.get("parameters"), previousNodeInputs, outputs);
            MLToolSpec.MLToolSpecBuilder builder = MLToolSpec.builder();
            builder.type(type);
            if (name != null) {
                builder.name(name);
            }
            if (description != null) {
                builder.description(description);
            }
            if (parameters != null) {
                builder.parameters(parameters);
            }
            if (includeOutputInAgentResponse != null) {
                builder.includeOutputInAgentResponse(includeOutputInAgentResponse.booleanValue());
            }
            MLToolSpec mlToolSpec = builder.build();
            this.toolFuture.onResponse((Object)new WorkflowData(Map.ofEntries(Map.entry("tools", mlToolSpec)), currentNodeInputs.getWorkflowId(), currentNodeInputs.getNodeId()));
            logger.info("Tool registered successfully {}", (Object)type);
        }
        catch (FlowFrameworkException e) {
            this.toolFuture.onFailure((Exception)e);
        }
        return this.toolFuture;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private Map<String, String> getToolsParametersMap(Object parameters, Map<String, String> previousNodeInputs, Map<String, WorkflowData> outputs) {
        WorkflowData previousNodeOutput;
        Map parametersMap = (Map)parameters;
        Optional<String> previousNodeModel = previousNodeInputs.entrySet().stream().filter(e -> "model_id".equals(e.getValue())).map(Map.Entry::getKey).findFirst();
        Optional<String> previousNodeAgent = previousNodeInputs.entrySet().stream().filter(e -> "agent_id".equals(e.getValue())).map(Map.Entry::getKey).findFirst();
        if (previousNodeModel.isPresent() && !parametersMap.containsKey("model_id") && (previousNodeOutput = outputs.get(previousNodeModel.get())) != null && previousNodeOutput.getContent().containsKey("model_id")) {
            parametersMap.put("model_id", previousNodeOutput.getContent().get("model_id").toString());
        }
        if (previousNodeAgent.isPresent() && !parametersMap.containsKey("agent_id") && (previousNodeOutput = outputs.get(previousNodeAgent.get())) != null && previousNodeOutput.getContent().containsKey("agent_id")) {
            parametersMap.put("agent_id", previousNodeOutput.getContent().get("agent_id").toString());
        }
        return parametersMap;
    }
}

