/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.flowframework.common.WorkflowResources;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;
import org.opensearch.ml.client.MachineLearningNodeClient;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.transport.register.MLRegisterModelInput;
import org.opensearch.ml.common.transport.register.MLRegisterModelResponse;

public class RegisterRemoteModelStep
implements WorkflowStep {
    private static final Logger logger = LogManager.getLogger(RegisterRemoteModelStep.class);
    private final MachineLearningNodeClient mlClient;
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;
    public static final String NAME = "register_remote_model";

    public RegisterRemoteModelStep(MachineLearningNodeClient mlClient, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler) {
        this.mlClient = mlClient;
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
    }

    @Override
    public PlainActionFuture<WorkflowData> execute(final String currentNodeId, final WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs) {
        final PlainActionFuture registerRemoteModelFuture = PlainActionFuture.newFuture();
        Set<String> requiredKeys = Set.of("name", "connector_id");
        Set<String> optionalKeys = Set.of("model_group_id", "description", "deploy");
        try {
            Map<String, Object> inputs = ParseUtils.getInputsFromPreviousSteps(requiredKeys, optionalKeys, currentNodeInputs, outputs, previousNodeInputs);
            String modelName = (String)inputs.get("name");
            String modelGroupId = (String)inputs.get("model_group_id");
            String description = (String)inputs.get("description");
            String connectorId = (String)inputs.get("connector_id");
            final Boolean deploy = (Boolean)inputs.get("deploy");
            MLRegisterModelInput.MLRegisterModelInputBuilder builder = MLRegisterModelInput.builder().functionName(FunctionName.REMOTE).modelName(modelName).connectorId(connectorId);
            if (modelGroupId != null) {
                builder.modelGroupId(modelGroupId);
            }
            if (description != null) {
                builder.description(description);
            }
            if (deploy != null) {
                builder.deployModel(deploy.booleanValue());
            }
            MLRegisterModelInput mlInput = builder.build();
            this.mlClient.register(mlInput, (ActionListener)new ActionListener<MLRegisterModelResponse>(){

                public void onResponse(MLRegisterModelResponse mlRegisterModelResponse) {
                    try {
                        logger.info("Remote Model registration successful");
                        String resourceName = WorkflowResources.getResourceByWorkflowStep(RegisterRemoteModelStep.this.getName());
                        RegisterRemoteModelStep.this.flowFrameworkIndicesHandler.updateResourceInStateIndex(currentNodeInputs.getWorkflowId(), currentNodeId, RegisterRemoteModelStep.this.getName(), mlRegisterModelResponse.getModelId(), (ActionListener<UpdateResponse>)ActionListener.wrap(response -> {
                            if (Boolean.TRUE.equals(deploy)) {
                                RegisterRemoteModelStep.this.flowFrameworkIndicesHandler.updateResourceInStateIndex(currentNodeInputs.getWorkflowId(), currentNodeId, "deploy_model", mlRegisterModelResponse.getModelId(), (ActionListener<UpdateResponse>)ActionListener.wrap(deployUpdateResponse -> this.completeRegisterFuture((UpdateResponse)deployUpdateResponse, resourceName, mlRegisterModelResponse), deployUpdateException -> {
                                    logger.error("Failed to update simulated deploy step resource", (Throwable)deployUpdateException);
                                    registerRemoteModelFuture.onFailure((Exception)new FlowFrameworkException(deployUpdateException.getMessage(), ExceptionsHelper.status((Throwable)deployUpdateException)));
                                }));
                            } else {
                                this.completeRegisterFuture((UpdateResponse)response, resourceName, mlRegisterModelResponse);
                            }
                        }, exception -> {
                            logger.error("Failed to update new created resource", (Throwable)exception);
                            registerRemoteModelFuture.onFailure((Exception)new FlowFrameworkException(exception.getMessage(), ExceptionsHelper.status((Throwable)exception)));
                        }));
                    }
                    catch (Exception e) {
                        logger.error("Failed to parse and update new created resource", (Throwable)e);
                        registerRemoteModelFuture.onFailure((Exception)new FlowFrameworkException(e.getMessage(), ExceptionsHelper.status((Throwable)e)));
                    }
                }

                void completeRegisterFuture(UpdateResponse response, String resourceName, MLRegisterModelResponse mlRegisterModelResponse) {
                    logger.info("successfully updated resources created in state index: {}", (Object)response.getIndex());
                    registerRemoteModelFuture.onResponse((Object)new WorkflowData(Map.ofEntries(Map.entry(resourceName, mlRegisterModelResponse.getModelId()), Map.entry("register_model_status", mlRegisterModelResponse.getStatus())), currentNodeInputs.getWorkflowId(), currentNodeInputs.getNodeId()));
                }

                public void onFailure(Exception e) {
                    logger.error("Failed to register remote model");
                    registerRemoteModelFuture.onFailure((Exception)new FlowFrameworkException(e.getMessage(), ExceptionsHelper.status((Throwable)e)));
                }
            });
        }
        catch (FlowFrameworkException e) {
            registerRemoteModelFuture.onFailure((Exception)e);
        }
        return registerRemoteModelFuture;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

