/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.flowframework.common.WorkflowResources;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;
import org.opensearch.ml.client.MachineLearningNodeClient;
import org.opensearch.ml.common.AccessMode;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupInput;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupResponse;

public class RegisterModelGroupStep
implements WorkflowStep {
    private static final Logger logger = LogManager.getLogger(RegisterModelGroupStep.class);
    private final MachineLearningNodeClient mlClient;
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;
    public static final String NAME = "register_model_group";

    public RegisterModelGroupStep(MachineLearningNodeClient mlClient, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler) {
        this.mlClient = mlClient;
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
    }

    @Override
    public PlainActionFuture<WorkflowData> execute(final String currentNodeId, final WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs) {
        final PlainActionFuture registerModelGroupFuture = PlainActionFuture.newFuture();
        ActionListener<MLRegisterModelGroupResponse> actionListener = new ActionListener<MLRegisterModelGroupResponse>(){

            public void onResponse(MLRegisterModelGroupResponse mlRegisterModelGroupResponse) {
                try {
                    logger.info("Model group registration successful");
                    String resourceName = WorkflowResources.getResourceByWorkflowStep(RegisterModelGroupStep.this.getName());
                    RegisterModelGroupStep.this.flowFrameworkIndicesHandler.updateResourceInStateIndex(currentNodeInputs.getWorkflowId(), currentNodeId, RegisterModelGroupStep.this.getName(), mlRegisterModelGroupResponse.getModelGroupId(), (ActionListener<UpdateResponse>)ActionListener.wrap(updateResponse -> {
                        logger.info("successfully updated resources created in state index: {}", (Object)updateResponse.getIndex());
                        registerModelGroupFuture.onResponse((Object)new WorkflowData(Map.ofEntries(Map.entry(resourceName, mlRegisterModelGroupResponse.getModelGroupId()), Map.entry("model_group_status", mlRegisterModelGroupResponse.getStatus())), currentNodeInputs.getWorkflowId(), currentNodeId));
                    }, exception -> {
                        logger.error("Failed to update new created resource", (Throwable)exception);
                        registerModelGroupFuture.onFailure((Exception)new FlowFrameworkException(exception.getMessage(), ExceptionsHelper.status((Throwable)exception)));
                    }));
                }
                catch (Exception e) {
                    logger.error("Failed to parse and update new created resource", (Throwable)e);
                    registerModelGroupFuture.onFailure((Exception)new FlowFrameworkException(e.getMessage(), ExceptionsHelper.status((Throwable)e)));
                }
            }

            public void onFailure(Exception e) {
                logger.error("Failed to register model group");
                registerModelGroupFuture.onFailure((Exception)new FlowFrameworkException(e.getMessage(), ExceptionsHelper.status((Throwable)e)));
            }
        };
        Set<String> requiredKeys = Set.of("name");
        Set<String> optionalKeys = Set.of("description", "backend_roles", "access_mode", "add_all_backend_roles");
        try {
            Map<String, Object> inputs = ParseUtils.getInputsFromPreviousSteps(requiredKeys, optionalKeys, currentNodeInputs, outputs, previousNodeInputs);
            String modelGroupName = (String)inputs.get("name");
            String description = (String)inputs.get("description");
            List<String> backendRoles = this.getBackendRoles(inputs);
            AccessMode modelAccessMode = (AccessMode)inputs.get("access_mode");
            Boolean isAddAllBackendRoles = (Boolean)inputs.get("add_all_backend_roles");
            MLRegisterModelGroupInput.MLRegisterModelGroupInputBuilder builder = MLRegisterModelGroupInput.builder();
            builder.name(modelGroupName);
            if (description != null) {
                builder.description(description);
            }
            if (!CollectionUtils.isEmpty(backendRoles)) {
                builder.backendRoles(backendRoles);
            }
            if (modelAccessMode != null) {
                builder.modelAccessMode(modelAccessMode);
            }
            if (isAddAllBackendRoles != null) {
                builder.isAddAllBackendRoles(isAddAllBackendRoles);
            }
            MLRegisterModelGroupInput mlInput = builder.build();
            this.mlClient.registerModelGroup(mlInput, (ActionListener)actionListener);
        }
        catch (FlowFrameworkException e) {
            registerModelGroupFuture.onFailure((Exception)e);
        }
        return registerModelGroupFuture;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private List<String> getBackendRoles(Map<String, Object> content) {
        if (content.containsKey("backend_roles")) {
            return (List)content.get("backend_roles");
        }
        return Collections.emptyList();
    }
}

