/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.common.Nullable;
import org.opensearch.core.action.ActionListener;
import org.opensearch.flowframework.common.WorkflowResources;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;
import org.opensearch.ml.client.MachineLearningNodeClient;
import org.opensearch.ml.common.agent.LLMSpec;
import org.opensearch.ml.common.agent.MLAgent;
import org.opensearch.ml.common.agent.MLMemorySpec;
import org.opensearch.ml.common.agent.MLToolSpec;
import org.opensearch.ml.common.transport.agent.MLRegisterAgentResponse;

public class RegisterAgentStep
implements WorkflowStep {
    private static final Logger logger = LogManager.getLogger(RegisterAgentStep.class);
    private MachineLearningNodeClient mlClient;
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;
    public static final String NAME = "register_agent";
    public static final String LLM_MODEL_ID = "llm.model_id";
    public static final String LLM_PARAMETERS = "llm.parameters";

    public RegisterAgentStep(MachineLearningNodeClient mlClient, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler) {
        this.mlClient = mlClient;
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
    }

    @Override
    public PlainActionFuture<WorkflowData> execute(final String currentNodeId, WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs) {
        final String workflowId = currentNodeInputs.getWorkflowId();
        final PlainActionFuture registerAgentModelFuture = PlainActionFuture.newFuture();
        ActionListener<MLRegisterAgentResponse> actionListener = new ActionListener<MLRegisterAgentResponse>(){

            public void onResponse(MLRegisterAgentResponse mlRegisterAgentResponse) {
                try {
                    String resourceName = WorkflowResources.getResourceByWorkflowStep(RegisterAgentStep.this.getName());
                    logger.info("Agent registration successful for the agent {}", (Object)mlRegisterAgentResponse.getAgentId());
                    RegisterAgentStep.this.flowFrameworkIndicesHandler.updateResourceInStateIndex(workflowId, currentNodeId, RegisterAgentStep.this.getName(), mlRegisterAgentResponse.getAgentId(), (ActionListener<UpdateResponse>)ActionListener.wrap(response -> {
                        logger.info("successfully updated resources created in state index: {}", (Object)response.getIndex());
                        registerAgentModelFuture.onResponse((Object)new WorkflowData(Map.ofEntries(Map.entry(resourceName, mlRegisterAgentResponse.getAgentId())), workflowId, currentNodeId));
                    }, exception -> {
                        logger.error("Failed to update new created resource", (Throwable)exception);
                        registerAgentModelFuture.onFailure((Exception)new FlowFrameworkException(exception.getMessage(), ExceptionsHelper.status((Throwable)exception)));
                    }));
                }
                catch (Exception e) {
                    logger.error("Failed to parse and update new created resource", (Throwable)e);
                    registerAgentModelFuture.onFailure((Exception)new FlowFrameworkException(e.getMessage(), ExceptionsHelper.status((Throwable)e)));
                }
            }

            public void onFailure(Exception e) {
                logger.error("Failed to register the agent");
                registerAgentModelFuture.onFailure((Exception)new FlowFrameworkException(e.getMessage(), ExceptionsHelper.status((Throwable)e)));
            }
        };
        Set<String> requiredKeys = Set.of("name", "type");
        Set<String> optionalKeys = Set.of("description", LLM_MODEL_ID, LLM_PARAMETERS, "tools", "tools_order", "parameters", "memory", "created_time", "last_updated_time", "app_type");
        try {
            Instant createdTime;
            Map<String, Object> inputs = ParseUtils.getInputsFromPreviousSteps(requiredKeys, optionalKeys, currentNodeInputs, outputs, previousNodeInputs);
            String type = (String)inputs.get("type");
            String name = (String)inputs.get("name");
            String description = (String)inputs.get("description");
            String llmModelId = (String)inputs.get(LLM_MODEL_ID);
            Object llmParams = inputs.get(LLM_PARAMETERS);
            Map<String, String> llmParameters = llmParams == null ? Collections.emptyMap() : ParseUtils.getStringToStringMap(llmParams, LLM_PARAMETERS);
            String[] toolsOrder = (String[])inputs.get("tools_order");
            List<MLToolSpec> toolsList = this.getTools(toolsOrder, previousNodeInputs, outputs);
            Object params = inputs.get("parameters");
            Map parameters = params == null ? Collections.emptyMap() : ParseUtils.getStringToStringMap(params, "parameters");
            MLMemorySpec memory = this.getMLMemorySpec(inputs.get("memory"));
            Instant lastUpdateTime = createdTime = Instant.now();
            String appType = (String)inputs.get("app_type");
            if (llmModelId == null) {
                llmModelId = this.getLlmModelId(previousNodeInputs, outputs);
            }
            LLMSpec llmSpec = this.getLLMSpec(llmModelId, llmParameters, workflowId, currentNodeId);
            MLAgent.MLAgentBuilder builder = MLAgent.builder().name(name);
            if (description != null) {
                builder.description(description);
            }
            if (memory != null) {
                builder.memory(memory);
            }
            if (llmSpec != null) {
                builder.llm(llmSpec);
            }
            builder.type(type).tools(toolsList).parameters(parameters).createdTime(createdTime).lastUpdateTime(lastUpdateTime).appType(appType);
            MLAgent mlAgent = builder.build();
            this.mlClient.registerAgent(mlAgent, (ActionListener)actionListener);
        }
        catch (FlowFrameworkException e) {
            registerAgentModelFuture.onFailure((Exception)e);
        }
        return registerAgentModelFuture;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private List<MLToolSpec> getTools(@Nullable String[] tools, Map<String, String> previousNodeInputs, Map<String, WorkflowData> outputs) {
        ArrayList<MLToolSpec> mlToolSpecList = new ArrayList<MLToolSpec>();
        List previousNodes = previousNodeInputs.entrySet().stream().filter(e -> "tools".equals(e.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
        List<Object> sortedNodes = tools == null ? new ArrayList() : Arrays.asList(tools);
        previousNodes.removeAll(sortedNodes);
        sortedNodes.addAll(previousNodes);
        sortedNodes.forEach(node -> {
            WorkflowData previousNodeOutput = (WorkflowData)outputs.get(node);
            if (previousNodeOutput != null && previousNodeOutput.getContent().containsKey("tools")) {
                MLToolSpec mlToolSpec = (MLToolSpec)previousNodeOutput.getContent().get("tools");
                logger.info("Tool added {}", (Object)mlToolSpec.getType());
                mlToolSpecList.add(mlToolSpec);
            }
        });
        return mlToolSpecList;
    }

    private String getLlmModelId(Map<String, String> previousNodeInputs, Map<String, WorkflowData> outputs) {
        Object modelId;
        WorkflowData previousNodeOutput;
        Optional<String> previousNode = previousNodeInputs.entrySet().stream().filter(e -> "model_id".equals(e.getValue())).map(Map.Entry::getKey).findFirst();
        if (previousNode.isPresent() && (previousNodeOutput = outputs.get(previousNode.get())) != null && (modelId = previousNodeOutput.getContent().getOrDefault(LLM_MODEL_ID, previousNodeOutput.getContent().get("model_id"))) != null) {
            return modelId.toString();
        }
        return null;
    }

    private LLMSpec getLLMSpec(String llmModelId, Map<String, String> llmParameters, String workflowId, String currentNodeId) {
        if (llmModelId == null) {
            return null;
        }
        LLMSpec.LLMSpecBuilder builder = LLMSpec.builder();
        builder.modelId(llmModelId);
        if (llmParameters != null) {
            builder.parameters(llmParameters);
        }
        return builder.build();
    }

    private MLMemorySpec getMLMemorySpec(Object mlMemory) {
        if (mlMemory == null) {
            return null;
        }
        Map map = (Map)mlMemory;
        String type = null;
        String sessionId = null;
        Integer windowSize = null;
        type = (String)map.get("type");
        if (type == null) {
            throw new IllegalArgumentException("agent name is null");
        }
        sessionId = (String)map.get("session_id");
        windowSize = (Integer)map.get("window_size");
        MLMemorySpec.MLMemorySpecBuilder builder = MLMemorySpec.builder();
        builder.type(type);
        if (sessionId != null) {
            builder.sessionId(sessionId);
        }
        if (windowSize != null) {
            builder.windowSize(windowSize);
        }
        return builder.build();
    }
}

